/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.openjpa.persistence.merge;

import java.io.Serializable;

public class GrandChildPK implements Serializable {
    private static final long serialVersionUID = 1L;

    private ChildPK child;

    private Integer grandChildKey;

    public ChildPK getChild() {
        return child;
    }

    public void setChild(ChildPK child) {
        this.child = child;
    }

    public Integer getGrandChildKey() {
        return grandChildKey;
    }

    public void setGrandChildKey(Integer grandChildKey) {
        this.grandChildKey = grandChildKey;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((child == null) ? 0 : child.hashCode());
        result =
            prime * result
                + ((grandChildKey == null) ? 0 : grandChildKey.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        GrandChildPK other = (GrandChildPK) obj;
        if (child == null) {
            if (other.child != null)
                return false;
        } else if (!child.equals(other.child))
            return false;
        if (grandChildKey == null) {
            if (other.grandChildKey != null)
                return false;
        } else if (!grandChildKey.equals(other.grandChildKey))
            return false;
        return true;
    }
}
