//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Process
 *
 *  Copyright 2005-2023 Airbus-EDF-IMACS-ONERA-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTSTOCHASTICPROCESS_HXX
#define OPENTURNS_OTSTOCHASTICPROCESS_HXX

#include "openturns/ARMA.hxx"
#include "openturns/ARMACoefficients.hxx"
#include "openturns/ARMAState.hxx"
#include "openturns/SpectralGaussianProcess.hxx"
#include "openturns/GaussianProcess.hxx"
#include "openturns/WhiteNoise.hxx"
#include "openturns/RandomWalk.hxx"
#include "openturns/DiscreteMarkovChain.hxx"
#include "openturns/AggregatedProcess.hxx"
#include "openturns/CompositeProcess.hxx"
#include "openturns/FunctionalBasisProcess.hxx"
#include "openturns/ARMAFactoryImplementation.hxx"
#include "openturns/ARMAFactory.hxx"
#include "openturns/WhittleFactory.hxx"
#include "openturns/WhittleFactoryState.hxx"
#include "openturns/ARMALikelihoodFactory.hxx"
#include "openturns/ConditionedGaussianProcess.hxx"
#include "openturns/KarhunenLoeveQuadratureAlgorithm.hxx"
#include "openturns/KarhunenLoeveSVDAlgorithm.hxx"

#endif /* OPENTURNS_OTSTOCHASTICPROCESS_HXX */
