#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# This script is released under the GNU GPLv2

if(description)
{
  script_id(13751);
  script_version ("$Revision: 7711 $");
 
  script_name("Direct Connect hub detection");
  script_tag(name:"risk_factor", value:"None");
 
  desc = "
A Direct Connect 'hub' (or server) is running on this port.  Direct
Connect is a protocol used for peer-to-peer file-sharing as well as
chat, and a hub routes communications among peers.  While any type of
file may be shared, Direct Connect hubs often handle movies, images,
music files, and games, which may not be suitable for use in a 
business environment.

See also : http://en.wikipedia.org/wiki/Direct_connect_file-sharing_application";

  script_description(desc);
 
  summary = "Direct Connect hub detection";
  script_summary(summary);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  family = "Peer-To-Peer File Sharing";
  script_family(family);
  script_dependencie("find_service.nes");
  script_require_ports("Services/DirectConnectHub", 411);

  exit(0);
}



port = get_kb_item("Services/DirectConnectHub");
if (!port) port = 411;
if (!get_port_state(port)) exit(0);


soc = open_sock_tcp(port);
if(soc)
{
	r=recv_line(socket:soc, length:1024);
	if ( ! r ) exit(0);
	if (ereg(pattern:"^\$Lock .+",string:r))
	{
		# Disconnect nicely.
		str="$quit|";
		send(socket:soc,data:str);

		security_warning(port);
	}
	close(soc);
}

