###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for e2fsprogs CESA-2008:0003 centos4 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880085);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "CESA", value: "2008:0003");
  script_cve_id("CVE-2007-5497");
  script_name( "CentOS Update for e2fsprogs CESA-2008:0003 centos4 i386");
  desc = "

  Vulnerability Insight:
  The e2fsprogs packages contain a number of utilities for creating,
  checking, modifying, and correcting any inconsistencies in second and third
  extended (ext2/ext3) file systems.
  
  Multiple integer overflow flaws were found in the way e2fsprogs processes
  file system content. If a victim opens a carefully crafted file system with
  a program using e2fsprogs, it may be possible to execute arbitrary code
  with the permissions of the victim. It may be possible to leverage this
  flaw in a virtualized environment to gain access to other virtualized
  hosts. (CVE-2007-5497)
  
  Red Hat would like to thank Rafal Wojtczuk of McAfee Avert Research for
  responsibly disclosing these issues.
  
  Users of e2fsprogs are advised to upgrade to these updated packages, which
  contain a backported patch to resolve these issues.


  Affected Software/OS:
  e2fsprogs on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-January/014597.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of e2fsprogs");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CentOS4")
{

  if(isrpmvuln(pkg:"e2fsprogs", rpm:"e2fsprogs~1.35~12.11.el4_6.1", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"e2fsprogs-devel", rpm:"e2fsprogs-devel~1.35~12.11.el4_6.1", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
