###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_moodle_cms_detect.nasl 1002 2009-02-26 15:20:35Z feb $
#
# Moodle CMS Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# Modified 2009-03-25 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "

 Overview:
  This host is running moodle.
  Moodle is a Course Management System (CMS), also known as a Learning
  Management System (LMS) or a Virtual Learning Environment (VLE). It
  is a Free web application that educators can use to create effective
  online learning sites.

 See also:
  http://moodle.org/

 Risk factor : None";

if(description)
{
  script_id(800239);
  script_version("Revision: 1.1 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Moodle CMS Version Detection");

  script_description(desc);
  script_summary("Set Version of Moodle CMS in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dirs = make_list("/moodle",cgi_dirs());

foreach dir (dirs) {

 url = string(dir, "/index.php"); 
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);  
 if( buf == NULL )continue;

 if(
    egrep(pattern: "^Set-Cookie: MoodleSession", string: buf) ||
    egrep(pattern: '<a [^>]*href="http://moodle\\.org/"[^>]*><img [^>]*src="pix/moodlelogo.gif"', string: buf)
   )
    { 
       if(strlen(dir)>0) {
         install=dir;
       } else {
         install=string("/");
       }

       version = string("unknown");
       ver = eregmatch(string: buf, pattern: "title=.Moodle ([0-9.]+)\+*.*[(Build: 0-9)]*");
	
       if(!isnull(ver[1])) {
        version = ver[1];
       } else {
        # not really accurate, but better then nothing
	url = string(dir, "/mod/hotpot/README.TXT");
	req = http_get(item:url, port:port);
	buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
 
	if(!isnull(buf)) { 
	 ver = eregmatch(string: buf, pattern: "HotPot module for Moodle ([0-9.]+)"); 
	 if(!isnull(ver[1])) {
	  version = ver[1];
	  not_accurate = TRUE;
	 }  
	}  
       }

       set_kb_item(name:string("www/", port, "/moodle"), value:string(version, " under ", install));
       set_kb_item(name:"Moodle/Version", value:version);

       info = string("None\n\nmoodle Version '");
       info += string(version);
       info += string("' was detected on the remote host in the following directory:\n\n");
       info += string(install, "\n"); 
       if(not_accurate) {
	info += string("\nOpenVAs was not able to extract the exact version number. Further tests on moodle\ncould lead in false positives.\n\n");
       }	 

       desc = ereg_replace(
         string:desc,
         pattern:"None$",
         replace:info
	);  

       security_note(port:port,data:desc);
       exit(0);
  }	
}

exit(0);
