###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_netpbm_detect.nasl 7277 2010-02-16 14:40:29Z feb $
#
# NetPBM Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800470);
  script_version("$Revision: 7732 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Netpbm Version Detection");
  desc = "
  Overview: The script detects the installed version of Netpbm and sets the
  result into KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Check for NetPBM version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

grep = find_bin(prog_name:"grep", sock:sock);
grep = chomp(grep[0]);
garg[0] = "-o";
garg[1] = "-m1";
garg[2] = "-a";
garg[3] = string("Netpbm [0-9.].\\+");

modName = find_file(file_name:"libnetpbm.so", file_path:"/",
                    useregex:TRUE, regexpar:"$", sock:sock);

foreach binaryName (modName)
{
  binaryName = chomp(binaryName);
  arg = garg[0] + " " + garg[1] + " " + garg[2] + " " + raw_string(0x22) +
        garg[3] + raw_string(0x22) + " " + binaryName;

  netpbmVer = get_bin_version(full_prog_name:grep, version_argv:arg,
                              ver_pattern:"Netpbm ([0-9.]+)", sock:sock);
  if(netpbmVer[1] != NULL)
  {
    set_kb_item(name:"NetPBM/Ver", value:netpbmVer[1]);
    security_note(data:"NetPBM version " + netpbmVer[1] +
                       " running at location " + binaryName + 
                       " was detected on the host");
  }
}
ssh_close_connection();
