###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_fuzzylime_cms_detect.nasl 3103 2009-06-30 12:06:24Z jun $
#
# Fuzzylime(cms) Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900583);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Fuzzylime(cms) Version Detection");
  desc = "
  Overview: This script detects the installed version of Fuzzylime(cms)
  and sets the version in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets the KB for the version of Fuzzylime(cms)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

cmsPort = get_http_port(default:80);
if(!cmsPort){
  cmsPort = 80;
}
if(!get_port_state(cmsPort)){
  exit(0);
}

foreach dir (make_list("/cms", "/", "/docs", "/fuzzylime", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:cmsPort);
  rcvRes = http_send_recv(port:cmsPort, data:sndReq);

  if("fuzzylime (cms)" ><rcvRes)
  {
    sndReq = http_get(item:string(dir, "/admin/includes/ver.inc.php"), port:cmsPort);
    rcvRes = http_send_recv(port:cmsPort, data:sndReq);
    if(egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
    {
      cmsVer = egrep(pattern:"^([0-9]\.[0-9]+)", string:rcvRes);
      cmsVer = eregmatch(pattern:"([0-9.]+[a-z]?)", string:cmsVer);
    }
    else
    {
      sndReq = http_get(item:string(dir, "/docs/readme.txt"), port:cmsPort);
      rcvRes = http_send_recv(port:cmsPort, data:sndReq);
      if("fuzzylime (cms)" >< rcvRes){
        cmsVer = eregmatch(pattern:"v([0-9.]+)", string:rcvRes);
      }
    }
    if(cmsVer[1] != NULL){
        set_kb_item(name:"www/"+ cmsPort + "/Fuzzylime(cms)",
                    value:cmsVer[1] + " under " + dir);
        security_note(data:"Fuzzylime(cms) Version " + cmsVer[1] +
                 " running at location " + dir +  " was detected on the host");
    }
 }
}
