###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mozilla_prdts_mult_vuln_feb10_lin.nasl 7388 2010-02-24 16:05:33Z feb $
#
# Mozilla Products Multiple Vulnerabilities feb-10 (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902125);
  script_version("$Revision: 8288 $: 1.0");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1571", "CVE-2010-0159");
  script_bugtraq_id(38287, 38286);
  script_name("Mozilla Products Multiple Vulnerabilities feb-10 (Linux)");
  desc = "
  Overview:
  The host is installed with Mozilla Firefox/Seamonkey/Thunderbird and is prone
  to multiple vulnerabilities.

  Vulnerability Insight:
  - An error exists when handling 'out-of-memory conditions', can be exploited
    to trigger a memory corruption and execute arbitrary code via a specially
    crafted web page.
  - An errors in 'nsBlockFrame::StealFrame()' function in
    'layout/generic/nsBlockFrame.cpp', can be exploited to corrupt memory and
     potentially execute arbitrary code.

  Impact:
  Successful exploitation will let attackers to potentially execute arbitrary
  code or compromise a user's system.

  Impact Level: Application

  Affected Software/OS:
  Seamonkey version prior to 2.0.3
  Thunderbird version prior to 3.0.2
  Firefox version 3.0.x before 3.0.18 and 3.5.x before 3.5.8 on Linux.

  Fix:
  Upgrade to Firefox version 3.0.18 or 3.5.8 or later
  http://www.mozilla.com/en-US/firefox/all.html

  Upgrade to Seamonkey version 2.0.3 or later
  http://www.seamonkey-project.org/releases/

  Upgrade to Thunderbird version 3.0.2 or later
  http://www.mozillamessaging.com/en-US/thunderbird/

  References:
  http://secunia.com/advisories/37242
  http://secunia.com/secunia_research/2009-45/
  http://www.vupen.com/english/advisories/2010/0405
  http://www.mozilla.org/security/announce/2010/mfsa2010-03.html

  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Mozilla Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("General");
  script_dependencies("gb_firefox_detect_lin.nasl", "gb_seamonkey_detect_lin.nasl",
                      "gb_thunderbird_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver", "Seamonkey/Linux/Ver",
                      "Thunderbird/Linux/Ver");
  exit(0);
}


include("version_func.inc");

# Firefox Check
ffVer = get_kb_item("Firefox/Linux/Ver");
if(ffVer)
{
  # Grep for Firefox version 3.0 < 3.0.17 and 3.5 < 3.5.7
  if(version_in_range(version:ffVer, test_version:"3.5", test_version2:"3.5.7") ||
     version_in_range(version:ffVer, test_version:"3.0", test_version2:"3.0.17"))
     {
       security_hole(0);
       exit(0);
     }
}

# Seamonkey Check
smVer = get_kb_item("Seamonkey/Linux/Ver");
if(smVer != NULL)
{
  # Grep for Seamonkey version < 2.0.3
  if(version_is_less(version:smVer, test_version:"2.0.3"))
  {
    security_hole(0);
    exit(0);
  }
}

# Thunderbird Check
tbVer = get_kb_item("Thunderbird/Linux/Ver");
if(tbVer != NULL)
{
  # Grep for Thunderbird version <= 3.0.2
  if(version_is_less_equal(version:tbVer, test_version:"3.0.2")){
    security_hole(0);
  }
}
