Minutes from 7th OpenVDB TSC meeting, Jan. 31, 2019

Attendees: John M., *Jeff* L., *Nick* A., *Ken* M., *Peter* C., *Dan* B., Andrew P.

Additional Attendees: Bruce Chernia (Intel), Thanh Ha

Agenda:

1) Confirmation of quorum
2) Selection of secretary
3) TAC Presentation 2/7 (Ken)
4) SIGGRAPH Course (Ken)
5) Plans and roadmap (all)
6) Release process (Peter)
7) Web site (?)
8) CI/Jira update (Dan)
9) Other?
10) Schedule next meeting

1) Quorum was confirmed

2) Secretary - Dan Bailey.

3) TAC Presentation 2/7

Ken to present a 3-slide summary of the OpenVDB project since being accepted to
ASWF to the TAC. Dan to summarize and send Ken pull request stats before and
after acceptance. Dan and Jeff highlighted the improved process since being part
of ASWF and Peter concurred it had eased his workflow.

A roadmap for further process improvements was mentioned - Peter suggested we
better codify the process for contributing to OpenVDB as a non-TSC member,
including guidelines around code coverage and unit testing as well as a GitHub
check for the CLA. John to check on launch of an official CLA system from LF
using Docusign that would help with this. Thanh mentioned that he thought the
rollout had been delayed slightly.

4) Siggraph Course

Ken has shared a Google doc to collaborate on presentation details. He would
like to see some production-friendly sessions as well as features of the
library. Deadline is 12th February.

5) Plans and roadmap

Nick, Ken, Dan and Jeff all shared summaries of features they wish to
contribute, wish lists and desired library cleanup. Aim to put as much
functionality into the next release in time for next major release of Houdini.

This is intended to be broad bullet-points for now. Some more detail shared
through Google Docs, but a few highlights and points of discussion:

Nick:

* tools to merge, rasterize and surface VDB Points, Jeff suggested where SOPs
didn't support Houdini points to convert them into VDB points on-the-fly
* restructuring SOPs to move implementation details up into core library where
they can be unit tested - Remove Divergence SOP was highlighted as a good
example of where this is needed
* a Reduce SOP for performing deterministic reduction of volumes, Ken suggested
looking at using some of the functionality in tools/Diagnostics.h that solves
some of these problems, Jeff considering extending Volume Reduce SOP to support
VDBs
* performance of Advect SOP compared with Houdini volume advection, Jeff and Ken
mentioned that the bottleneck was the front-tracking that would make it hard to
get comparable performance but perhaps still improvements to be made
* core AX features include sampling and rasterization in order to reach a v1.0
for Siggraph

Ken:

* tools Ken has completed and wishes to push up soon include fast sweeping,
finding all active values within a bounding box, MLS and some higher-level
tools and higher-order alternatives to existing methods
* a more efficient way of building masks from meshes that doesn't use levelsets
* Ken would like a read-only out-of-core grid that allows for random-access with
a memory limit to page data in and out automatically. Jeff suggested looking at
a similar solution in OpenImageIO for inspiration in paging in and out tiles of
textures

Dan:

* wishlist includes distributed computing tools, faster levelset segmentation,
faster resampling of masks and more solvers including multigrid, FFT and
variational solves
* working on some higher-level sample applications
* better parallelization of multiple VDBs through combine SOP, Nick suggested
trying to put the existing combine SOP into a foreach SOP
* various VDB Points improvements include strided attribute arrays, dynamic
attribute arrays, curves and poly soups as well as a SOP to support creation,
delete, casting, renaming, etc of attributes
* extend point moving to support merging additional grids and work with Nick on
coming up with a common API for point merging

Jeff:

* would like to see a GPU representation of OpenVDB, may consider writing one
* 2D grids for OpenVDB would be useful for terrain, Ken mentioned using a
different leaf size but Jeff would like it kept consistent with standard 3D grid
configuration (ie 8x8 voxels)
* Dan asked about SideFX potentially contributing the VDB SOP and VDB Activate
SOP to help to unify open-source/DWA SOPs and SideFX SOPs

6) Release process

Not covered due to time constraints.

7) Web site

John highlighted an issue with the DNS of the website and Peter mentioned that
some of the download links are currently broken. Peter to ask Andrew (who had
just left the meeting).

8/9) CI/Jira update and Other

Jeff has signed into ASWF JIRA now.

Ken now the only TSC member that hasn't signed into JIRA (https://jira.aswf.io)
or accepted GitHub write permissions
(https://github.com/AcademySoftwareFoundation/openvdb/invitations). However, he
does now have a signed CLA from Weta.

10) The next TSC meeting is scheduled for Thursday Feb 14, 2019, 11am-12pm PST.

Note that the meeting scheduled for next week is cancelled due to a clash with
the presentations to the TAC.
