; fat recursion, vector version

(define (flatten-vector x)
  (letrec
    ((f (lambda (x r)
          (cond ((null? x)
                  r)
                ((vector? x)
                  (f (vector-ref x 0)
                     (f (vector-ref x 1) r)))
                (else
                  (cons x r))))))
    (f x '())))

(define (tree n)
  (if (zero? n)
      'x
      (vector (tree (- n 1))
              (tree (- n 1)))))

(if (not (= 524288 (length (flatten-vector (tree 19)))))
    (error "vectree failed"))
