# Release Notes v0.5.0 : New algorithms, Importance Analysis, and Fault Tree Preprocessing

This release introduces a new cut set generation algorithm
that is faster than the previous algorithm.
In addition, the release adds importance analysis
and initial attempts to preprocess and simplify fault trees.
A new analysis engine is introduced for easier preprocessing.


## Major Changes

- New algorithms to efficiently generate cut sets (at least 10x improvement):
    * Early set uniqueness detection
    * Local minimality detection upon cut set expansions
- Fault tree preprocessing:
    * Constant propagation
    * Application of Boolean algebra basics for fault tree simplifications
    * Complex gate expansions for XOR and ATLEAST
    * Original module (independent sub-tree) detection
    * Simple new module creation
- Importance analysis:
    - Fussel-Vesely
    - Birnbaum
    - Critical Importance Factor
    - Risk Reduction Worth
    - Risk Achievement Worth
- Importance factors only for basic events in minimal cut sets. The other basic events are 0 importance.
- Calculations without probability information assume House event state as false.
- Separate consideration for certain basic events for uncertainty analysis:
    * Only basic events with distributions are left in probability equation.
- Multiple input files with fault trees and model data are accepted for analysis.
- Simple logging system for debugging or warning.


## Fixed Bugs

- House events are treated as constant in the fault tree not as regular basic events.
- House events are not included in minimal cut sets or reported with probability information anymore.
- Unity is treated in Boolean algebra for minimal cut  sets. The special case of Unity top gate is handled.
- Repeated children are detected in input files. One gate cannot have the same two children in input.


## Since v0.4.0

- 116 commits resulted in 226 files changed, 5342 insertions(+), 37071 deletions(-)
