#define XERR
#include "loop.ih"

void Loop::writeData(CSVTable &tab, size_t idx) const
{
    tab.more() << idx <<                                        //  1
           (d_status >= TUMOR_PRE ? "Tumor" : "Natural") <<     //  2
           d_deathAge << d_naturalDeathAge << d_status;         //  3 - 5

    d_tumor.writeData(tab);                                     //  6 - 14

    ostringstream out;
    if (Globals::isZero(d_tumor.diameter()))
        (*d_tnm)(out);
    else
    {                                                   // set the tumor S3
        RowCol rowCol = d_tumor.rowCol();               // row/col. For BC
        out << rowCol.first << ',' << rowCol.second;    // row is bc: TNM, col
    }                                                   // = 0 (via Survival::
                                                        // setVSD

    tab << static_cast<size_t>(round(d_caseCost)) <<            // 15
           d_selfDetected << d_roundDetected << d_roundInfo <<  // 16 - 18
           out.str();                                           // 19
}
