/* Public domain. */

#include <sys/time.h>
#include <errno.h>
#include "tai.h"

int taia_from_timeval (struct taia *a, struct timeval const *tv)
{
  if (tv->tv_usec < 0) return (errno = EINVAL, 0) ;
  tai_unix(taia_secp(a), tv->tv_sec) ;
  a->nano = 1000 * tv->tv_usec ;
  a->atto = 0 ;
  return 1 ;
}
