/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.extension.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.extension.MetaDataExtension;
import org.apache.camel.component.extension.metadata.DefaultMetaData;

public final class MetaDataBuilder {
    private final CamelContext camelContext;
    private Object payload;
    private Map<String, Object> attributes;

    private MetaDataBuilder(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public MetaDataBuilder withPayload(Object payload) {
        this.payload = payload;
        return this;
    }

    public MetaDataBuilder withAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
        return this;
    }

    public MetaDataExtension.MetaData build() {
        return new DefaultMetaData(this.camelContext, this.attributes == null ? Collections.emptyMap() : this.attributes, this.payload);
    }

    public static MetaDataBuilder on(CamelContext camelContext) {
        return new MetaDataBuilder(camelContext);
    }
}

