/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import org.hsqldb.Database;
import org.hsqldb.Trace;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.Storage;
import org.hsqldb.persist.ScaledRAFileInJar;
import org.hsqldb.persist.ScaledRAInterface;

class ScaledRAFile
implements ScaledRAInterface {
    static final int DATA_FILE_RAF = 0;
    static final int DATA_FILE_NIO = 1;
    static final int DATA_FILE_JAR = 2;
    static final long MAX_NIO_LENGTH = 0x10000000L;
    final SimpleLog appLog;
    final RandomAccessFile file;
    private final boolean readOnly;
    final String fileName;
    boolean isNio;
    boolean bufferDirty = true;
    final byte[] buffer;
    final HsqlByteArrayInputStream ba;
    long bufferOffset;
    long seekPosition;
    long realPosition;
    static int cacheHit;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$hsqldb$Database;

    static Storage newScaledRAFile(Database database, String string, boolean bl, int n, String string2, String string3) throws FileNotFoundException, IOException {
        if (string2 != null) {
            try {
                Object object;
                Class<?> clazz = null;
                try {
                    object = Thread.currentThread().getContextClassLoader();
                    clazz = ((ClassLoader)object).loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = Class.forName(string2);
                }
                object = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ScaledRAFile.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ScaledRAFile.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Object == null ? (class$java$lang$Object = ScaledRAFile.class$("java.lang.Object")) : class$java$lang$Object);
                return (Storage)((Constructor)object).newInstance(string, new Boolean(bl), string3);
            }
            catch (Exception exception) {
                throw new IOException(Trace.getMessage(257, true, new Object[]{exception.toString()}));
            }
        }
        if (n == 2) {
            return new ScaledRAFileInJar(string);
        }
        if (n == 0) {
            return new ScaledRAFile(database, string, bl);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, bl ? "r" : "rw");
        if (randomAccessFile.length() > 0x10000000L) {
            return new ScaledRAFile(database, string, randomAccessFile, bl);
        }
        randomAccessFile.close();
        try {
            Class.forName("java.nio.MappedByteBuffer");
            Class<?> clazz = Class.forName("org.hsqldb.persist.ScaledRAFileHybrid");
            Constructor<?> constructor = clazz.getConstructor(class$org$hsqldb$Database == null ? (class$org$hsqldb$Database = ScaledRAFile.class$("org.hsqldb.Database")) : class$org$hsqldb$Database, class$java$lang$String == null ? (class$java$lang$String = ScaledRAFile.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE);
            return (ScaledRAInterface)constructor.newInstance(database, string, new Boolean(bl));
        }
        catch (Exception exception) {
            return new ScaledRAFile(database, string, bl);
        }
    }

    ScaledRAFile(Database database, String string, RandomAccessFile randomAccessFile, boolean bl) throws FileNotFoundException, IOException {
        this.appLog = database.logger.appLog;
        this.readOnly = bl;
        this.fileName = string;
        this.file = randomAccessFile;
        int n = database.getProperties().getIntegerProperty("hsqldb.raf_buffer_scale", 12, 8, 13);
        int n2 = 1 << n;
        this.buffer = new byte[n2];
        this.ba = new HsqlByteArrayInputStream(this.buffer);
    }

    ScaledRAFile(Database database, String string, boolean bl) throws FileNotFoundException, IOException {
        this.appLog = database.logger.appLog;
        this.readOnly = bl;
        this.fileName = string;
        this.file = new RandomAccessFile(string, bl ? "r" : "rw");
        int n = database.getProperties().getIntegerProperty("hsqldb.raf_buffer_scale", 12);
        int n2 = 1 << n;
        this.buffer = new byte[n2];
        this.ba = new HsqlByteArrayInputStream(this.buffer);
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public void seek(long l) throws IOException {
        if (!this.readOnly && this.file.length() < l) {
            long l2 = l - this.file.length();
            if (l2 > 262144L) {
                l2 = 262144L;
            }
            byte[] byArray = new byte[(int)l2];
            try {
                long l3;
                for (l3 = this.file.length(); l3 < l - l2; l3 += l2) {
                    this.file.seek(l3);
                    this.file.write(byArray, 0, (int)l2);
                }
                this.file.seek(l3);
                this.file.write(byArray, 0, (int)(l - l3));
                this.realPosition = l;
            }
            catch (IOException iOException) {
                this.appLog.logContext(iOException, null);
                throw iOException;
            }
        }
        this.seekPosition = l;
    }

    public long getFilePointer() throws IOException {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        long l = this.seekPosition;
        long l2 = l % (long)this.buffer.length;
        long l3 = this.file.length();
        long l4 = l3 - (l - l2);
        try {
            if (l4 <= 0L) {
                throw new IOException("read beyond end of file");
            }
            if (l4 > (long)this.buffer.length) {
                l4 = this.buffer.length;
            }
            this.file.seek(l - l2);
            this.file.readFully(this.buffer, 0, (int)l4);
            this.bufferOffset = l - l2;
            this.realPosition = this.bufferOffset + l4;
            this.bufferDirty = false;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.appLog.logContext(iOException, "" + this.realPosition + " " + l4);
            throw iOException;
        }
    }

    public int read() throws IOException {
        try {
            long l = this.file.length();
            if (this.seekPosition >= l) {
                return -1;
            }
            if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++cacheHit;
            }
            this.ba.reset();
            this.ba.skip(this.seekPosition - this.bufferOffset);
            int n = this.ba.read();
            ++this.seekPosition;
            return n;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.appLog.logContext(iOException, null);
            throw iOException;
        }
    }

    public long readLong() throws IOException {
        try {
            long l;
            if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++cacheHit;
            }
            this.ba.reset();
            if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            try {
                l = this.ba.readLong();
            }
            catch (EOFException eOFException) {
                this.file.seek(this.seekPosition);
                l = this.file.readLong();
                this.realPosition = this.file.getFilePointer();
            }
            this.seekPosition += 8L;
            return l;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.appLog.logContext(iOException, null);
            throw iOException;
        }
    }

    public int readInt() throws IOException {
        try {
            int n;
            if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++cacheHit;
            }
            this.ba.reset();
            if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            try {
                n = this.ba.readInt();
            }
            catch (EOFException eOFException) {
                this.file.seek(this.seekPosition);
                n = this.file.readInt();
                this.realPosition = this.file.getFilePointer();
            }
            this.seekPosition += 4L;
            return n;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.appLog.logContext(iOException, null);
            throw iOException;
        }
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        try {
            if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++cacheHit;
            }
            this.ba.reset();
            if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            int n3 = this.ba.read(byArray, n, n2);
            this.seekPosition += (long)n3;
            if (n3 < n2) {
                if (this.seekPosition != this.realPosition) {
                    this.file.seek(this.seekPosition);
                }
                this.file.readFully(byArray, n + n3, n2 - n3);
                this.seekPosition += (long)(n2 - n3);
                this.realPosition = this.seekPosition;
            }
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.appLog.logContext(iOException, null);
            throw iOException;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            if (this.realPosition != this.seekPosition) {
                this.file.seek(this.seekPosition);
                this.realPosition = this.seekPosition;
            }
            if (this.seekPosition >= this.bufferOffset && this.seekPosition < this.bufferOffset + (long)this.buffer.length) {
                this.bufferDirty = true;
            }
            this.file.write(byArray, n, n2);
            this.seekPosition += (long)n2;
            this.realPosition = this.seekPosition;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.appLog.logContext(iOException, null);
            throw iOException;
        }
    }

    public void writeInt(int n) throws IOException {
        try {
            if (this.realPosition != this.seekPosition) {
                this.file.seek(this.seekPosition);
                this.realPosition = this.seekPosition;
            }
            if (this.seekPosition >= this.bufferOffset && this.seekPosition < this.bufferOffset + (long)this.buffer.length) {
                this.bufferDirty = true;
            }
            this.file.writeInt(n);
            this.seekPosition += 4L;
            this.realPosition = this.seekPosition;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.appLog.logContext(iOException, null);
            throw iOException;
        }
    }

    public void writeLong(long l) throws IOException {
        try {
            if (this.realPosition != this.seekPosition) {
                this.file.seek(this.seekPosition);
                this.realPosition = this.seekPosition;
            }
            if (this.seekPosition >= this.bufferOffset && this.seekPosition < this.bufferOffset + (long)this.buffer.length) {
                this.bufferDirty = true;
            }
            this.file.writeLong(l);
            this.seekPosition += 8L;
            this.realPosition = this.seekPosition;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.appLog.logContext(iOException, null);
            throw iOException;
        }
    }

    public void close() throws IOException {
        Trace.printSystemOut("cache hit " + cacheHit);
        this.file.close();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean wasNio() {
        return false;
    }

    public boolean canAccess(int n) {
        return true;
    }

    public boolean canSeek(long l) {
        return true;
    }

    public Database getDatabase() {
        return null;
    }

    private void resetPointer() {
        try {
            this.bufferDirty = true;
            this.file.seek(this.seekPosition);
            this.realPosition = this.seekPosition;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

