/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.ArrayList;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientTest;
import org.apache.zookeeper.test.JMXEnv;
import org.apache.zookeeper.test.QuorumBaseOracle_2Nodes;
import org.apache.zookeeper.test.QuorumMajorityTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumOracleMajTest
extends QuorumBaseOracle_2Nodes {
    protected static final Logger LOG = LoggerFactory.getLogger(QuorumMajorityTest.class);
    public static final long CONNECTION_TIMEOUT = ClientTest.CONNECTION_TIMEOUT;

    @Test
    public void testMajQuorums() throws Throwable {
        LOG.info("Verify QuorumPeer#electionTimeTaken jmx bean attribute");
        ArrayList<QuorumPeer> peers = this.getPeerList();
        for (int i = 1; i <= peers.size(); ++i) {
            QuorumPeer qp = peers.get(i - 1);
            Long electionTimeTaken = -1L;
            String bean = "";
            if (qp.getPeerState() == QuorumPeer.ServerState.FOLLOWING) {
                bean = String.format("%s:name0=ReplicatedServer_id%d,name1=replica.%d,name2=Follower", "org.apache.ZooKeeperService", i, i);
            } else if (qp.getPeerState() == QuorumPeer.ServerState.LEADING) {
                bean = String.format("%s:name0=ReplicatedServer_id%d,name1=replica.%d,name2=Leader", "org.apache.ZooKeeperService", i, i);
            }
            electionTimeTaken = (Long)JMXEnv.ensureBeanAttribute(bean, "ElectionTimeTaken");
            Assertions.assertTrue((electionTimeTaken >= 0L ? 1 : 0) != 0, (String)"Wrong electionTimeTaken value!");
        }
        this.tearDown();
        this.setUp();
        int leader = this.getLeaderIndex();
        QuorumPeer s = leader == 1 ? this.s1 : this.s2;
        this.noDropConectionTest(s);
        this.dropConnectionTest(s, leader);
    }

    private void noDropConectionTest(QuorumPeer s) {
        Leader.Proposal p = new Leader.Proposal();
        p.addQuorumVerifier(s.getQuorumVerifier());
        p.addAck(Long.valueOf(1L));
        Assertions.assertEquals((Object)false, (Object)p.hasAllQuorums());
        p.addAck(Long.valueOf(6L));
        Assertions.assertEquals((Object)false, (Object)p.hasAllQuorums());
        p.addAck(Long.valueOf(2L));
        Assertions.assertEquals((Object)true, (Object)p.hasAllQuorums());
    }

    private void dropConnectionTest(QuorumPeer s, int leader) {
        Leader.Proposal p = new Leader.Proposal();
        p.addQuorumVerifier(s.getQuorumVerifier());
        ArrayList fake = new ArrayList();
        Object f = null;
        fake.add(f);
        s.getQuorumVerifier().updateNeedOracle(fake);
        Assertions.assertEquals((Object)false, (Object)s.getQuorumVerifier().getNeedOracle());
        fake.remove(0);
        s.getQuorumVerifier().updateNeedOracle(fake);
        Assertions.assertEquals((Object)true, (Object)s.getQuorumVerifier().getNeedOracle());
        Assertions.assertEquals((Object)(leader != 1 ? 1 : 0), (Object)p.hasAllQuorums());
    }
}

