/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconfigExceptionTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ReconfigExceptionTest.class);
    private static String authProvider = "zookeeper.DigestAuthenticationProvider.superDigest";
    private static String superDigest = "super:D/InIHSb7yEEbrWz8b9l71RjZJU=";
    private QuorumUtil qu;
    private ZooKeeperAdmin zkAdmin;

    @BeforeEach
    public void setup() throws InterruptedException {
        System.setProperty(authProvider, superDigest);
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        try {
            this.qu.startAll();
        }
        catch (IOException e) {
            Assertions.fail((String)"Fail to start quorum servers.");
        }
        this.resetZKAdmin();
    }

    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty(authProvider);
        try {
            if (this.qu != null) {
                this.qu.tearDown();
            }
            if (this.zkAdmin != null) {
                this.zkAdmin.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    @Timeout(value=10L)
    public void testReconfigDisabled() throws InterruptedException {
        QuorumPeerConfig.setReconfigEnabled((boolean)false);
        this.qu.shutdownAll();
        try {
            this.qu.startAll();
        }
        catch (IOException e) {
            Assertions.fail((String)"Fail to start quorum servers.");
        }
        try {
            this.reconfigPort();
            Assertions.fail((String)"Reconfig should be disabled.");
        }
        catch (KeeperException e) {
            Assertions.assertTrue((e.code() == KeeperException.Code.RECONFIGDISABLED ? 1 : 0) != 0);
        }
    }

    @Test
    @Timeout(value=10L)
    public void testReconfigFailWithoutAuth() throws InterruptedException {
        try {
            this.reconfigPort();
            Assertions.fail((String)"Reconfig should fail without auth.");
        }
        catch (KeeperException e) {
            Assertions.assertTrue((e.code() == KeeperException.Code.NOAUTH ? 1 : 0) != 0);
        }
    }

    @Test
    @Timeout(value=10L)
    public void testReconfigEnabledWithSuperUser() throws InterruptedException {
        try {
            this.zkAdmin.addAuthInfo("digest", "super:test".getBytes());
            Assertions.assertTrue((boolean)this.reconfigPort());
        }
        catch (KeeperException e) {
            Assertions.fail((String)("Reconfig should not fail, but failed with exception : " + e.getMessage()));
        }
    }

    @Test
    @Timeout(value=10L)
    public void testReconfigFailWithAuthWithNoACL() throws InterruptedException {
        this.resetZKAdmin();
        try {
            this.zkAdmin.addAuthInfo("digest", "user:test".getBytes());
            this.reconfigPort();
            Assertions.fail((String)"Reconfig should fail without a valid ACL associated with user.");
        }
        catch (KeeperException e) {
            Assertions.assertTrue((e.code() == KeeperException.Code.NOAUTH ? 1 : 0) != 0);
        }
    }

    @Test
    @Timeout(value=10L)
    public void testReconfigEnabledWithAuthAndWrongACL() throws InterruptedException {
        this.resetZKAdmin();
        try {
            this.zkAdmin.addAuthInfo("digest", "super:test".getBytes());
            ArrayList<ACL> acls = new ArrayList<ACL>(Collections.singletonList(new ACL(1, new Id("digest", "user:tl+z3z0vO6PfPfEENfLF96E6pM0="))));
            this.zkAdmin.setACL("/zookeeper/config", acls, -1);
            this.resetZKAdmin();
            this.zkAdmin.addAuthInfo("digest", "user:test".getBytes());
            this.reconfigPort();
            Assertions.fail((String)"Reconfig should fail with an ACL that is read only!");
        }
        catch (KeeperException e) {
            Assertions.assertTrue((e.code() == KeeperException.Code.NOAUTH ? 1 : 0) != 0);
        }
    }

    @Test
    @Timeout(value=10L)
    public void testReconfigEnabledWithAuthAndACL() throws InterruptedException {
        this.resetZKAdmin();
        try {
            this.zkAdmin.addAuthInfo("digest", "super:test".getBytes());
            ArrayList<ACL> acls = new ArrayList<ACL>(Collections.singletonList(new ACL(2, new Id("digest", "user:tl+z3z0vO6PfPfEENfLF96E6pM0="))));
            this.zkAdmin.setACL("/zookeeper/config", acls, -1);
            this.resetZKAdmin();
            this.zkAdmin.addAuthInfo("digest", "user:test".getBytes());
            Assertions.assertTrue((boolean)this.reconfigPort());
        }
        catch (KeeperException e) {
            Assertions.fail((String)("Reconfig should not fail, but failed with exception : " + e.getMessage()));
        }
    }

    private void resetZKAdmin() throws InterruptedException {
        String cnxString;
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        try {
            cnxString = "127.0.0.1:" + this.qu.getPeer((int)1).peer.getClientPort();
            if (this.zkAdmin != null) {
                this.zkAdmin.close();
            }
            this.zkAdmin = new ZooKeeperAdmin(cnxString, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        }
        catch (IOException e) {
            Assertions.fail((String)"Fail to create ZooKeeperAdmin handle.");
            return;
        }
        try {
            watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        }
        catch (InterruptedException | TimeoutException e) {
            Assertions.fail((String)("ZooKeeper admin client can not connect to " + cnxString));
        }
    }

    private boolean reconfigPort() throws KeeperException, InterruptedException {
        ArrayList<String> joiningServers = new ArrayList<String>();
        int leaderId = 1;
        while (this.qu.getPeer((int)leaderId).peer.leader == null) {
            ++leaderId;
        }
        int followerId = leaderId == 1 ? 2 : 1;
        joiningServers.add("server." + followerId + "=localhost:" + this.qu.getPeer((int)followerId).peer.getQuorumAddress().getAllPorts().get(0) + ":" + this.qu.getPeer((int)followerId).peer.getElectionAddress().getAllPorts().get(0) + ":participant;localhost:" + PortAssignment.unique());
        this.zkAdmin.reconfigure(joiningServers, null, null, -1L, new Stat());
        return true;
    }
}

