/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	kedav1alpha1 "github.com/apache/camel-k/v2/pkg/apis/duck/keda/v1alpha1"
	scheme "github.com/apache/camel-k/v2/pkg/client/keda/clientset/internalclientset/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// ScaledObjectsGetter has a method to return a ScaledObjectInterface.
// A group's client should implement this interface.
type ScaledObjectsGetter interface {
	ScaledObjects(namespace string) ScaledObjectInterface
}

// ScaledObjectInterface has methods to work with ScaledObject resources.
type ScaledObjectInterface interface {
	Get(ctx context.Context, name string, opts v1.GetOptions) (*kedav1alpha1.ScaledObject, error)
	List(ctx context.Context, opts v1.ListOptions) (*kedav1alpha1.ScaledObjectList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	ScaledObjectExpansion
}

// scaledObjects implements ScaledObjectInterface
type scaledObjects struct {
	*gentype.ClientWithList[*kedav1alpha1.ScaledObject, *kedav1alpha1.ScaledObjectList]
}

// newScaledObjects returns a ScaledObjects
func newScaledObjects(c *KedaV1alpha1Client, namespace string) *scaledObjects {
	return &scaledObjects{
		gentype.NewClientWithList[*kedav1alpha1.ScaledObject, *kedav1alpha1.ScaledObjectList](
			"scaledobjects",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *kedav1alpha1.ScaledObject { return &kedav1alpha1.ScaledObject{} },
			func() *kedav1alpha1.ScaledObjectList { return &kedav1alpha1.ScaledObjectList{} },
		),
	}
}
