/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.httpsecuredsink;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelHttpsecuredsinkSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_URL_CONF = "camel.kamelet.http-secured-sink.url";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_URL_DOC = "The URL to send data to Example: https://my-service/path";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_URL_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_METHOD_CONF = "camel.kamelet.http-secured-sink.method";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_METHOD_DOC = "The HTTP method to use";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_METHOD_DEFAULT = "POST";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_METHOD_CONF = "camel.kamelet.http-secured-sink.authMethod";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_METHOD_DOC = "Authentication methods allowed to use as a comma separated list of values Basic, Digest or NTLM.";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_METHOD_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTHENTICATION_PREEMPTIVE_CONF = "camel.kamelet.http-secured-sink.authenticationPreemptive";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTHENTICATION_PREEMPTIVE_DOC = "If this option is true, camel-http sends preemptive basic authentication to the server.";
    public static final Boolean CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTHENTICATION_PREEMPTIVE_DEFAULT = false;
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_USERNAME_CONF = "camel.kamelet.http-secured-sink.authUsername";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_USERNAME_DOC = "Authentication username";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_PASSWORD_CONF = "camel.kamelet.http-secured-sink.authPassword";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_PASSWORD_DOC = "Authentication password";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2CLIENT_ID_CONF = "camel.kamelet.http-secured-sink.oauth2ClientId";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2CLIENT_ID_DOC = "Oauth2 Client Id";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2CLIENT_ID_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2CLIENT_SECRET_CONF = "camel.kamelet.http-secured-sink.oauth2ClientSecret";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2CLIENT_SECRET_DOC = "Oauth2 Client Secret";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2CLIENT_SECRET_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2TOKEN_ENDPOINT_CONF = "camel.kamelet.http-secured-sink.oauth2TokenEndpoint";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2TOKEN_ENDPOINT_DOC = "Oauth2 Token Endpoint";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2TOKEN_ENDPOINT_DEFAULT = null;
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2SCOPE_CONF = "camel.kamelet.http-secured-sink.oauth2Scope";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2SCOPE_DOC = "Oauth2 Scope";
    public static final String CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2SCOPE_DEFAULT = null;

    public CamelHttpsecuredsinkSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelHttpsecuredsinkSinkConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_HTTPSECUREDSINK_KAMELET_URL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_URL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_URL_DOC);
        conf.define(CAMEL_SINK_HTTPSECUREDSINK_KAMELET_METHOD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_METHOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_METHOD_DOC);
        conf.define(CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_METHOD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_METHOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_METHOD_DOC);
        conf.define(CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTHENTICATION_PREEMPTIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTHENTICATION_PREEMPTIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTHENTICATION_PREEMPTIVE_DOC);
        conf.define(CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_USERNAME_DOC);
        conf.define(CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_AUTH_PASSWORD_DOC);
        conf.define(CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2CLIENT_ID_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2CLIENT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2CLIENT_ID_DOC);
        conf.define(CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2CLIENT_SECRET_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2CLIENT_SECRET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2CLIENT_SECRET_DOC);
        conf.define(CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2TOKEN_ENDPOINT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2TOKEN_ENDPOINT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2TOKEN_ENDPOINT_DOC);
        conf.define(CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2SCOPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2SCOPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_HTTPSECUREDSINK_KAMELET_OAUTH_2SCOPE_DOC);
        return conf;
    }
}