/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;

class GossipDigestSerializer
implements IVersionedSerializer<GossipDigest> {
    GossipDigestSerializer() {
    }

    @Override
    public void serialize(GossipDigest gDigest, DataOutputPlus out, int version) throws IOException {
        CompactEndpointSerializationHelper.serialize(gDigest.endpoint, out);
        out.writeInt(gDigest.generation);
        out.writeInt(gDigest.maxVersion);
    }

    @Override
    public GossipDigest deserialize(DataInputPlus in, int version) throws IOException {
        InetAddress endpoint = CompactEndpointSerializationHelper.deserialize(in);
        int generation = in.readInt();
        int maxVersion = in.readInt();
        return new GossipDigest(endpoint, generation, maxVersion);
    }

    @Override
    public long serializedSize(GossipDigest gDigest, int version) {
        long size = CompactEndpointSerializationHelper.serializedSize(gDigest.endpoint);
        size += (long)TypeSizes.sizeof(gDigest.generation);
        return size += (long)TypeSizes.sizeof(gDigest.maxVersion);
    }
}

