/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.CompactionStrategyManager;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.Scrubber;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.tools.BulkLoader;
import org.apache.cassandra.tools.Util;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;

public class StandaloneScrubber {
    public static final String REINSERT_OVERFLOWED_TTL_OPTION_DESCRIPTION = "Rewrites rows with overflowed expiration date affected by CASSANDRA-14092 with the maximum supported expiration date of 2038-01-19T03:14:06+00:00. The rows are rewritten with the original timestamp incremented by one millisecond to override/supersede any potential tombstone that may have been generated during compaction of the affected rows.";
    private static final String TOOL_NAME = "sstablescrub";
    private static final String VERBOSE_OPTION = "verbose";
    private static final String DEBUG_OPTION = "debug";
    private static final String HELP_OPTION = "help";
    private static final String MANIFEST_CHECK_OPTION = "manifest-check";
    private static final String SKIP_CORRUPTED_OPTION = "skip-corrupted";
    private static final String NO_VALIDATE_OPTION = "no-validate";
    private static final String REINSERT_OVERFLOWED_TTL_OPTION = "reinsert-overflowed-ttl";

    public static void main(String[] args) {
        Options options = Options.parseArgs(args);
        Util.initDatabaseDescriptor();
        try {
            Schema.instance.loadFromDisk(false);
            if (Schema.instance.getKSMetaData(options.keyspaceName) == null) {
                throw new IllegalArgumentException(String.format("Unknown keyspace %s", options.keyspaceName));
            }
            Keyspace keyspace = Keyspace.openWithoutSSTables(options.keyspaceName);
            ColumnFamilyStore cfs = null;
            for (ColumnFamilyStore c : keyspace.getValidColumnFamilies(true, false, options.cfName)) {
                if (!c.name.equals(options.cfName)) continue;
                cfs = c;
                break;
            }
            if (cfs == null) {
                throw new IllegalArgumentException(String.format("Unknown table %s.%s", options.keyspaceName, options.cfName));
            }
            String snapshotName = "pre-scrub-" + System.currentTimeMillis();
            OutputHandler.SystemOutput handler = new OutputHandler.SystemOutput(options.verbose, options.debug);
            Directories.SSTableLister lister = cfs.getDirectories().sstableLister(Directories.OnTxnErr.THROW).skipTemporary(true);
            ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
            for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
                Set<Component> components = entry.getValue();
                if (!components.contains(Component.DATA)) continue;
                try {
                    SSTableReader sstable = SSTableReader.openNoValidation(entry.getKey(), components, cfs);
                    sstables.add(sstable);
                    File snapshotDirectory = Directories.getSnapshotDirectory(sstable.descriptor, snapshotName);
                    sstable.createLinks(snapshotDirectory.getPath());
                }
                catch (Exception e) {
                    JVMStabilityInspector.inspectThrowable(e);
                    System.err.println(String.format("Error Loading %s: %s", entry.getKey(), e.getMessage()));
                    if (!options.debug) continue;
                    e.printStackTrace(System.err);
                }
            }
            System.out.println(String.format("Pre-scrub sstables snapshotted into snapshot %s", snapshotName));
            if (!options.manifestCheckOnly) {
                for (SSTableReader sstable : sstables) {
                    try {
                        LifecycleTransaction txn = LifecycleTransaction.offline(OperationType.SCRUB, sstable);
                        Throwable throwable = null;
                        try {
                            txn.obsoleteOriginals();
                            try {
                                Scrubber scrubber = new Scrubber(cfs, txn, options.skipCorrupted, handler, !options.noValidate, options.reinserOverflowedTTL);
                                Throwable throwable2 = null;
                                try {
                                    scrubber.scrub();
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (scrubber == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            scrubber.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    scrubber.close();
                                }
                            }
                            catch (Throwable t) {
                                if (cfs.rebuildOnFailedScrub(t)) continue;
                                System.out.println(t.getMessage());
                                throw t;
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (txn == null) continue;
                            if (throwable != null) {
                                try {
                                    txn.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            txn.close();
                        }
                    }
                    catch (Exception e) {
                        System.err.println(String.format("Error scrubbing %s: %s", sstable, e.getMessage()));
                        e.printStackTrace(System.err);
                    }
                }
            }
            StandaloneScrubber.checkManifest(cfs.getCompactionStrategyManager(), cfs, sstables);
            CompactionManager.instance.finishCompactionsAndShutdown(5L, TimeUnit.MINUTES);
            LifecycleTransaction.waitForDeletions();
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            if (options.debug) {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private static void checkManifest(CompactionStrategyManager strategyManager, ColumnFamilyStore cfs, Collection<SSTableReader> sstables) {
        int maxSizeInMB = (int)(cfs.getCompactionStrategyManager().getMaxSSTableBytes() / 0x100000L);
        if (strategyManager.getStrategies().size() == 2 && strategyManager.getStrategies().get(0) instanceof LeveledCompactionStrategy) {
            System.out.println("Checking leveled manifest");
            Predicate<SSTableReader> repairedPredicate = new Predicate<SSTableReader>(){

                public boolean apply(SSTableReader sstable) {
                    return sstable.isRepaired();
                }
            };
            ArrayList repaired = Lists.newArrayList((Iterable)Iterables.filter(sstables, (Predicate)repairedPredicate));
            ArrayList unRepaired = Lists.newArrayList((Iterable)Iterables.filter(sstables, (Predicate)Predicates.not((Predicate)repairedPredicate)));
            LeveledManifest repairedManifest = LeveledManifest.create(cfs, maxSizeInMB, repaired);
            for (int i = 1; i < repairedManifest.getLevelCount(); ++i) {
                repairedManifest.repairOverlappingSSTables(i);
            }
            LeveledManifest unRepairedManifest = LeveledManifest.create(cfs, maxSizeInMB, unRepaired);
            for (int i = 1; i < unRepairedManifest.getLevelCount(); ++i) {
                unRepairedManifest.repairOverlappingSSTables(i);
            }
        }
    }

    private static class Options {
        public final String keyspaceName;
        public final String cfName;
        public boolean debug;
        public boolean verbose;
        public boolean manifestCheckOnly;
        public boolean skipCorrupted;
        public boolean noValidate;
        public boolean reinserOverflowedTTL;

        private Options(String keyspaceName, String cfName) {
            this.keyspaceName = keyspaceName;
            this.cfName = cfName;
        }

        public static Options parseArgs(String[] cmdArgs) {
            GnuParser parser = new GnuParser();
            BulkLoader.CmdLineOptions options = Options.getCmdLineOptions();
            try {
                String[] args;
                CommandLine cmd = parser.parse((org.apache.commons.cli.Options)options, cmdArgs, false);
                if (cmd.hasOption(StandaloneScrubber.HELP_OPTION)) {
                    Options.printUsage(options);
                    System.exit(0);
                }
                if ((args = cmd.getArgs()).length != 2) {
                    String msg = args.length < 2 ? "Missing arguments" : "Too many arguments";
                    System.err.println(msg);
                    Options.printUsage(options);
                    System.exit(1);
                }
                String keyspaceName = args[0];
                String cfName = args[1];
                Options opts = new Options(keyspaceName, cfName);
                opts.debug = cmd.hasOption(StandaloneScrubber.DEBUG_OPTION);
                opts.verbose = cmd.hasOption(StandaloneScrubber.VERBOSE_OPTION);
                opts.manifestCheckOnly = cmd.hasOption(StandaloneScrubber.MANIFEST_CHECK_OPTION);
                opts.skipCorrupted = cmd.hasOption(StandaloneScrubber.SKIP_CORRUPTED_OPTION);
                opts.noValidate = cmd.hasOption(StandaloneScrubber.NO_VALIDATE_OPTION);
                opts.reinserOverflowedTTL = cmd.hasOption(StandaloneScrubber.REINSERT_OVERFLOWED_TTL_OPTION);
                return opts;
            }
            catch (ParseException e) {
                Options.errorMsg(e.getMessage(), options);
                return null;
            }
        }

        private static void errorMsg(String msg, BulkLoader.CmdLineOptions options) {
            System.err.println(msg);
            Options.printUsage(options);
            System.exit(1);
        }

        private static BulkLoader.CmdLineOptions getCmdLineOptions() {
            BulkLoader.CmdLineOptions options = new BulkLoader.CmdLineOptions();
            options.addOption(null, StandaloneScrubber.DEBUG_OPTION, "display stack traces");
            options.addOption("v", StandaloneScrubber.VERBOSE_OPTION, "verbose output");
            options.addOption("h", StandaloneScrubber.HELP_OPTION, "display this help message");
            options.addOption("m", StandaloneScrubber.MANIFEST_CHECK_OPTION, "only check and repair the leveled manifest, without actually scrubbing the sstables");
            options.addOption("s", StandaloneScrubber.SKIP_CORRUPTED_OPTION, "skip corrupt rows in counter tables");
            options.addOption("n", StandaloneScrubber.NO_VALIDATE_OPTION, "do not validate columns using column validator");
            options.addOption("r", StandaloneScrubber.REINSERT_OVERFLOWED_TTL_OPTION, StandaloneScrubber.REINSERT_OVERFLOWED_TTL_OPTION_DESCRIPTION);
            return options;
        }

        public static void printUsage(BulkLoader.CmdLineOptions options) {
            String usage = String.format("%s [options] <keyspace> <column_family>", StandaloneScrubber.TOOL_NAME);
            StringBuilder header = new StringBuilder();
            header.append("--\n");
            header.append("Scrub the sstable for the provided table.");
            header.append("\n--\n");
            header.append("Options are:");
            new HelpFormatter().printHelp(usage, header.toString(), (org.apache.commons.cli.Options)options, "");
        }
    }
}

