/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.predefined;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.predefined.PredefinedOperation;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.ConnectionStyle;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.ThriftClient;
import org.apache.cassandra.stress.util.Timer;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.ThriftConversion;
import org.apache.cassandra.transport.SimpleClient;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.thrift.TException;

public abstract class CqlOperation<V>
extends PredefinedOperation {
    protected abstract List<Object> getQueryParameters(byte[] var1);

    protected abstract String buildQuery();

    protected abstract CqlRunOp<V> buildRunOp(ClientWrapper var1, String var2, Object var3, List<Object> var4, ByteBuffer var5);

    public CqlOperation(Command type, Timer timer, PartitionGenerator generator, SeedManager seedManager, StressSettings settings) {
        super(type, timer, generator, seedManager, settings);
        if (settings.columns.variableColumnCount) {
            throw new IllegalStateException("Variable column counts are not implemented for CQL");
        }
    }

    protected CqlRunOp<V> run(ClientWrapper client, List<Object> queryParams, ByteBuffer key) throws IOException {
        CqlRunOp<V> op;
        if (this.settings.mode.style == ConnectionStyle.CQL_PREPARED) {
            Object id;
            Object idobj = this.getCqlCache();
            if (idobj == null) {
                try {
                    id = client.createPreparedStatement(this.buildQuery());
                }
                catch (TException e) {
                    throw new RuntimeException(e);
                }
                this.storeCqlCache(id);
            } else {
                id = idobj;
            }
            op = this.buildRunOp(client, null, id, queryParams, key);
        } else {
            String query;
            Object qobj = this.getCqlCache();
            if (qobj == null) {
                query = this.buildQuery();
                this.storeCqlCache(query);
            } else {
                query = qobj.toString();
            }
            op = this.buildRunOp(client, query, null, queryParams, key);
        }
        this.timeWithRetry(op);
        return op;
    }

    protected void run(ClientWrapper client) throws IOException {
        byte[] key = this.getKey().array();
        List<Object> queryParams = this.getQueryParameters(key);
        this.run(client, queryParams, ByteBuffer.wrap(key));
    }

    @Override
    public void run(ThriftClient client) throws IOException {
        this.run(this.wrap(client));
    }

    @Override
    public void run(SimpleClient client) throws IOException {
        this.run(this.wrap(client));
    }

    @Override
    public void run(JavaDriverClient client) throws IOException {
        this.run(this.wrap(client));
    }

    public ClientWrapper wrap(ThriftClient client) {
        return new Cql3CassandraClientWrapper(client);
    }

    public ClientWrapper wrap(JavaDriverClient client) {
        return new JavaDriverWrapper(client);
    }

    public ClientWrapper wrap(SimpleClient client) {
        return new SimpleClientWrapper(client);
    }

    private static String getUnQuotedCqlBlob(ByteBuffer term) {
        return "0x" + ByteBufferUtil.bytesToHex((ByteBuffer)term);
    }

    private static String formatCqlQuery(String query, List<Object> parms) {
        int position = 0;
        StringBuilder result = new StringBuilder();
        int marker = query.indexOf(63);
        if (-1 == marker || parms.size() == 0) {
            return query;
        }
        for (Object parm : parms) {
            result.append(query.substring(position, marker));
            if (parm instanceof ByteBuffer) {
                result.append(CqlOperation.getUnQuotedCqlBlob((ByteBuffer)parm));
            } else if (parm instanceof Long) {
                result.append(parm);
            } else {
                throw new AssertionError();
            }
            if (-1 != (marker = query.indexOf(63, (position = marker + 1) + 1))) continue;
            break;
        }
        if (position < query.length()) {
            result.append(query.substring(position));
        }
        return result.toString();
    }

    private static List<ByteBuffer> toByteBufferParams(List<Object> params) {
        ArrayList<ByteBuffer> r = new ArrayList<ByteBuffer>();
        for (Object param : params) {
            if (param instanceof ByteBuffer) {
                r.add((ByteBuffer)param);
                continue;
            }
            if (param instanceof Long) {
                r.add(ByteBufferUtil.bytes((long)((Long)param)));
                continue;
            }
            throw new AssertionError();
        }
        return r;
    }

    protected String wrapInQuotes(String string) {
        return "\"" + string + "\"";
    }

    protected static final class KeysHandler
    implements ResultHandler<byte[][]> {
        static final KeysHandler INSTANCE = new KeysHandler();

        protected KeysHandler() {
        }

        @Override
        public Function<ResultSet, byte[][]> javaDriverHandler() {
            return new Function<ResultSet, byte[][]>(){

                public byte[][] apply(ResultSet result) {
                    if (result == null) {
                        return new byte[0][];
                    }
                    List rows = result.all();
                    byte[][] r = new byte[rows.size()][];
                    for (int i = 0; i < r.length; ++i) {
                        r[i] = ((Row)rows.get(i)).getBytes(0).array();
                    }
                    return r;
                }
            };
        }

        @Override
        public Function<ResultMessage, byte[][]> thriftHandler() {
            return new Function<ResultMessage, byte[][]>(){

                public byte[][] apply(ResultMessage result) {
                    if (result instanceof ResultMessage.Rows) {
                        ResultMessage.Rows rows = (ResultMessage.Rows)result;
                        byte[][] r = new byte[rows.result.size()][];
                        for (int i = 0; i < r.length; ++i) {
                            r[i] = ((ByteBuffer)((List)rows.result.rows.get(i)).get(0)).array();
                        }
                        return r;
                    }
                    return null;
                }
            };
        }

        @Override
        public Function<CqlResult, byte[][]> simpleNativeHandler() {
            return new Function<CqlResult, byte[][]>(){

                public byte[][] apply(CqlResult result) {
                    byte[][] r = new byte[result.getRows().size()][];
                    for (int i = 0; i < r.length; ++i) {
                        r[i] = ((CqlRow)result.getRows().get(i)).getKey();
                    }
                    return r;
                }
            };
        }
    }

    protected static final class RowsHandler
    implements ResultHandler<ByteBuffer[][]> {
        static final RowsHandler INSTANCE = new RowsHandler();

        protected RowsHandler() {
        }

        @Override
        public Function<ResultSet, ByteBuffer[][]> javaDriverHandler() {
            return new Function<ResultSet, ByteBuffer[][]>(){

                public ByteBuffer[][] apply(ResultSet result) {
                    if (result == null) {
                        return new ByteBuffer[0][];
                    }
                    List rows = result.all();
                    ByteBuffer[][] r = new ByteBuffer[rows.size()][];
                    for (int i = 0; i < r.length; ++i) {
                        Row row = (Row)rows.get(i);
                        r[i] = new ByteBuffer[row.getColumnDefinitions().size()];
                        for (int j = 0; j < row.getColumnDefinitions().size(); ++j) {
                            r[i][j] = row.getBytes(j);
                        }
                    }
                    return r;
                }
            };
        }

        @Override
        public Function<ResultMessage, ByteBuffer[][]> thriftHandler() {
            return new Function<ResultMessage, ByteBuffer[][]>(){

                public ByteBuffer[][] apply(ResultMessage result) {
                    if (!(result instanceof ResultMessage.Rows)) {
                        return new ByteBuffer[0][];
                    }
                    ResultMessage.Rows rows = (ResultMessage.Rows)result;
                    ByteBuffer[][] r = new ByteBuffer[rows.result.size()][];
                    for (int i = 0; i < r.length; ++i) {
                        List row = (List)rows.result.rows.get(i);
                        r[i] = new ByteBuffer[row.size()];
                        for (int j = 0; j < row.size(); ++j) {
                            r[i][j] = (ByteBuffer)row.get(j);
                        }
                    }
                    return r;
                }
            };
        }

        @Override
        public Function<CqlResult, ByteBuffer[][]> simpleNativeHandler() {
            return new Function<CqlResult, ByteBuffer[][]>(){

                public ByteBuffer[][] apply(CqlResult result) {
                    ByteBuffer[][] r = new ByteBuffer[result.getRows().size()][];
                    for (int i = 0; i < r.length; ++i) {
                        CqlRow row = (CqlRow)result.getRows().get(i);
                        r[i] = new ByteBuffer[row.getColumns().size()];
                        for (int j = 0; j < r[i].length; ++j) {
                            r[i][j] = ByteBuffer.wrap(((Column)row.getColumns().get(j)).getValue());
                        }
                    }
                    return r;
                }
            };
        }
    }

    protected static class RowCountHandler
    implements ResultHandler<Integer> {
        static final RowCountHandler INSTANCE = new RowCountHandler();

        protected RowCountHandler() {
        }

        @Override
        public Function<ResultSet, Integer> javaDriverHandler() {
            return new Function<ResultSet, Integer>(){

                public Integer apply(ResultSet rows) {
                    if (rows == null) {
                        return 0;
                    }
                    return rows.all().size();
                }
            };
        }

        @Override
        public Function<ResultMessage, Integer> thriftHandler() {
            return new Function<ResultMessage, Integer>(){

                public Integer apply(ResultMessage result) {
                    return result instanceof ResultMessage.Rows ? ((ResultMessage.Rows)result).result.size() : 0;
                }
            };
        }

        @Override
        public Function<CqlResult, Integer> simpleNativeHandler() {
            return new Function<CqlResult, Integer>(){

                public Integer apply(CqlResult result) {
                    switch (result.getType()) {
                        case ROWS: {
                            return result.getRows().size();
                        }
                    }
                    return 1;
                }
            };
        }
    }

    protected static interface ResultHandler<V> {
        public Function<ResultSet, V> javaDriverHandler();

        public Function<ResultMessage, V> thriftHandler();

        public Function<CqlResult, V> simpleNativeHandler();
    }

    private final class Cql3CassandraClientWrapper
    implements ClientWrapper {
        final ThriftClient client;

        private Cql3CassandraClientWrapper(ThriftClient client) {
            this.client = client;
        }

        @Override
        public <V> V execute(String query, ByteBuffer key, List<Object> queryParams, ResultHandler<V> handler) throws TException {
            String formattedQuery = CqlOperation.formatCqlQuery(query, queryParams);
            return (V)handler.simpleNativeHandler().apply((Object)this.client.execute_cql3_query(formattedQuery, key, Compression.NONE, CqlOperation.this.settings.command.consistencyLevel));
        }

        @Override
        public <V> V execute(Object preparedStatementId, ByteBuffer key, List<Object> queryParams, ResultHandler<V> handler) throws TException {
            Integer id = (Integer)preparedStatementId;
            return (V)handler.simpleNativeHandler().apply((Object)this.client.execute_prepared_cql3_query(id, key, CqlOperation.toByteBufferParams(queryParams), CqlOperation.this.settings.command.consistencyLevel));
        }

        @Override
        public Object createPreparedStatement(String cqlQuery) throws TException {
            return this.client.prepare_cql3_query(cqlQuery, Compression.NONE);
        }
    }

    private final class SimpleClientWrapper
    implements ClientWrapper {
        final SimpleClient client;

        private SimpleClientWrapper(SimpleClient client) {
            this.client = client;
        }

        @Override
        public <V> V execute(String query, ByteBuffer key, List<Object> queryParams, ResultHandler<V> handler) {
            String formattedQuery = CqlOperation.formatCqlQuery(query, queryParams);
            return (V)handler.thriftHandler().apply((Object)this.client.execute(formattedQuery, ThriftConversion.fromThrift((ConsistencyLevel)CqlOperation.this.settings.command.consistencyLevel)));
        }

        @Override
        public <V> V execute(Object preparedStatementId, ByteBuffer key, List<Object> queryParams, ResultHandler<V> handler) {
            return (V)handler.thriftHandler().apply((Object)this.client.executePrepared((byte[])preparedStatementId, CqlOperation.toByteBufferParams(queryParams), ThriftConversion.fromThrift((ConsistencyLevel)CqlOperation.this.settings.command.consistencyLevel)));
        }

        @Override
        public Object createPreparedStatement(String cqlQuery) {
            return this.client.prepare((String)cqlQuery).statementId.bytes;
        }
    }

    private final class JavaDriverWrapper
    implements ClientWrapper {
        final JavaDriverClient client;

        private JavaDriverWrapper(JavaDriverClient client) {
            this.client = client;
        }

        @Override
        public <V> V execute(String query, ByteBuffer key, List<Object> queryParams, ResultHandler<V> handler) {
            String formattedQuery = CqlOperation.formatCqlQuery(query, queryParams);
            return (V)handler.javaDriverHandler().apply((Object)this.client.execute(formattedQuery, ThriftConversion.fromThrift((ConsistencyLevel)CqlOperation.this.settings.command.consistencyLevel)));
        }

        @Override
        public <V> V execute(Object preparedStatementId, ByteBuffer key, List<Object> queryParams, ResultHandler<V> handler) {
            return (V)handler.javaDriverHandler().apply((Object)this.client.executePrepared((PreparedStatement)preparedStatementId, queryParams, ThriftConversion.fromThrift((ConsistencyLevel)CqlOperation.this.settings.command.consistencyLevel)));
        }

        @Override
        public Object createPreparedStatement(String cqlQuery) {
            return this.client.prepare(cqlQuery);
        }
    }

    protected static interface ClientWrapper {
        public Object createPreparedStatement(String var1) throws TException;

        public <V> V execute(Object var1, ByteBuffer var2, List<Object> var3, ResultHandler<V> var4) throws TException;

        public <V> V execute(String var1, ByteBuffer var2, List<Object> var3, ResultHandler<V> var4) throws TException;
    }

    protected abstract class CqlRunOp<V>
    implements Operation.RunOp {
        final ClientWrapper client;
        final String query;
        final Object queryId;
        final List<Object> params;
        final ByteBuffer key;
        final ResultHandler<V> handler;
        V result;

        private CqlRunOp(ClientWrapper client, String query, Object queryId, ResultHandler<V> handler, List<Object> params, ByteBuffer key) {
            this.client = client;
            this.query = query;
            this.queryId = queryId;
            this.handler = handler;
            this.params = params;
            this.key = key;
        }

        @Override
        public boolean run() throws Exception {
            boolean bl;
            if (this.queryId != null) {
                this.result = this.client.execute(this.queryId, this.key, this.params, this.handler);
                bl = this.validate(this.result);
            } else {
                this.result = this.client.execute(this.query, this.key, this.params, this.handler);
                bl = this.validate(this.result);
            }
            return bl;
        }

        public abstract boolean validate(V var1);
    }

    protected final class CqlRunOpMatchResults
    extends CqlRunOp<ByteBuffer[][]> {
        final List<List<ByteBuffer>> expect;

        protected CqlRunOpMatchResults(ClientWrapper client, String query, Object queryId, List<Object> params, ByteBuffer key, List<List<ByteBuffer>> expect) {
            super(client, query, queryId, RowsHandler.INSTANCE, params, key);
            this.expect = expect;
        }

        @Override
        public int partitionCount() {
            return this.result == null ? 0 : ((ByteBuffer[][])this.result).length;
        }

        @Override
        public int rowCount() {
            return this.result == null ? 0 : ((ByteBuffer[][])this.result).length;
        }

        @Override
        public boolean validate(ByteBuffer[][] result) {
            if (result.length != this.expect.size()) {
                return false;
            }
            for (int i = 0; i < result.length; ++i) {
                if (this.expect.get(i) == null || this.expect.get(i).equals(Arrays.asList(result[i]))) continue;
                return false;
            }
            return true;
        }
    }

    protected final class CqlRunOpTestNonEmpty
    extends CqlRunOp<Integer> {
        protected CqlRunOpTestNonEmpty(ClientWrapper client, String query, Object queryId, List<Object> params, ByteBuffer key) {
            super(client, query, queryId, RowCountHandler.INSTANCE, params, key);
        }

        @Override
        public boolean validate(Integer result) {
            return result > 0;
        }

        @Override
        public int partitionCount() {
            return (Integer)this.result;
        }

        @Override
        public int rowCount() {
            return (Integer)this.result;
        }
    }

    protected final class CqlRunOpAlwaysSucceed
    extends CqlRunOp<Integer> {
        final int keyCount;

        protected CqlRunOpAlwaysSucceed(ClientWrapper client, String query, Object queryId, List<Object> params, ByteBuffer key, int keyCount) {
            super(client, query, queryId, RowCountHandler.INSTANCE, params, key);
            this.keyCount = keyCount;
        }

        @Override
        public boolean validate(Integer result) {
            return true;
        }

        @Override
        public int partitionCount() {
            return this.keyCount;
        }

        @Override
        public int rowCount() {
            return this.keyCount;
        }
    }
}

