/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;

public abstract class ParsedStatement {
    private VariableSpecifications variables;

    public VariableSpecifications getBoundVariables() {
        return this.variables;
    }

    public void setBoundVariables(List<ColumnIdentifier> boundNames) {
        this.variables = new VariableSpecifications(boundNames);
    }

    public void setBoundVariables(VariableSpecifications variables) {
        this.variables = variables;
    }

    public abstract Prepared prepare(ClientState var1) throws RequestValidationException;

    public Iterable<Function> getFunctions() {
        return Collections.emptyList();
    }

    public static class Prepared {
        public String rawCQLStatement;
        public final CQLStatement statement;
        public final List<ColumnSpecification> boundNames;
        @Nullable
        public final short[] partitionKeyBindIndexes;
        public final boolean fullyQualified;
        @Nullable
        public final String keyspace;

        protected Prepared(CQLStatement statement, List<ColumnSpecification> boundNames, short[] partitionKeyBindIndexes, String keyspace, boolean fullyQualified) {
            this.statement = statement;
            this.boundNames = boundNames;
            this.partitionKeyBindIndexes = partitionKeyBindIndexes;
            this.rawCQLStatement = "";
            this.fullyQualified = fullyQualified;
            this.keyspace = keyspace;
        }

        public Prepared(CQLStatement statement, VariableSpecifications names, short[] partitionKeyBindIndexes, String keyspace, boolean fullyQualified) {
            this(statement, names.getSpecifications(), partitionKeyBindIndexes, keyspace, fullyQualified);
        }

        public Prepared(CQLStatement statement) {
            this(statement, Collections.emptyList(), null, null, false);
        }
    }
}

