/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.ByteArrayList;
import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.cursors.ByteCursor;

public class ByteStack
extends ByteArrayList {
    public ByteStack() {
    }

    public ByteStack(int initialCapacity) {
        super(initialCapacity);
    }

    public ByteStack(int initialCapacity, ArraySizingStrategy resizer) {
        super(initialCapacity, resizer);
    }

    public ByteStack(ByteContainer container) {
        super(container);
    }

    public void push(byte e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void push(byte e1, byte e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void push(byte e1, byte e2, byte e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void push(byte e1, byte e2, byte e3, byte e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void push(byte[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public void push(byte ... elements) {
        this.push(elements, 0, elements.length);
    }

    public int pushAll(ByteContainer container) {
        return this.addAll(container);
    }

    public int pushAll(Iterable<? extends ByteCursor> iterable) {
        return this.addAll(iterable);
    }

    public void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public byte pop() {
        assert (this.elementsCount > 0);
        byte v = this.buffer[--this.elementsCount];
        return v;
    }

    public byte peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static ByteStack newInstance() {
        return new ByteStack();
    }

    public static ByteStack newInstanceWithCapacity(int initialCapacity) {
        return new ByteStack(initialCapacity);
    }

    public static ByteStack from(byte ... elements) {
        ByteStack stack = new ByteStack(elements.length);
        stack.push(elements);
        return stack;
    }

    public static ByteStack from(ByteContainer container) {
        return new ByteStack(container);
    }

    @Override
    public ByteStack clone() {
        return (ByteStack)super.clone();
    }
}

