/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.auth.CIDRGroupsMappingManager;
import org.apache.cassandra.auth.CIDRPermissions;
import org.apache.cassandra.auth.CIDRPermissionsManager;
import org.apache.cassandra.auth.ICIDRAuthorizer;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.metrics.CIDRAuthorizerMetrics;

public abstract class AbstractCIDRAuthorizer
implements ICIDRAuthorizer {
    protected static CIDRPermissionsManager cidrPermissionsManager;
    protected static CIDRGroupsMappingManager cidrGroupsMappingManager;
    protected static CIDRAuthorizerMetrics cidrAuthorizerMetrics;

    @VisibleForTesting
    void createManagers() {
        cidrPermissionsManager = new CIDRPermissionsManager();
        cidrGroupsMappingManager = new CIDRGroupsMappingManager();
    }

    protected void commonSetup() {
        this.createManagers();
        cidrPermissionsManager.setup();
        cidrGroupsMappingManager.setup();
        cidrAuthorizerMetrics = new CIDRAuthorizerMetrics();
    }

    @Override
    public CIDRGroupsMappingManager getCidrGroupsMappingManager() {
        return cidrGroupsMappingManager;
    }

    @Override
    public CIDRAuthorizerMetrics getCidrAuthorizerMetrics() {
        return cidrAuthorizerMetrics;
    }

    @Override
    public boolean requireAuthorization() {
        return true;
    }

    @Override
    public void setCidrGroupsForRole(RoleResource role, CIDRPermissions cidrPermissions) {
        cidrPermissionsManager.setCidrGroupsForRole(role, cidrPermissions);
    }

    @Override
    public void dropCidrPermissionsForRole(RoleResource role) {
        cidrPermissionsManager.drop(role);
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
    }
}

