/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import com.google.common.collect.Range;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.IncompleteSSTableException;
import org.apache.cassandra.spark.data.PartitionedDataLayer;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.SingleReplica;
import org.apache.cassandra.spark.reader.SparkSSTableReader;
import org.apache.cassandra.spark.reader.common.SSTableStreamException;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class SingleReplicaTests {
    public static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("replicas-tests-%d").setDaemon(true).build());

    @ParameterizedTest
    @MethodSource(value={"dataFileNames"})
    public void testOpenSSTables(String dataFileName) throws ExecutionException, InterruptedException, IOException {
        SingleReplicaTests.runTest(dataFileName, false, new FileType[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"dataFileNames"})
    public void testMissingNonEssentialFiles(String dataFileName) throws ExecutionException, InterruptedException, IOException {
        SingleReplicaTests.runTest(dataFileName, false, FileType.FILTER);
    }

    @ParameterizedTest
    @MethodSource(value={"dataFileNames"})
    public void testMissingOnlySummaryFile(String dataFileName) throws ExecutionException, InterruptedException, IOException {
        SingleReplicaTests.runTest(dataFileName, false, FileType.SUMMARY);
    }

    @ParameterizedTest
    @MethodSource(value={"dataFileNames"})
    public void testMissingOnlyIndexFile(String dataFileName) throws ExecutionException, InterruptedException, IOException {
        SingleReplicaTests.runTest(dataFileName, false, FileType.INDEX);
    }

    @ParameterizedTest
    @MethodSource(value={"dataFileNames"})
    public void testMissingDataFile(String dataFileName) {
        Assertions.assertThatThrownBy(() -> SingleReplicaTests.runTest(dataFileName, true, FileType.DATA)).isInstanceOf(IOException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"dataFileNames"})
    public void testMissingStatisticsFile(String dataFileName) {
        Assertions.assertThatThrownBy(() -> SingleReplicaTests.runTest(dataFileName, true, FileType.STATISTICS)).isInstanceOf(IOException.class);
    }

    @Test
    public void testMissingSummaryPrimaryIndex() {
        Assertions.assertThatThrownBy(() -> SingleReplicaTests.runTest("na-1-big-Data.db", true, FileType.SUMMARY, FileType.INDEX)).isInstanceOf(IOException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"dataFileNames"})
    public void testFailOpenReader(String dataFileName) {
        Assertions.assertThatThrownBy(() -> SingleReplicaTests.runTest(dataFileName, true, (SSTablesSupplier.ReaderOpener<Reader>)((SSTablesSupplier.ReaderOpener)(ssTable, isRepairPrimary) -> {
            throw new IOException("Couldn't open Summary.db file");
        }), (Range<BigInteger>)Range.closed((Comparable)BigInteger.valueOf(Long.MIN_VALUE), (Comparable)BigInteger.valueOf(8710962479251732707L)), new FileType[0])).isInstanceOf(IOException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"dataFileNames"})
    public void testFilterOverlap(String dataFileName) throws ExecutionException, InterruptedException, IOException {
        SingleReplicaTests.runTest(dataFileName, false, (SSTablesSupplier.ReaderOpener<Reader>)((SSTablesSupplier.ReaderOpener)(ssTable, isRepairPrimary) -> new Reader(ssTable, BigInteger.valueOf(50L), BigInteger.valueOf(150L))), (Range<BigInteger>)Range.closed((Comparable)BigInteger.valueOf(0L), (Comparable)BigInteger.valueOf(100L)), new FileType[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"dataFileNames"})
    public void testFilterInnerlap(String dataFileName) throws ExecutionException, InterruptedException, IOException {
        SingleReplicaTests.runTest(dataFileName, false, (SSTablesSupplier.ReaderOpener<Reader>)((SSTablesSupplier.ReaderOpener)(ssTable, isRepairPrimary) -> new Reader(ssTable, BigInteger.valueOf(25L), BigInteger.valueOf(75L))), (Range<BigInteger>)Range.closed((Comparable)BigInteger.valueOf(0L), (Comparable)BigInteger.valueOf(100L)), new FileType[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"dataFileNames"})
    public void testFilterBoundary(String dataFileName) throws ExecutionException, InterruptedException, IOException {
        SingleReplicaTests.runTest(dataFileName, false, (SSTablesSupplier.ReaderOpener<Reader>)((SSTablesSupplier.ReaderOpener)(ssTable, isRepairPrimary) -> new Reader(ssTable, BigInteger.valueOf(100L), BigInteger.valueOf(102L))), (Range<BigInteger>)Range.closed((Comparable)BigInteger.valueOf(0L), (Comparable)BigInteger.valueOf(100L)), new FileType[0]);
    }

    private static void runTest(String dataFileName, boolean shouldThrowIOException, FileType ... missingFileTypes) throws ExecutionException, InterruptedException, IOException {
        SingleReplicaTests.runTest(dataFileName, shouldThrowIOException, (SSTablesSupplier.ReaderOpener<Reader>)((SSTablesSupplier.ReaderOpener)(ssTable, isRepairPrimary) -> new Reader(ssTable)), (Range<BigInteger>)Range.closed((Comparable)BigInteger.valueOf(Long.MIN_VALUE), (Comparable)BigInteger.valueOf(8710962479251732707L)), missingFileTypes);
    }

    private static void runTest(String dataFileName, boolean shouldThrowIOException, SSTablesSupplier.ReaderOpener<Reader> readerOpener, Range<BigInteger> range, FileType ... missingFileTypes) throws InterruptedException, IOException, ExecutionException {
        Set readers;
        PartitionedDataLayer dataLayer = (PartitionedDataLayer)Mockito.mock(PartitionedDataLayer.class);
        CassandraInstance instance = new CassandraInstance("-9223372036854775808", "local1-i1", "DC1");
        SSTable ssTable1 = SingleReplicaTests.mockSSTable();
        SSTable ssTable2 = SingleReplicaTests.mockSSTable();
        SSTable ssTable3 = SingleReplicaTests.mockSSTable();
        for (FileType fileType : missingFileTypes) {
            Mockito.when((Object)ssTable3.isMissing((FileType)ArgumentMatchers.eq((Object)fileType))).thenReturn((Object)true);
            ((SSTable)Mockito.doCallRealMethod().when((Object)ssTable3)).isBigFormat();
            ((SSTable)Mockito.doCallRealMethod().when((Object)ssTable3)).isBtiFormat();
            Mockito.when((Object)ssTable3.getDataFileName()).thenReturn((Object)dataFileName);
        }
        Stream<SSTable> sstables = Stream.of(ssTable1, ssTable2, ssTable3);
        Mockito.when((Object)dataLayer.listInstance(ArgumentMatchers.eq((int)0), (Range)ArgumentMatchers.eq(range), (CassandraInstance)ArgumentMatchers.eq((Object)instance))).thenReturn(CompletableFuture.completedFuture(sstables));
        SingleReplica replica = new SingleReplica(instance, dataLayer, range, 0, EXECUTOR, true);
        try {
            readers = (Set)replica.openReplicaAsync(readerOpener).get();
        }
        catch (ExecutionException exception) {
            IOException io = SSTableStreamException.getIOException((Throwable)exception);
            if (io != null) {
                throw io;
            }
            throw exception;
        }
        if (shouldThrowIOException) {
            Assertions.fail((String)"Should throw IOException because an SSTable is corrupt");
        }
        Assertions.assertThat((Collection)readers).hasSize(3);
    }

    static SSTable mockSSTable() throws IncompleteSSTableException {
        SSTable ssTable = (SSTable)Mockito.mock(SSTable.class);
        Mockito.when((Object)ssTable.isMissing((FileType)ArgumentMatchers.any(FileType.class))).thenReturn((Object)false);
        ((SSTable)Mockito.doCallRealMethod().when((Object)ssTable)).verify();
        return ssTable;
    }

    public static List<Named<String>> dataFileNames() {
        return Arrays.asList(Named.of((String)"BIG", (Object)"na-1-big-Data.db"));
    }

    public static class Reader
    implements SparkSSTableReader {
        BigInteger firstToken;
        BigInteger lastToken;
        SSTable ssTable;

        Reader(SSTable ssTable) {
            this(ssTable, BigInteger.valueOf(0L), BigInteger.valueOf(1L));
        }

        Reader(SSTable ssTable, @Nullable BigInteger firstToken, @Nullable BigInteger lastToken) {
            this.ssTable = ssTable;
            this.firstToken = firstToken;
            this.lastToken = lastToken;
        }

        public BigInteger firstToken() {
            return this.firstToken;
        }

        public BigInteger lastToken() {
            return this.lastToken;
        }

        public boolean ignore() {
            return false;
        }
    }
}

