/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.math.BigInteger;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleManifest;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class BundleManifestTest {
    @TempDir
    private Path tempFolder;
    private static final String EXPECTED_JSON = "{\n  \"prefix2\" : {\n    \"components_checksum\" : {\n      \"prefix2-data.db\" : \"checksumVal\",\n      \"prefix2-statistics.db\" : \"checksumVal\"\n    },\n    \"start_token\" : 4,\n    \"end_token\" : 6\n  },\n  \"prefix1\" : {\n    \"components_checksum\" : {\n      \"prefix1-data.db\" : \"checksumVal\",\n      \"prefix1-statistics.db\" : \"checksumVal\"\n    },\n    \"start_token\" : 1,\n    \"end_token\" : 3\n  }\n}";

    BundleManifestTest() {
    }

    @Test
    void testJsonSerialization() throws JsonProcessingException {
        BundleManifest bundleManifest = this.testManifest();
        String value = BundleManifest.OBJECT_WRITER.writeValueAsString((Object)bundleManifest);
        Assertions.assertThat((String)value).isEqualTo(EXPECTED_JSON);
    }

    @Test
    void testPersistToFile() throws Exception {
        Path manifestFile = this.tempFolder.resolve("manifest.json");
        Assertions.assertThat((boolean)Files.exists(manifestFile, new LinkOption[0])).isFalse();
        BundleManifest bundleManifest = this.testManifest();
        bundleManifest.persistTo(manifestFile);
        String persistedContent = FileUtils.readFileToString((File)manifestFile.toFile());
        Assertions.assertThat((String)persistedContent).isEqualTo(EXPECTED_JSON);
    }

    @Test
    void testPersistToFileFailsWithExistingFile() throws Exception {
        Path manifestFile = Files.createFile(this.tempFolder.resolve("manifest.json"), new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.exists(manifestFile, new LinkOption[0])).isTrue();
        Assertions.assertThatThrownBy(() -> this.testManifest().persistTo(manifestFile)).isInstanceOf(FileAlreadyExistsException.class);
    }

    private BundleManifest testManifest() {
        BundleManifest bundleManifest = new BundleManifest();
        BundleManifest.Entry manifestEntry1 = new BundleManifest.Entry("prefix1", BigInteger.valueOf(1L), BigInteger.valueOf(3L));
        manifestEntry1.addComponentChecksum("prefix1-data.db", "checksumVal");
        manifestEntry1.addComponentChecksum("prefix1-statistics.db", "checksumVal");
        BundleManifest.Entry manifestEntry2 = new BundleManifest.Entry("prefix2", BigInteger.valueOf(4L), BigInteger.valueOf(6L));
        manifestEntry2.addComponentChecksum("prefix2-data.db", "checksumVal");
        manifestEntry2.addComponentChecksum("prefix2-statistics.db", "checksumVal");
        bundleManifest.addEntry(manifestEntry1);
        bundleManifest.addEntry(manifestEntry2);
        return bundleManifest;
    }
}

