/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter.types;

import java.sql.Date;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.converter.types.SparkType;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.jetbrains.annotations.NotNull;

public class SparkDate
implements SparkType {
    public static final SparkDate INSTANCE = new SparkDate();

    private SparkDate() {
    }

    @Override
    public DataType dataType(BigNumberConfig bigNumberConfig) {
        return DataTypes.DateType;
    }

    @Override
    public Object toSparkSqlType(@NotNull Object value, boolean isFrozen) {
        int days = (Integer)value;
        return days - Integer.MIN_VALUE;
    }

    @Override
    public Object nativeSparkSqlRowValue(GenericInternalRow row, int position) {
        return row.getInt(position);
    }

    @Override
    public Object nativeSparkSqlRowValue(Row row, int position) {
        return row.getDate(position);
    }

    @Override
    public int compareTo(Object first, Object second) {
        return CqlField.INTEGER_COMPARATOR.compare((Integer)first, (Integer)second);
    }

    @Override
    public Object toTestRowType(Object value) {
        if (value instanceof Date) {
            return (int)((Date)value).toLocalDate().toEpochDay();
        }
        if (value instanceof Integer) {
            return (Integer)value - Integer.MIN_VALUE;
        }
        return value;
    }
}

