/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.example;

import java.util.HashMap;
import java.util.UUID;
import org.apache.cassandra.spark.example.AbstractCassandraJob;
import org.apache.cassandra.spark.example.LocalStorageTransportExtension;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;

public class LocalS3WriteAndReadJob
extends AbstractCassandraJob {
    private String dataCenter = "datacenter1";
    private String sidecarInstances = "localhost,localhost2,localhost3";

    LocalS3WriteAndReadJob(String[] args) {
        if (args.length == 2) {
            this.dataCenter = args[0];
            this.sidecarInstances = args[1];
        }
    }

    public static void main(String[] args) {
        System.setProperty("SKIP_STARTUP_VALIDATIONS", "true");
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command("curl", "-X", "PUT", "localhost:9090/sbw-bucket");
        try {
            pb.start().waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        new LocalS3WriteAndReadJob(args).start(args);
    }

    @Override
    protected AbstractCassandraJob.JobConfiguration configureJob(SparkContext sc, SparkConf sparkConf) {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put("sidecar_contact_points", this.sidecarInstances);
        writeOptions.put("keyspace", "spark_test");
        writeOptions.put("table", "test");
        writeOptions.put("local_dc", this.dataCenter);
        writeOptions.put("bulk_writer_cl", "LOCAL_QUORUM");
        writeOptions.put("number_splits", "-1");
        writeOptions.put("data_transport", "S3_COMPAT");
        writeOptions.put("data_transport_extension_class", LocalStorageTransportExtension.class.getCanonicalName());
        writeOptions.put("storage_client_endpoint_override", "http://localhost:9090");
        writeOptions.put("storage_client_max_chunk_size_in_bytes", "5242880");
        writeOptions.put("max_size_per_sstable_bundle_in_bytes_s3_transport", "10485760");
        writeOptions.put("max_job_duration_minutes", "10");
        writeOptions.put("job_id", "a_unique_id_made_of_arbitrary_string");
        int coresPerExecutor = sparkConf.getInt("spark.executor.cores", 1);
        int numExecutors = sparkConf.getInt("spark.dynamicAllocation.maxExecutors", sparkConf.getInt("spark.executor.instances", 1));
        int numCores = coresPerExecutor * numExecutors;
        HashMap<String, String> readerOptions = new HashMap<String, String>();
        readerOptions.put("sidecar_contact_points", "localhost,localhost2,localhost3");
        readerOptions.put("keyspace", "spark_test");
        readerOptions.put("table", "test");
        readerOptions.put("DC", "datacenter1");
        readerOptions.put("snapshotName", UUID.randomUUID().toString());
        readerOptions.put("createSnapshot", "true");
        readerOptions.put("defaultParallelism", String.valueOf(sc.defaultParallelism()));
        readerOptions.put("numCores", String.valueOf(numCores));
        readerOptions.put("sizing", "default");
        AbstractCassandraJob.JobConfiguration config = new AbstractCassandraJob.JobConfiguration(writeOptions, readerOptions);
        config.rowCount = 2000000L;
        return config;
    }
}

