/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TemporalType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeFcts {
    public static Logger logger = LoggerFactory.getLogger(TimeFcts.class);
    public static final Function minTimeuuidFct = new NativeScalarFunction("mintimeuuid", (AbstractType)TimeUUIDType.instance, new AbstractType[]{TimestampType.instance}){

        @Override
        public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return UUIDGen.toByteBuffer(UUIDGen.minTimeUUID(((Date)TimestampType.instance.compose(bb)).getTime()));
        }
    };
    public static final Function maxTimeuuidFct = new NativeScalarFunction("maxtimeuuid", (AbstractType)TimeUUIDType.instance, new AbstractType[]{TimestampType.instance}){

        @Override
        public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return UUIDGen.toByteBuffer(UUIDGen.maxTimeUUID(((Date)TimestampType.instance.compose(bb)).getTime()));
        }
    };
    public static final NativeScalarFunction dateOfFct = new NativeScalarFunction("dateof", (AbstractType)TimestampType.instance, new AbstractType[]{TimeUUIDType.instance}){
        private volatile boolean hasLoggedDeprecationWarning;

        @Override
        public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb;
            if (!this.hasLoggedDeprecationWarning) {
                this.hasLoggedDeprecationWarning = true;
                logger.warn("The function 'dateof' is deprecated. Use the function 'toTimestamp' instead.");
            }
            if ((bb = parameters.get(0)) == null) {
                return null;
            }
            long timeInMillis = UUIDGen.unixTimestamp(UUIDGen.getUUID(bb));
            return ByteBufferUtil.bytes(timeInMillis);
        }
    };
    public static final NativeScalarFunction unixTimestampOfFct = new NativeScalarFunction("unixtimestampof", (AbstractType)LongType.instance, new AbstractType[]{TimeUUIDType.instance}){
        private volatile boolean hasLoggedDeprecationWarning;

        @Override
        public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb;
            if (!this.hasLoggedDeprecationWarning) {
                this.hasLoggedDeprecationWarning = true;
                logger.warn("The function 'unixtimestampof' is deprecated. Use the function 'toUnixTimestamp' instead.");
            }
            if ((bb = parameters.get(0)) == null) {
                return null;
            }
            return ByteBufferUtil.bytes(UUIDGen.unixTimestamp(UUIDGen.getUUID(bb)));
        }
    };

    public static Collection<Function> all() {
        return ImmutableList.of(TimeFcts.now("now", TimeUUIDType.instance), TimeFcts.now("currenttimeuuid", TimeUUIDType.instance), TimeFcts.now("currenttimestamp", TimestampType.instance), TimeFcts.now("currentdate", SimpleDateType.instance), TimeFcts.now("currenttime", TimeType.instance), minTimeuuidFct, maxTimeuuidFct, dateOfFct, unixTimestampOfFct, TimeFcts.toDate(TimeUUIDType.instance), TimeFcts.toTimestamp(TimeUUIDType.instance), TimeFcts.toUnixTimestamp(TimeUUIDType.instance), new Function[]{TimeFcts.toUnixTimestamp(TimestampType.instance), TimeFcts.toDate(TimestampType.instance), TimeFcts.toUnixTimestamp(SimpleDateType.instance), TimeFcts.toTimestamp(SimpleDateType.instance)});
    }

    public static final Function now(String name, final TemporalType<?> type) {
        return new NativeScalarFunction(name, type, new AbstractType[0]){

            @Override
            public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
                return type.now();
            }
        };
    }

    public static final NativeScalarFunction toDate(final TemporalType<?> type) {
        return new NativeScalarFunction("todate", (AbstractType)SimpleDateType.instance, new AbstractType[]{type}){

            @Override
            public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
                ByteBuffer bb = parameters.get(0);
                if (bb == null || !bb.hasRemaining()) {
                    return null;
                }
                long millis = type.toTimeInMillis(bb);
                return SimpleDateType.instance.fromTimeInMillis(millis);
            }
        };
    }

    public static final NativeScalarFunction toTimestamp(final TemporalType<?> type) {
        return new NativeScalarFunction("totimestamp", (AbstractType)TimestampType.instance, new AbstractType[]{type}){

            @Override
            public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
                ByteBuffer bb = parameters.get(0);
                if (bb == null || !bb.hasRemaining()) {
                    return null;
                }
                long millis = type.toTimeInMillis(bb);
                return TimestampType.instance.fromTimeInMillis(millis);
            }
        };
    }

    public static final NativeScalarFunction toUnixTimestamp(final TemporalType<?> type) {
        return new NativeScalarFunction("tounixtimestamp", (AbstractType)LongType.instance, new AbstractType[]{type}){

            @Override
            public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
                ByteBuffer bb = parameters.get(0);
                if (bb == null || !bb.hasRemaining()) {
                    return null;
                }
                return ByteBufferUtil.bytes(type.toTimeInMillis(bb));
            }
        };
    }
}

