/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.UserTypes;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.ResultSetBuilder;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.transport.ProtocolVersion;

final class UserTypeSelector
extends Selector {
    private final AbstractType<?> type;
    private final Map<FieldIdentifier, Selector> fields;

    public static Selector.Factory newFactory(final AbstractType<?> type, final Map<FieldIdentifier, Selector.Factory> factories) {
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return UserTypes.userTypeToString(factories, Selector.Factory::getColumnName);
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return type;
            }

            @Override
            protected final void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultsColumn) {
                SelectionColumnMapping tmpMapping = SelectionColumnMapping.newMapping();
                for (Selector.Factory factory : factories.values()) {
                    factory.addColumnMapping(tmpMapping, resultsColumn);
                }
                if (tmpMapping.getMappings().get(resultsColumn).isEmpty()) {
                    mapping.addMapping(resultsColumn, (ColumnMetadata)null);
                } else {
                    mapping.addMapping(resultsColumn, tmpMapping.getMappings().values());
                }
            }

            @Override
            public Selector newInstance(QueryOptions options) {
                HashMap fields = new HashMap(factories.size());
                for (Map.Entry factory : factories.entrySet()) {
                    fields.put(factory.getKey(), ((Selector.Factory)factory.getValue()).newInstance(options));
                }
                return new UserTypeSelector(type, fields);
            }

            @Override
            public boolean isAggregateSelectorFactory() {
                for (Selector.Factory factory : factories.values()) {
                    if (!factory.isAggregateSelectorFactory()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void addFunctionsTo(List<Function> functions) {
                for (Selector.Factory factory : factories.values()) {
                    factory.addFunctionsTo(functions);
                }
            }

            @Override
            public boolean isWritetimeSelectorFactory() {
                for (Selector.Factory factory : factories.values()) {
                    if (!factory.isWritetimeSelectorFactory()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isTTLSelectorFactory() {
                for (Selector.Factory factory : factories.values()) {
                    if (!factory.isTTLSelectorFactory()) continue;
                    return true;
                }
                return false;
            }

            @Override
            boolean areAllFetchedColumnsKnown() {
                for (Selector.Factory factory : factories.values()) {
                    if (factory.areAllFetchedColumnsKnown()) continue;
                    return false;
                }
                return true;
            }

            @Override
            void addFetchedColumns(ColumnFilter.Builder builder) {
                for (Selector.Factory factory : factories.values()) {
                    factory.addFetchedColumns(builder);
                }
            }
        };
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
        for (Selector field : this.fields.values()) {
            field.addFetchedColumns(builder);
        }
    }

    @Override
    public void addInput(ProtocolVersion protocolVersion, ResultSetBuilder rs) throws InvalidRequestException {
        for (Selector field : this.fields.values()) {
            field.addInput(protocolVersion, rs);
        }
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) throws InvalidRequestException {
        UserType userType = (UserType)this.type;
        ByteBuffer[] buffers = new ByteBuffer[userType.size()];
        int m3 = userType.size();
        for (int i = 0; i < m3; ++i) {
            Selector selector = this.fields.get(userType.fieldName(i));
            if (selector == null) continue;
            buffers[i] = selector.getOutput(protocolVersion);
        }
        return TupleType.buildValue(buffers);
    }

    @Override
    public void reset() {
        for (Selector field : this.fields.values()) {
            field.reset();
        }
    }

    @Override
    public AbstractType<?> getType() {
        return this.type;
    }

    public String toString() {
        return UserTypes.userTypeToString(this.fields);
    }

    private UserTypeSelector(AbstractType<?> type, Map<FieldIdentifier, Selector> fields) {
        this.type = type;
        this.fields = fields;
    }
}

