/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Range;
import java.io.Closeable;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.client.SidecarInstanceImpl;
import o.a.c.sidecar.client.shaded.common.response.NodeSettings;
import o.a.c.sidecar.client.shaded.common.response.SchemaResponse;
import o.a.c.sidecar.client.shaded.common.response.TimeSkewResponse;
import o.a.c.sidecar.client.shaded.common.response.TokenRangeReplicasResponse;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraVersionFeatures;
import org.apache.cassandra.clients.Sidecar;
import org.apache.cassandra.spark.bulkwriter.BroadcastableClusterInfo;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.CassandraContext;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.WriteAvailability;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.exception.SidecarApiCallException;
import org.apache.cassandra.spark.exception.TimeSkewTooLargeException;
import org.apache.cassandra.spark.utils.CqlUtils;
import org.apache.cassandra.spark.utils.FutureUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraClusterInfo
implements ClusterInfo,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraClusterInfo.class);
    protected final BulkSparkConf conf;
    protected final String clusterId;
    protected String cassandraVersion;
    protected Partitioner partitioner;
    protected volatile TokenRangeMapping<RingInstance> tokenRangeReplicas;
    protected volatile String keyspaceSchema;
    protected volatile ReplicationFactor replicationFactor;
    protected volatile CassandraContext cassandraContext;
    protected final AtomicReference<NodeSettings> nodeSettings;
    protected final List<CompletableFuture<NodeSettings>> allNodeSettingFutures;

    public CassandraClusterInfo(BulkSparkConf conf) {
        this(conf, null);
    }

    public CassandraClusterInfo(BulkSparkConf conf, String clusterId) {
        this.conf = conf;
        this.clusterId = clusterId;
        this.cassandraContext = this.buildCassandraContext();
        LOGGER.info("Getting Cassandra versions from all nodes");
        this.nodeSettings = new AtomicReference<Object>(null);
        this.allNodeSettingFutures = Sidecar.allNodeSettings((SidecarClient)this.cassandraContext.getSidecarClient(), this.cassandraContext.getCluster());
    }

    public CassandraClusterInfo(BroadcastableClusterInfo broadcastable) {
        this.conf = broadcastable.getConf();
        this.clusterId = broadcastable.clusterId();
        this.cassandraVersion = broadcastable.getLowestCassandraVersion();
        this.partitioner = broadcastable.getPartitioner();
        this.cassandraContext = this.buildCassandraContext();
        LOGGER.info("Reconstructing CassandraClusterInfo on executor from BroadcastableCluster. clusterId={}", (Object)this.clusterId);
        this.nodeSettings = new AtomicReference<Object>(null);
        this.allNodeSettingFutures = null;
    }

    @Override
    public void checkBulkWriterIsEnabledOrThrow() {
    }

    public String getVersion() {
        return CassandraClusterInfo.class.getPackage().getImplementationVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CassandraContext getCassandraContext() {
        CassandraContext currentCassandraContext = this.cassandraContext;
        if (currentCassandraContext != null) {
            return currentCassandraContext;
        }
        CassandraClusterInfo cassandraClusterInfo = this;
        synchronized (cassandraClusterInfo) {
            if (this.cassandraContext == null) {
                this.cassandraContext = this.buildCassandraContext();
            }
            return this.cassandraContext;
        }
    }

    @Override
    public String clusterId() {
        return this.clusterId;
    }

    protected CassandraContext buildCassandraContext() {
        return CassandraClusterInfo.buildCassandraContext(this.conf, this.clusterId);
    }

    private static CassandraContext buildCassandraContext(BulkSparkConf conf, @Nullable String clusterId) {
        return CassandraContext.create(conf, clusterId);
    }

    @Override
    public void close() {
        LOGGER.info("Closing {}", (Object)this);
        this.getCassandraContext().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partitioner getPartitioner() {
        Partitioner currentPartitioner = this.partitioner;
        if (currentPartitioner != null) {
            return currentPartitioner;
        }
        CassandraClusterInfo cassandraClusterInfo = this;
        synchronized (cassandraClusterInfo) {
            if (this.partitioner == null) {
                try {
                    NodeSettings currentNodeSettings = this.nodeSettings.get();
                    String partitionerString = currentNodeSettings != null ? currentNodeSettings.partitioner() : ((NodeSettings)this.getCassandraContext().getSidecarClient().nodeSettings().get()).partitioner();
                    this.partitioner = Partitioner.from((String)partitionerString);
                }
                catch (InterruptedException | ExecutionException exception) {
                    throw new RuntimeException("Unable to retrieve partitioner information", exception);
                }
            }
            return this.partitioner;
        }
    }

    @Override
    public void validateTimeSkew(Range<BigInteger> range) throws SidecarApiCallException, TimeSkewTooLargeException {
        this.validateTimeSkewWithLocalNow(range, Instant.now());
    }

    @VisibleForTesting
    void validateTimeSkewWithLocalNow(Range<BigInteger> range, Instant localNow) throws SidecarApiCallException, TimeSkewTooLargeException {
        TimeSkewResponse timeSkew;
        try {
            TokenRangeMapping<RingInstance> topology = this.getTokenRangeMapping(true);
            List instances = topology.getSubRanges(range).asMapOfRanges().values().stream().flatMap(Collection::stream).distinct().map(replica -> new SidecarInstanceImpl(replica.nodeName(), this.getCassandraContext().sidecarPort())).collect(Collectors.toList());
            timeSkew = (TimeSkewResponse)this.getCassandraContext().getSidecarClient().timeSkew(instances).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new SidecarApiCallException("Unable to retrieve time skew information. clusterId=" + this.clusterId(), (Throwable)exception);
        }
        Instant remoteNow = Instant.ofEpochMilli(timeSkew.currentTime);
        Duration allowedDuration = Duration.ofMinutes(timeSkew.allowableSkewInMinutes);
        if (localNow.isBefore(remoteNow.minus(allowedDuration)) || localNow.isAfter(remoteNow.plus(allowedDuration))) {
            throw new TimeSkewTooLargeException(timeSkew.allowableSkewInMinutes, localNow, remoteNow, this.clusterId());
        }
    }

    @Override
    public synchronized void refreshClusterInfo() {
        this.keyspaceSchema = null;
        this.getCassandraContext().refreshClusterConfig();
    }

    protected String getCurrentKeyspaceSchema() throws Exception {
        SchemaResponse schemaResponse = (SchemaResponse)this.getCassandraContext().getSidecarClient().schema(CassandraBridgeFactory.maybeQuotedIdentifier(this.bridge(), this.conf.quoteIdentifiers, this.conf.keyspace)).get();
        return schemaResponse.schema();
    }

    private TokenRangeReplicasResponse getTokenRangesAndReplicaSets() {
        CassandraContext context = this.getCassandraContext();
        try {
            long start = System.nanoTime();
            TokenRangeReplicasResponse response = (TokenRangeReplicasResponse)context.getSidecarClient().tokenRangeReplicas(new ArrayList<SidecarInstance>(context.getCluster()), this.conf.keyspace).get();
            long elapsedTimeNanos = System.nanoTime() - start;
            LOGGER.info("Retrieved token ranges for {} instances in {} milliseconds", (Object)response.writeReplicas().size(), (Object)TimeUnit.NANOSECONDS.toMillis(elapsedTimeNanos));
            return response;
        }
        catch (InterruptedException | ExecutionException exception) {
            LOGGER.error("Failed to get token ranges for keyspace {}", (Object)this.conf.keyspace, (Object)exception);
            throw new SidecarApiCallException("Failed to get token ranges for keyspace" + this.conf.keyspace, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getKeyspaceSchema(boolean cached) {
        String currentKeyspaceSchema = this.keyspaceSchema;
        if (cached && currentKeyspaceSchema != null) {
            return currentKeyspaceSchema;
        }
        CassandraClusterInfo cassandraClusterInfo = this;
        synchronized (cassandraClusterInfo) {
            if (!cached || this.keyspaceSchema == null) {
                try {
                    this.keyspaceSchema = this.getCurrentKeyspaceSchema();
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to initialize schema information for keyspace " + this.conf.keyspace, exception);
                }
            }
            return this.keyspaceSchema;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationFactor replicationFactor() {
        ReplicationFactor rf = this.replicationFactor;
        if (rf != null) {
            return rf;
        }
        String keyspaceSchema = this.getKeyspaceSchema(true);
        if (keyspaceSchema == null) {
            throw new RuntimeException("Could not retrieve keyspace schema information for keyspace " + this.conf.keyspace);
        }
        CassandraClusterInfo cassandraClusterInfo = this;
        synchronized (cassandraClusterInfo) {
            if (this.replicationFactor == null) {
                this.replicationFactor = CqlUtils.extractReplicationFactor((String)keyspaceSchema, (String)this.conf.keyspace);
            }
            return this.replicationFactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenRangeMapping<RingInstance> getTokenRangeMapping(boolean cached) {
        TokenRangeMapping<RingInstance> topology = this.tokenRangeReplicas;
        if (cached && topology != null) {
            return topology;
        }
        if (topology != null) {
            this.tokenRangeReplicas = topology = this.getTokenRangeReplicasFromSidecar();
            return topology;
        }
        CassandraClusterInfo cassandraClusterInfo = this;
        synchronized (cassandraClusterInfo) {
            try {
                this.tokenRangeReplicas = this.getTokenRangeReplicasFromSidecar();
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to initialize ring information", exception);
            }
            return this.tokenRangeReplicas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLowestCassandraVersion() {
        String currentCassandraVersion = this.cassandraVersion;
        if (currentCassandraVersion != null) {
            return currentCassandraVersion;
        }
        CassandraClusterInfo cassandraClusterInfo = this;
        synchronized (cassandraClusterInfo) {
            if (this.cassandraVersion == null) {
                String versionFromFeature = this.getVersionFromFeature();
                this.cassandraVersion = versionFromFeature != null ? versionFromFeature : this.getVersionFromSidecar();
            }
        }
        return this.cassandraVersion;
    }

    @Override
    public Map<RingInstance, WriteAvailability> clusterWriteAvailability() {
        Set<RingInstance> allInstances = this.getTokenRangeMapping(true).allInstances();
        HashMap<RingInstance, WriteAvailability> result = new HashMap<RingInstance, WriteAvailability>(allInstances.size());
        for (RingInstance instance : allInstances) {
            result.put(instance, this.determineWriteAvailability(instance));
        }
        if (LOGGER.isDebugEnabled()) {
            result.forEach((inst, avail) -> LOGGER.debug("Instance {} has availability {}", inst, (Object)avail));
        }
        return result;
    }

    protected WriteAvailability determineWriteAvailability(RingInstance instance) {
        return WriteAvailability.determineFromNodeState(instance.nodeState(), instance.nodeStatus());
    }

    private TokenRangeMapping<RingInstance> getTokenRangeReplicasFromSidecar() {
        return TokenRangeMapping.create(this::getTokenRangesAndReplicaSets, this::getPartitioner, metadata -> new RingInstance((TokenRangeReplicasResponse.ReplicaMetadata)metadata, this.clusterId()));
    }

    public String getVersionFromFeature() {
        return null;
    }

    protected List<NodeSettings> getAllNodeSettings() {
        if (this.allNodeSettingFutures == null) {
            throw new IllegalStateException("getAllNodeSettings should not be called on executor. Cassandra version is pre-computed on driver and broadcast to executors.");
        }
        long totalTimeout = this.conf.getSidecarRequestMaxRetryDelayMillis() * (long)this.conf.getSidecarRequestRetries() * (long)this.allNodeSettingFutures.size();
        List allNodeSettings = FutureUtils.bestEffortGet(this.allNodeSettingFutures, (long)totalTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
        if (allNodeSettings.isEmpty()) {
            throw new RuntimeException(String.format("Unable to determine the node settings. 0/%d instances available.", this.allNodeSettingFutures.size()));
        }
        if (allNodeSettings.size() < this.allNodeSettingFutures.size()) {
            LOGGER.warn("{}/{} instances were used to determine the node settings", (Object)allNodeSettings.size(), (Object)this.allNodeSettingFutures.size());
        }
        return allNodeSettings;
    }

    public String getVersionFromSidecar() {
        NodeSettings nodeSettings = this.nodeSettings.get();
        if (nodeSettings != null) {
            return nodeSettings.releaseVersion();
        }
        return this.getLowestVersion(this.getAllNodeSettings());
    }

    @VisibleForTesting
    public String getLowestVersion(List<NodeSettings> allNodeSettings) {
        NodeSettings ns = this.nodeSettings.get();
        if (ns != null) {
            return ns.releaseVersion();
        }
        ns = allNodeSettings.stream().filter(settings -> !settings.releaseVersion().equalsIgnoreCase("unknown")).min(Comparator.comparing(settings -> CassandraVersionFeatures.cassandraVersionFeaturesFromCassandraVersion((String)settings.releaseVersion()))).orElseThrow(() -> new RuntimeException("No valid Cassandra Versions were returned from Cassandra Sidecar"));
        this.nodeSettings.compareAndSet(null, ns);
        return ns.releaseVersion();
    }

    protected CassandraBridge bridge() {
        return CassandraBridgeFactory.get(this.getLowestCassandraVersion());
    }

    @Override
    public void startupValidate() {
        this.getCassandraContext().startupValidate();
    }
}

