/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.bridge.type.InternalDuration;
import org.apache.cassandra.spark.data.BridgeUdtValue;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.ScalaConversionUtils;
import org.apache.cassandra.spark.utils.SparkTypeUtils;
import org.apache.cassandra.spark.utils.UUIDs;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.math.BigDecimal;
import scala.math.BigInt;

public final class SqlToCqlTypeConverter
implements Serializable {
    public static final String ASCII = "ascii";
    public static final String BIGINT = "bigint";
    public static final String BLOB = "blob";
    public static final String BOOLEAN = "boolean";
    public static final String COUNTER = "counter";
    public static final String CUSTOM = "custom";
    public static final String DATE = "date";
    public static final String DECIMAL = "decimal";
    public static final String DOUBLE = "double";
    public static final String DURATION = "duration";
    public static final String FLOAT = "float";
    public static final String FROZEN = "frozen";
    public static final String INET = "inet";
    public static final String INT = "int";
    public static final String LIST = "list";
    public static final String MAP = "map";
    public static final String SET = "set";
    public static final String SMALLINT = "smallint";
    public static final String TEXT = "text";
    public static final String TIME = "time";
    public static final String UUID = "uuid";
    public static final String TIMESTAMP = "timestamp";
    public static final String TIMEUUID = "timeuuid";
    public static final String TINYINT = "tinyint";
    public static final String TUPLE = "tuple";
    public static final String UDT = "udt";
    public static final String VARCHAR = "varchar";
    public static final String VARINT = "varint";
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlToCqlTypeConverter.class);
    private static final NoOp<Object> NO_OP_CONVERTER = new NoOp();
    private static final LongConverter LONG_CONVERTER = new LongConverter();
    private static final BytesConverter BYTES_CONVERTER = new BytesConverter();
    private static final BigDecimalConverter BIG_DECIMAL_CONVERTER = new BigDecimalConverter();
    private static final IntegerConverter INTEGER_CONVERTER = new IntegerConverter();
    public static final TimestampConverter TIMESTAMP_CONVERTER = new TimestampConverter();
    private static final MicroSecondsTimestampConverter MICROSECONDS_TIMESTAMP_CONVERTER = new MicroSecondsTimestampConverter();
    public static final TimeConverter TIME_CONVERTER = new TimeConverter();
    private static final UUIDConverter UUID_CONVERTER = new UUIDConverter();
    private static final BigIntegerConverter BIG_INTEGER_CONVERTER = new BigIntegerConverter();
    private static final TimeUUIDConverter TIME_UUID_CONVERTER = new TimeUUIDConverter();
    private static final InetAddressConverter INET_ADDRESS_CONVERTER = new InetAddressConverter();
    public static final DateConverter DATE_CONVERTER = new DateConverter();
    public static final DurationConverter DURATION_CONVERTER = new DurationConverter();

    private SqlToCqlTypeConverter() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static Converter<?> getConverter(CqlField.CqlType cqlType) {
        String cqlName;
        switch (cqlName = cqlType.name().toLowerCase()) {
            case "custom": {
                return SqlToCqlTypeConverter.determineCustomConvert((CqlField.CqlCustom)cqlType);
            }
            case "ascii": {
                return NO_OP_CONVERTER;
            }
            case "bigint": {
                return LONG_CONVERTER;
            }
            case "blob": {
                return BYTES_CONVERTER;
            }
            case "boolean": {
                return NO_OP_CONVERTER;
            }
            case "counter": {
                return NO_OP_CONVERTER;
            }
            case "decimal": {
                return BIG_DECIMAL_CONVERTER;
            }
            case "double": {
                return NO_OP_CONVERTER;
            }
            case "duration": {
                return DURATION_CONVERTER;
            }
            case "float": {
                return NO_OP_CONVERTER;
            }
            case "frozen": {
                assert (cqlType instanceof CqlField.CqlFrozen);
                CqlField.CqlFrozen frozen = (CqlField.CqlFrozen)cqlType;
                return SqlToCqlTypeConverter.getConverter(frozen.inner());
            }
            case "int": {
                return INTEGER_CONVERTER;
            }
            case "text": {
                return NO_OP_CONVERTER;
            }
            case "timestamp": {
                return TIMESTAMP_CONVERTER;
            }
            case "time": {
                return TIME_CONVERTER;
            }
            case "uuid": {
                return UUID_CONVERTER;
            }
            case "varchar": {
                return NO_OP_CONVERTER;
            }
            case "varint": {
                return BIG_INTEGER_CONVERTER;
            }
            case "timeuuid": {
                return TIME_UUID_CONVERTER;
            }
            case "inet": {
                return INET_ADDRESS_CONVERTER;
            }
            case "date": {
                return DATE_CONVERTER;
            }
            case "smallint": {
                return NO_OP_CONVERTER;
            }
            case "tinyint": {
                return NO_OP_CONVERTER;
            }
            case "list": {
                return new ListConverter((CqlField.CqlCollection)cqlType);
            }
            case "map": {
                assert (cqlType instanceof CqlField.CqlMap);
                return new MapConverter((CqlField.CqlMap)cqlType);
            }
            case "set": {
                return new SetConverter((CqlField.CqlCollection)cqlType);
            }
            case "tuple": {
                return NO_OP_CONVERTER;
            }
        }
        if (cqlType.internalType() == CqlField.CqlType.InternalType.Udt) {
            assert (cqlType instanceof CqlField.CqlUdt);
            return new UdtConverter((CqlField.CqlUdt)cqlType);
        }
        LOGGER.warn("Unable to match type={}. Defaulting to NoOp Converter", (Object)cqlName);
        return NO_OP_CONVERTER;
    }

    public static Converter<?> integerConverter() {
        return INTEGER_CONVERTER;
    }

    public static Converter<?> microsecondsTimestampConverter() {
        return MICROSECONDS_TIMESTAMP_CONVERTER;
    }

    static boolean canConvertToLong(Object object) {
        return object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte;
    }

    static long convertToLong(Object object) {
        return ((Number)object).longValue();
    }

    private static Converter<?> determineCustomConvert(CqlField.CqlCustom customType) {
        Preconditions.checkArgument((boolean)customType.name().equalsIgnoreCase(CUSTOM), (Object)"Non-custom types are not supported");
        if (customType.customTypeClassName().equalsIgnoreCase("org.apache.cassandra.db.marshal.DateType")) {
            return TIMESTAMP_CONVERTER;
        }
        return NO_OP_CONVERTER;
    }

    public static class UdtConverter
    extends NullableConverter<BridgeUdtValue> {
        private final String name;
        private final HashMap<String, Converter<?>> converters;

        UdtConverter(CqlField.CqlUdt udt) {
            this.name = udt.cqlName();
            this.converters = new HashMap();
            for (CqlField f : udt.fields()) {
                this.converters.put(f.name(), SqlToCqlTypeConverter.getConverter(f.type()));
            }
        }

        @Override
        public BridgeUdtValue convertInternal(Object object) {
            if (object instanceof GenericRowWithSchema) {
                Map<String, Object> udtMap = this.makeUdtMap((GenericRowWithSchema)object);
                return new BridgeUdtValue(this.name, udtMap);
            }
            throw new RuntimeException("Unsupported conversion for UDT from " + object.getClass().getTypeName());
        }

        public String toString() {
            return String.format("UDT[%s]", this.name);
        }

        private Map<String, Object> makeUdtMap(GenericRowWithSchema row) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String fieldName : row.schema().fieldNames()) {
                Converter<?> converter = this.converters.get(fieldName);
                Object val = row.get(row.fieldIndex(fieldName));
                result.put(fieldName, converter.convert(val));
            }
            return result;
        }
    }

    static class MapConverter<K, V>
    extends NullableConverter<Map<K, V>> {
        private final Converter<?> keyConverter;
        private final Converter<?> valConverter;

        MapConverter(CqlField.CqlMap cqlType) {
            this.keyConverter = SqlToCqlTypeConverter.getConverter(cqlType.keyType());
            this.valConverter = SqlToCqlTypeConverter.getConverter(cqlType.valueType());
        }

        @Override
        public Map<K, V> convertInternal(Object object) {
            if (object instanceof Iterable) {
                return this.makeMap(ScalaConversionUtils.asJavaIterable((Iterable)((Iterable)object)));
            }
            if (object instanceof java.lang.Iterable) {
                return this.makeMap((java.lang.Iterable)object);
            }
            if (object instanceof Map) {
                return this.makeMap(((Map)object).entrySet());
            }
            throw new RuntimeException("Unsupported conversion for MAP from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "Map<" + this.keyConverter.toString() + ", " + this.valConverter.toString() + ">";
        }

        private Map<K, V> makeMap(java.lang.Iterable<?> iterable) {
            HashMap map = new HashMap();
            for (Object object : iterable) {
                Object value;
                Object key;
                if (object instanceof Map.Entry) {
                    key = ((Map.Entry)object).getKey();
                    value = ((Map.Entry)object).getValue();
                } else if (object instanceof Tuple2) {
                    key = ((Tuple2)object)._1();
                    value = ((Tuple2)object)._2();
                } else {
                    throw new RuntimeException("Unsupported conversion for key/value pair in MAP from " + object.getClass().getTypeName());
                }
                map.put(this.keyConverter.convert(key), this.valConverter.convert(value));
            }
            return map;
        }
    }

    static class SetConverter<E>
    extends NullableConverter<Set<E>> {
        private final Converter<?> innerConverter;

        SetConverter(CqlField.CqlCollection cqlType) {
            this.innerConverter = SqlToCqlTypeConverter.getConverter(cqlType.type());
        }

        @Override
        public Set<E> convertInternal(Object object) {
            if (object instanceof Iterable) {
                return this.makeSet(ScalaConversionUtils.asJavaIterable((Iterable)((Iterable)object)));
            }
            if (object instanceof java.lang.Iterable) {
                return this.makeSet((java.lang.Iterable)object);
            }
            throw new RuntimeException("Unsupported conversion for SET from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "Set<" + this.innerConverter.toString() + ">";
        }

        private Set<E> makeSet(java.lang.Iterable<?> iterable) {
            HashSet set = new HashSet();
            for (Object object : iterable) {
                set.add(this.innerConverter.convert(object));
            }
            return set;
        }
    }

    static class ListConverter<E>
    extends NullableConverter<List<E>> {
        private final Converter<?> innerConverter;

        ListConverter(CqlField.CqlCollection cqlType) {
            this.innerConverter = SqlToCqlTypeConverter.getConverter(cqlType.type());
        }

        @Override
        public List<E> convertInternal(Object object) {
            if (object instanceof Iterable) {
                return this.makeList(ScalaConversionUtils.asJavaIterable((Iterable)((Iterable)object)));
            }
            if (object instanceof java.lang.Iterable) {
                return this.makeList((java.lang.Iterable)object);
            }
            throw new RuntimeException("Unsupported conversion for LIST from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "List";
        }

        private List<E> makeList(java.lang.Iterable<?> iterable) {
            ArrayList list = new ArrayList();
            for (Object object : iterable) {
                list.add(this.innerConverter.convert(object));
            }
            return list;
        }
    }

    static class TimeUUIDConverter
    extends NullableConverter<UUID> {
        TimeUUIDConverter() {
        }

        @Override
        public UUID convertInternal(Object object) {
            UUID result;
            if (object instanceof UUID) {
                result = (UUID)object;
            } else if (object instanceof String) {
                result = java.util.UUID.fromString((String)object);
            } else if (object instanceof Long) {
                result = UUIDs.startOf((long)((Long)object));
            } else {
                throw new RuntimeException("Unsupported conversion for TIMEUUID from " + object.getClass().getTypeName());
            }
            if (result.version() == 1) {
                return result;
            }
            throw new RuntimeException("Attempted to convert a non-Timestamp UUID to a TimeUUID - UUID was " + String.valueOf(object));
        }

        public String toString() {
            return "TimeUUID";
        }
    }

    static class UUIDConverter
    extends NullableConverter<UUID> {
        UUIDConverter() {
        }

        @Override
        public UUID convertInternal(Object object) {
            if (object instanceof UUID) {
                return (UUID)object;
            }
            if (object instanceof String) {
                return java.util.UUID.fromString((String)object);
            }
            throw new RuntimeException("Unsupported conversion for UUID from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "UUID";
        }
    }

    public static class TimeConverter
    extends NullableConverter<Long> {
        @Override
        public Long convertInternal(Object object) {
            if (object instanceof Long) {
                long result = (Long)object;
                if (result < 0L || result >= TimeUnit.DAYS.toNanos(1L)) {
                    throw new IllegalArgumentException("Input value out of bounds for Cassandra Time field: " + result);
                }
                return (long)((Long)object);
            }
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                long rawTime = 0L;
                rawTime += TimeUnit.HOURS.toNanos(timestamp.getHours());
                rawTime += TimeUnit.MINUTES.toNanos(timestamp.getMinutes());
                rawTime += TimeUnit.SECONDS.toNanos(timestamp.getSeconds());
                return rawTime += (long)timestamp.getNanos();
            }
            throw new RuntimeException("Unsupported conversion for TIME from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "Time";
        }
    }

    public static class DurationConverter
    extends NullableConverter<InternalDuration> {
        @Override
        public InternalDuration convertInternal(Object object) {
            if (object instanceof CalendarInterval) {
                CalendarInterval cl = (CalendarInterval)object;
                return SparkTypeUtils.convertDuration((CalendarInterval)cl);
            }
            throw new RuntimeException("Unsupported conversion for DURATION from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "Duration";
        }
    }

    public static class DateConverter
    extends NullableConverter<Integer> {
        public String toString() {
            return "Date";
        }

        @Override
        public Integer convertInternal(Object object) {
            if (object instanceof Date) {
                return this.fromDate((Date)object);
            }
            if (object instanceof Long) {
                return this.fromMillisSinceEpoch((Long)object);
            }
            throw new RuntimeException("Unsupported conversion for DATE from " + object.getClass().getTypeName());
        }

        protected int fromDate(Date value) {
            long millisSinceEpoch = value.getTime();
            return this.fromMillisSinceEpoch(millisSinceEpoch);
        }

        protected int fromMillisSinceEpoch(long millisSinceEpoch) {
            int result = (int)TimeUnit.MILLISECONDS.toDays(millisSinceEpoch);
            return result -= Integer.MIN_VALUE;
        }
    }

    public static class TimestampConverter
    extends NullableConverter<Date> {
        @Override
        public Date convertInternal(Object object) {
            if (object instanceof Date) {
                return (Date)object;
            }
            if (object instanceof Long) {
                return new Date((Long)object);
            }
            throw new RuntimeException("Unsupported conversion for DATE from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "Timestamp";
        }
    }

    static class MicroSecondsTimestampConverter
    extends Converter<Long> {
        MicroSecondsTimestampConverter() {
        }

        @Override
        public Long convertInternal(Object object) {
            if (object instanceof Date) {
                Instant instant = ((Date)object).toInstant();
                return TimeUnit.SECONDS.toMicros(instant.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(instant.getNano());
            }
            if (SqlToCqlTypeConverter.canConvertToLong(object)) {
                return SqlToCqlTypeConverter.convertToLong(object);
            }
            throw new RuntimeException("Unsupported conversion for TIMESTAMP from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "Timestamp";
        }
    }

    static class BigIntegerConverter
    extends NullableConverter<BigInteger> {
        BigIntegerConverter() {
        }

        @Override
        public BigInteger convertInternal(Object object) {
            if (object instanceof BigInteger) {
                return (BigInteger)object;
            }
            if (object instanceof BigInt) {
                return ((BigInt)object).bigInteger();
            }
            if (object instanceof String) {
                return new BigInteger((String)object);
            }
            if (object instanceof Long) {
                return BigInteger.valueOf((Long)object);
            }
            if (object instanceof Integer) {
                return BigInteger.valueOf(((Integer)object).intValue());
            }
            throw new RuntimeException("Unsupported conversion for VARCHAR from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "VarChar";
        }
    }

    static class IntegerConverter
    extends NullableConverter<Integer> {
        IntegerConverter() {
        }

        @Override
        public Integer convertInternal(Object object) {
            if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
                return ((Number)object).intValue();
            }
            throw new RuntimeException("Unsupported conversion for INTEGER from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "Integer";
        }
    }

    static class InetAddressConverter
    extends NullableConverter<InetAddress> {
        InetAddressConverter() {
        }

        @Override
        public InetAddress convertInternal(Object object) {
            if (object instanceof InetAddress) {
                return (InetAddress)object;
            }
            if (object instanceof String) {
                return InetAddresses.forString((String)((String)object));
            }
            throw new RuntimeException("Unsupported conversion for INET from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "Inet";
        }
    }

    static class BigDecimalConverter
    extends NullableConverter<java.math.BigDecimal> {
        BigDecimalConverter() {
        }

        @Override
        public java.math.BigDecimal convertInternal(Object object) {
            if (object instanceof java.math.BigDecimal) {
                return (java.math.BigDecimal)object;
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).bigDecimal();
            }
            if (object instanceof String) {
                return new java.math.BigDecimal((String)object);
            }
            if (object instanceof Double) {
                return java.math.BigDecimal.valueOf((Double)object);
            }
            if (object instanceof Float) {
                return java.math.BigDecimal.valueOf(((Float)object).floatValue());
            }
            if (object instanceof Long) {
                return java.math.BigDecimal.valueOf((Long)object);
            }
            if (object instanceof Integer) {
                return java.math.BigDecimal.valueOf(((Integer)object).intValue());
            }
            throw new RuntimeException("Unsupported conversion for DECIMAL from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "Decimal";
        }
    }

    static class BytesConverter
    extends NullableConverter<ByteBuffer> {
        BytesConverter() {
        }

        @Override
        public ByteBuffer convertInternal(Object object) {
            if (object instanceof ByteBuffer) {
                return (ByteBuffer)object;
            }
            if (object instanceof byte[]) {
                return ByteBuffer.wrap((byte[])object);
            }
            throw new RuntimeException("Unsupported conversion for BYTES from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "Bytes";
        }
    }

    static class LongConverter
    extends NullableConverter<Long> {
        LongConverter() {
        }

        @Override
        public Long convertInternal(Object object) {
            if (SqlToCqlTypeConverter.canConvertToLong(object)) {
                return SqlToCqlTypeConverter.convertToLong(object);
            }
            throw new RuntimeException("Unsupported conversion for LONG from " + object.getClass().getTypeName());
        }

        public String toString() {
            return "Long";
        }
    }

    static class NoOp<T>
    extends NullableConverter<T> {
        NoOp() {
        }

        @Override
        public T convertInternal(Object object) {
            return (T)object;
        }

        public String toString() {
            return "NoOp";
        }
    }

    private static abstract class NullableConverter<T>
    extends Converter<T> {
        private NullableConverter() {
        }

        @Override
        public T convert(Object object) {
            return object != null ? (T)super.convert(object) : null;
        }
    }

    public static abstract class Converter<T>
    implements Serializable {
        public T convert(Object object) {
            return this.convertInternal(object);
        }

        abstract T convertInternal(Object var1);
    }
}

