/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Range;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.client.SidecarInstanceImpl;
import o.a.c.sidecar.client.shaded.client.SidecarInstancesProvider;
import o.a.c.sidecar.client.shaded.client.SimpleSidecarInstancesProvider;
import o.a.c.sidecar.client.shaded.client.exception.RetriesExhaustedException;
import o.a.c.sidecar.client.shaded.common.response.ListSnapshotFilesResponse;
import o.a.c.sidecar.client.shaded.common.response.NodeSettings;
import o.a.c.sidecar.client.shaded.common.response.RingResponse;
import o.a.c.sidecar.client.shaded.common.response.SchemaResponse;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.bridge.BigNumberConfigImpl;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.clients.ExecutorHolder;
import org.apache.cassandra.clients.Sidecar;
import org.apache.cassandra.secrets.SecretsProvider;
import org.apache.cassandra.secrets.SslConfig;
import org.apache.cassandra.secrets.SslConfigSecretsProvider;
import org.apache.cassandra.spark.common.SidecarInstanceFactory;
import org.apache.cassandra.spark.common.SizingFactory;
import org.apache.cassandra.spark.config.SchemaFeature;
import org.apache.cassandra.spark.config.SchemaFeatureSet;
import org.apache.cassandra.spark.data.ClientConfig;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.IncompleteSSTableException;
import org.apache.cassandra.spark.data.PartitionedDataLayer;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.data.SidecarProvisionedSSTable;
import org.apache.cassandra.spark.data.Sizing;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.CassandraRing;
import org.apache.cassandra.spark.data.partitioner.ConsistencyLevel;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.data.partitioner.TokenPartitioner;
import org.apache.cassandra.spark.sparksql.LastModifiedTimestampDecorator;
import org.apache.cassandra.spark.sparksql.RowBuilder;
import org.apache.cassandra.spark.sparksql.filters.SSTableTimeRangeFilter;
import org.apache.cassandra.spark.utils.CqlUtils;
import org.apache.cassandra.spark.utils.Properties;
import org.apache.cassandra.spark.utils.ReaderTimeProvider;
import org.apache.cassandra.spark.utils.ScalaFunctions;
import org.apache.cassandra.spark.utils.ThrowableUtils;
import org.apache.cassandra.spark.utils.TimeProvider;
import org.apache.cassandra.spark.validation.CassandraValidation;
import org.apache.cassandra.spark.validation.SidecarValidation;
import org.apache.cassandra.spark.validation.StartupValidatable;
import org.apache.cassandra.spark.validation.StartupValidation;
import org.apache.cassandra.spark.validation.StartupValidator;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.util.ShutdownHookManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDataLayer
extends PartitionedDataLayer
implements StartupValidatable,
Serializable {
    private static final long serialVersionUID = -9038926850642710787L;
    public static final Logger LOGGER = LoggerFactory.getLogger(CassandraDataLayer.class);
    private static final Cache<String, CompletableFuture<List<SSTable>>> SNAPSHOT_CACHE = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).maximumSize(128L).build();
    protected String snapshotName;
    protected boolean quoteIdentifiers;
    protected String keyspace;
    protected String table;
    protected String maybeQuotedKeyspace;
    protected String maybeQuotedTable;
    protected CassandraBridge bridge;
    protected String sidecarInstances;
    protected int sidecarPort;
    protected transient Set<SidecarInstance> clusterConfig;
    protected TokenPartitioner tokenPartitioner;
    protected Map<String, PartitionedDataLayer.AvailabilityHint> availabilityHints;
    protected Sidecar.ClientConfig sidecarClientConfig;
    protected Map<String, BigNumberConfigImpl> bigNumberConfigMap;
    protected boolean enableStats;
    protected boolean readIndexOffset;
    protected boolean useIncrementalRepair;
    protected List<SchemaFeature> requestedFeatures;
    protected Map<String, ReplicationFactor> rfMap;
    @Nullable
    protected String lastModifiedTimestampField;
    protected volatile CqlTable cqlTable;
    protected transient TimeProvider timeProvider;
    protected transient SidecarClient sidecar;
    private SslConfig sslConfig;
    private SSTableTimeRangeFilter sstableTimeRangeFilter;
    @VisibleForTesting
    transient Map<String, SidecarInstance> sidecarInstanceMap;

    public CassandraDataLayer(@NotNull ClientConfig options, @NotNull Sidecar.ClientConfig sidecarClientConfig, @Nullable SslConfig sslConfig) {
        super(options.consistencyLevel(), options.datacenter());
        this.snapshotName = options.snapshotName();
        this.keyspace = options.keyspace();
        this.table = options.table();
        this.quoteIdentifiers = options.quoteIdentifiers();
        this.sidecarClientConfig = sidecarClientConfig;
        this.sidecarInstances = options.sidecarContactPoints;
        this.sidecarPort = options.sidecarPort;
        this.sslConfig = sslConfig;
        this.bigNumberConfigMap = options.bigNumberConfigMap();
        this.enableStats = options.enableStats();
        this.readIndexOffset = options.readIndexOffset();
        this.useIncrementalRepair = options.useIncrementalRepair();
        this.lastModifiedTimestampField = options.lastModifiedTimestampField();
        this.requestedFeatures = options.requestedFeatures();
        this.sstableTimeRangeFilter = options.sstableTimeRangeFilter;
    }

    @VisibleForTesting
    protected CassandraDataLayer(@Nullable String keyspace, @Nullable String table, boolean quoteIdentifiers, @NotNull String snapshotName, @Nullable String datacenter, @NotNull Sidecar.ClientConfig sidecarClientConfig, @Nullable SslConfig sslConfig, @NotNull CqlTable cqlTable, @NotNull TokenPartitioner tokenPartitioner, @NotNull CassandraVersion version, @NotNull ConsistencyLevel consistencyLevel, @NotNull String sidecarInstances, @NotNull int sidecarPort, @NotNull Map<String, PartitionedDataLayer.AvailabilityHint> availabilityHints, @NotNull Map<String, BigNumberConfigImpl> bigNumberConfigMap, boolean enableStats, boolean readIndexOffset, boolean useIncrementalRepair, @Nullable String lastModifiedTimestampField, List<SchemaFeature> requestedFeatures, @NotNull Map<String, ReplicationFactor> rfMap, TimeProvider timeProvider, SSTableTimeRangeFilter sstableTimeRangeFilter) {
        super(consistencyLevel, datacenter);
        this.snapshotName = snapshotName;
        this.bridge = CassandraBridgeFactory.get(version);
        this.keyspace = keyspace;
        this.table = table;
        this.quoteIdentifiers = quoteIdentifiers;
        this.cqlTable = cqlTable;
        this.tokenPartitioner = tokenPartitioner;
        this.clusterConfig = this.initializeClusterConfig(sidecarInstances, sidecarPort);
        this.availabilityHints = availabilityHints;
        this.sidecarClientConfig = sidecarClientConfig;
        this.sslConfig = sslConfig;
        this.bigNumberConfigMap = bigNumberConfigMap;
        this.enableStats = enableStats;
        this.readIndexOffset = readIndexOffset;
        this.useIncrementalRepair = useIncrementalRepair;
        this.lastModifiedTimestampField = lastModifiedTimestampField;
        this.requestedFeatures = requestedFeatures;
        if (lastModifiedTimestampField != null) {
            CassandraDataLayer.aliasLastModifiedTimestamp(this.requestedFeatures, this.lastModifiedTimestampField);
        }
        this.rfMap = rfMap;
        this.timeProvider = timeProvider;
        this.sstableTimeRangeFilter = sstableTimeRangeFilter;
        this.maybeQuoteKeyspaceAndTable();
        this.initSidecarClient();
        this.initInstanceMap();
        this.startupValidate();
    }

    public void initialize(@NotNull ClientConfig options) {
        int effectiveNumberOfCores;
        this.dialHome(options);
        this.timeProvider = new ReaderTimeProvider();
        LOGGER.info("Starting Cassandra Spark job snapshotName={} keyspace={} table={} dc={} referenceEpoch={}", new Object[]{this.snapshotName, this.keyspace, this.table, this.datacenter, this.timeProvider.referenceEpochInSeconds()});
        this.clusterConfig = this.initializeClusterConfig(options);
        this.initSidecarClient();
        try {
            effectiveNumberOfCores = this.initBulkReader(options);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(exception);
        }
        catch (ExecutionException exception) {
            throw new RuntimeException(ThrowableUtils.rootCause((Throwable)exception));
        }
        this.initInstanceMap();
        LOGGER.info("Initialized Cassandra Bulk Reader with effectiveNumberOfCores={}", (Object)effectiveNumberOfCores);
    }

    private int initBulkReader(@NotNull ClientConfig options) throws ExecutionException, InterruptedException {
        CompletionStage snapshotFuture;
        Preconditions.checkArgument((this.keyspace != null ? 1 : 0) != 0, (Object)"Keyspace must be non-null for Cassandra Bulk Reader");
        Preconditions.checkArgument((this.table != null ? 1 : 0) != 0, (Object)"Table must be non-null for Cassandra Bulk Reader");
        ShutdownHookManager.addShutdownHook((int)ShutdownHookManager.TEMP_DIR_SHUTDOWN_PRIORITY(), ScalaFunctions.wrapLambda(() -> this.shutdownHook(options)));
        NodeSettings nodeSettings = (NodeSettings)this.sidecar.nodeSettings().get();
        String cassandraVersion = this.getEffectiveCassandraVersionForRead(this.clusterConfig, nodeSettings);
        Partitioner partitioner = Partitioner.from((String)nodeSettings.partitioner());
        this.bridge = CassandraBridgeFactory.get(cassandraVersion);
        this.maybeQuoteKeyspaceAndTable();
        CompletableFuture ringFuture = this.sidecar.ring(this.maybeQuotedKeyspace);
        CompletableFuture schemaFuture = this.sidecar.schema(this.maybeQuotedKeyspace);
        if (options.createSnapshot()) {
            LOGGER.info("Creating snapshot snapshotName={} keyspace={} table={} dc={}", new Object[]{this.snapshotName, this.maybeQuotedKeyspace, this.maybeQuotedTable, this.datacenter});
            snapshotFuture = ringFuture.thenCompose(ringResponse -> this.createSnapshot(options, (RingResponse)ringResponse));
        } else {
            snapshotFuture = CompletableFuture.completedFuture(new HashMap());
        }
        this.availabilityHints = snapshotFuture.get();
        String fullSchema = ((SchemaResponse)schemaFuture.get()).schema();
        String createStmt = CqlUtils.extractTableSchema((String)fullSchema, (String)this.keyspace, (String)this.table);
        int indexCount = CqlUtils.extractIndexCount((String)fullSchema, (String)this.keyspace, (String)this.table);
        Set udts = CqlUtils.extractUdts((String)fullSchema, (String)this.keyspace);
        ReplicationFactor replicationFactor = CqlUtils.extractReplicationFactor((String)fullSchema, (String)this.keyspace);
        String tableSchemaWithProps = CqlUtils.extractCleanedTableSchema((String)fullSchema, (String)this.keyspace, (String)this.table, (boolean)true);
        String compactionStrategy = CqlUtils.extractCompactionStrategy((String)tableSchemaWithProps);
        if (this.sstableTimeRangeFilter != null && this.sstableTimeRangeFilter != SSTableTimeRangeFilter.ALL && !CqlUtils.isTimeRangeFilterSupported((String)compactionStrategy)) {
            throw new UnsupportedOperationException("SSTableTimeRangeFilter is only supported with TimeWindowCompactionStrategy. Current compaction strategy is: " + compactionStrategy);
        }
        this.rfMap = Map.of(this.keyspace, replicationFactor);
        CompletableFuture<Integer> sizingFuture = CompletableFuture.supplyAsync(() -> this.getSizing(ringFuture, replicationFactor, options).getEffectiveNumberOfCores(), ExecutorHolder.EXECUTOR_SERVICE);
        this.validateReplicationFactor(replicationFactor);
        udts.forEach(udt -> LOGGER.info("Adding schema UDT: '{}'", udt));
        this.cqlTable = this.bridge().buildSchema(createStmt, this.keyspace, replicationFactor, partitioner, udts, null, indexCount, false);
        CassandraRing ring = this.createCassandraRingFromRing(partitioner, replicationFactor, (RingResponse)ringFuture.get());
        int effectiveNumberOfCores = sizingFuture.get();
        this.tokenPartitioner = new TokenPartitioner(ring, options.defaultParallelism(), effectiveNumberOfCores);
        return effectiveNumberOfCores;
    }

    protected void shutdownHook(ClientConfig options) {
        ClientConfig.ClearSnapshotStrategy clearSnapshotStrategy = options.clearSnapshotStrategy();
        if (clearSnapshotStrategy.shouldClearOnCompletion()) {
            if (options.createSnapshot()) {
                this.clearSnapshot(this.clusterConfig, options);
            } else {
                LOGGER.warn("Skipping clearing snapshot because it was not created by this job. Only the job that created the snapshot can clear it. snapshotName={} keyspace={} table={} dc={}", new Object[]{this.snapshotName, this.keyspace, this.table, this.datacenter});
            }
        } else if (clearSnapshotStrategy.hasTTL()) {
            LOGGER.warn("Skipping clearing snapshot because clearSnapshotStrategy '{}' is used", (Object)clearSnapshotStrategy);
        }
        try {
            this.sidecar.close();
        }
        catch (Exception exception) {
            LOGGER.warn("Unable to close Sidecar", (Throwable)exception);
        }
    }

    private CompletionStage<Map<String, PartitionedDataLayer.AvailabilityHint>> createSnapshot(ClientConfig options, RingResponse ring) {
        ConcurrentHashMap availabilityHints = new ConcurrentHashMap(ring.size());
        HashSet distinctInstances = new HashSet();
        List<CompletableFuture> futures = ring.stream().filter(ringEntry -> this.datacenter == null || this.datacenter.equals(ringEntry.datacenter())).filter(ringEntry -> distinctInstances.add(ringEntry.fqdn() + ":" + ringEntry.port())).map(ringEntry -> {
            CompletionStage<PartitionedDataLayer.AvailabilityHint> createSnapshotFuture;
            PartitionedDataLayer.AvailabilityHint hint = PartitionedDataLayer.AvailabilityHint.fromState(ringEntry.status(), ringEntry.state());
            if (Properties.NODE_STATUS_NOT_CONSIDERED.contains(ringEntry.state())) {
                LOGGER.warn("Skip snapshot creating when node is joining or down snapshotName={} keyspace={} table={} datacenter={} fqdn={} status={} state={}", new Object[]{this.snapshotName, this.maybeQuotedKeyspace, this.maybeQuotedTable, this.datacenter, ringEntry.fqdn(), ringEntry.status(), ringEntry.state()});
                createSnapshotFuture = CompletableFuture.completedFuture(hint);
            } else {
                LOGGER.info("Creating snapshot on instance snapshotName={} keyspace={} table={} datacenter={} fqdn={}", new Object[]{this.snapshotName, this.maybeQuotedKeyspace, this.maybeQuotedTable, this.datacenter, ringEntry.fqdn()});
                SidecarInstanceImpl sidecarInstance = new SidecarInstanceImpl(ringEntry.fqdn(), this.sidecarClientConfig.effectivePort());
                ClientConfig.ClearSnapshotStrategy clearSnapshotStrategy = options.clearSnapshotStrategy();
                createSnapshotFuture = this.sidecar.createSnapshot((SidecarInstance)sidecarInstance, this.maybeQuotedKeyspace, this.maybeQuotedTable, this.snapshotName, clearSnapshotStrategy.ttl()).handle((resp, throwable) -> {
                    if (throwable == null) {
                        return hint;
                    }
                    if (this.isExhausted((Throwable)throwable)) {
                        LOGGER.warn("Failed to create snapshot on instance", throwable);
                        return PartitionedDataLayer.AvailabilityHint.DOWN;
                    }
                    LOGGER.error("Unexpected error creating snapshot on instance", throwable);
                    return PartitionedDataLayer.AvailabilityHint.UNKNOWN;
                });
            }
            return createSnapshotFuture.thenAccept(h -> availabilityHints.put(ringEntry.fqdn(), h));
        }).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).handle((results, throwable) -> availabilityHints);
    }

    protected boolean isExhausted(@Nullable Throwable throwable) {
        return throwable != null && (throwable instanceof RetriesExhaustedException || this.isExhausted(throwable.getCause()));
    }

    @Override
    public TimeProvider timeProvider() {
        return this.timeProvider;
    }

    @Override
    public boolean useIncrementalRepair() {
        return this.useIncrementalRepair;
    }

    @Override
    public boolean readIndexOffset() {
        return this.readIndexOffset;
    }

    protected void initInstanceMap() {
        Preconditions.checkState((this.tokenPartitioner != null ? 1 : 0) != 0, (Object)"tokenPartitioner cannot be absent");
        this.sidecarInstanceMap = this.tokenPartitioner.ring().instances().stream().filter(instance -> this.datacenter == null || this.datacenter.equals(instance.dataCenter())).map(CassandraInstance::nodeName).distinct().map(nodeName -> new SidecarInstanceImpl(nodeName, this.sidecarClientConfig.effectivePort())).collect(Collectors.toMap(SidecarInstance::hostname, Function.identity()));
        LOGGER.info("Initialized CassandraDataLayer sidecarInstanceMap numInstances={}", (Object)this.sidecarInstanceMap.size());
    }

    protected void initSidecarClient() {
        try {
            SslConfigSecretsProvider secretsProvider = this.sslConfig != null ? new SslConfigSecretsProvider(this.sslConfig) : null;
            this.sidecar = Sidecar.from((SidecarInstancesProvider)new SimpleSidecarInstancesProvider(new ArrayList<SidecarInstance>(this.clusterConfig)), (Sidecar.ClientConfig)this.sidecarClientConfig, (SecretsProvider)secretsProvider);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to build sidecar client", ioException);
        }
        LOGGER.info("Initialized sidecar client");
    }

    @Override
    public CassandraBridge bridge() {
        return this.bridge;
    }

    @Override
    public Stats stats() {
        return Stats.DoNothingStats.INSTANCE;
    }

    @Override
    public List<SchemaFeature> requestedFeatures() {
        return this.requestedFeatures;
    }

    @Override
    public CassandraRing ring() {
        return this.tokenPartitioner.ring();
    }

    @Override
    public TokenPartitioner tokenPartitioner() {
        return this.tokenPartitioner;
    }

    @Override
    protected ExecutorService executorService() {
        return ExecutorHolder.EXECUTOR_SERVICE;
    }

    @Override
    public String jobId() {
        return null;
    }

    @Override
    @NotNull
    public SSTableTimeRangeFilter sstableTimeRangeFilter() {
        return this.sstableTimeRangeFilter;
    }

    @Override
    public CqlTable cqlTable() {
        if (this.cqlTable == null) {
            throw new RuntimeException("Schema not initialized");
        }
        return this.cqlTable;
    }

    @Override
    public ReplicationFactor replicationFactor(String keyspace) {
        return this.rfMap.get(keyspace);
    }

    @Override
    protected PartitionedDataLayer.AvailabilityHint getAvailability(CassandraInstance instance) {
        PartitionedDataLayer.AvailabilityHint hint = this.availabilityHints.get(instance.nodeName());
        return hint != null ? hint : PartitionedDataLayer.AvailabilityHint.UNKNOWN;
    }

    private String snapshotKey(SidecarInstance instance) {
        return String.format("%s/%s/%d/%s/%s/%s", this.datacenter, instance.hostname(), instance.port(), this.keyspace, this.table, this.snapshotName);
    }

    @Override
    public CompletableFuture<Stream<SSTable>> listInstance(int partitionId, @NotNull Range<BigInteger> range, @NotNull CassandraInstance instance) {
        SidecarInstance sidecarInstance = this.sidecarInstanceMap.get(instance.nodeName());
        if (sidecarInstance == null) {
            throw new IllegalStateException("Could not find matching cassandra instance: " + instance.nodeName());
        }
        String key = this.snapshotKey(sidecarInstance);
        LOGGER.info("Listing snapshot partition={} lowerBound={} upperBound={} instance={} port={} keyspace={} tableName={} snapshotName={}", new Object[]{partitionId, range.lowerEndpoint(), range.upperEndpoint(), sidecarInstance.hostname(), sidecarInstance.port(), this.maybeQuotedKeyspace, this.maybeQuotedTable, this.snapshotName});
        try {
            return ((CompletableFuture)SNAPSHOT_CACHE.get((Object)key, () -> {
                LOGGER.info("Listing instance snapshot partition={} lowerBound={} upperBound={} instance={} port={} keyspace={} tableName={} snapshotName={} cacheKey={}", new Object[]{partitionId, range.lowerEndpoint(), range.upperEndpoint(), sidecarInstance.hostname(), sidecarInstance.port(), this.maybeQuotedKeyspace, this.maybeQuotedTable, this.snapshotName, key});
                return this.sidecar.listSnapshotFiles(sidecarInstance, this.maybeQuotedKeyspace, this.maybeQuotedTable, this.snapshotName, false).thenApply(response -> this.collectSSTableList(sidecarInstance, (ListSnapshotFilesResponse)response, partitionId));
            })).thenApply(Collection::stream);
        }
        catch (ExecutionException exception) {
            CompletableFuture<Stream<SSTable>> future = new CompletableFuture<Stream<SSTable>>();
            future.completeExceptionally(ThrowableUtils.rootCause((Throwable)exception));
            return future;
        }
    }

    private List<SSTable> collectSSTableList(SidecarInstance sidecarInstance, ListSnapshotFilesResponse response, int partitionId) {
        if (response == null) {
            throw new IncompleteSSTableException(new FileType[0]);
        }
        List snapshotFilesInfo = response.snapshotFilesInfo();
        if (snapshotFilesInfo == null) {
            throw new IncompleteSSTableException(new FileType[0]);
        }
        LinkedHashMap<String, Map> result = new LinkedHashMap<String, Map>(1024);
        for (ListSnapshotFilesResponse.FileInfo file : snapshotFilesInfo) {
            String fileName = file.fileName;
            int lastIndexOfDash = fileName.lastIndexOf(45);
            if (lastIndexOfDash < 0) continue;
            String ssTableName = fileName.substring(0, lastIndexOfDash);
            try {
                FileType fileType = FileType.fromExtension((String)fileName.substring(lastIndexOfDash + 1));
                result.computeIfAbsent(ssTableName, k -> new LinkedHashMap()).put(fileType, file);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return result.values().stream().map(components -> new SidecarProvisionedSSTable(this.sidecar, this.sidecarClientConfig, sidecarInstance, this.maybeQuotedKeyspace, this.maybeQuotedTable, this.snapshotName, (Map<FileType, ListSnapshotFilesResponse.FileInfo>)components, partitionId, this.stats())).collect(Collectors.toList());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cqlTable, this.snapshotName, this.keyspace, this.table, this.version());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass() || !super.equals(other)) {
            return false;
        }
        CassandraDataLayer that = (CassandraDataLayer)other;
        return this.cqlTable.equals((Object)that.cqlTable) && this.snapshotName.equals(that.snapshotName) && this.keyspace.equals(that.keyspace) && this.table.equals(that.table) && this.version().equals((Object)that.version());
    }

    public Map<String, BigNumberConfigImpl> bigNumberConfigMap() {
        return this.bigNumberConfigMap;
    }

    @Override
    public BigNumberConfig bigNumberConfig(CqlField field) {
        BigNumberConfigImpl config = this.bigNumberConfigMap.get(field.name());
        return config != null ? config : BigNumberConfig.DEFAULT;
    }

    @VisibleForTesting
    public CassandraRing createCassandraRingFromRing(Partitioner partitioner, ReplicationFactor replicationFactor, RingResponse ring) {
        Collection instances = ring.stream().filter(status -> this.datacenter == null || this.datacenter.equalsIgnoreCase(status.datacenter())).map(status -> new CassandraInstance(status.token(), status.fqdn(), status.datacenter())).collect(Collectors.toList());
        return new CassandraRing(partitioner, this.keyspace, replicationFactor, instances);
    }

    @Override
    public void startupValidate() {
        int timeoutSeconds = this.sidecarClientConfig.timeoutSeconds();
        StartupValidator.instance().register((StartupValidation)new SidecarValidation(this.sidecar, timeoutSeconds));
        StartupValidator.instance().register((StartupValidation)new CassandraValidation(this.sidecar, timeoutSeconds));
        StartupValidator.instance().perform();
    }

    private void maybeQuoteKeyspaceAndTable() {
        if (this.quoteIdentifiers) {
            Objects.requireNonNull(this.bridge, "bridge must be initialized to maybe quote keyspace and table");
            this.maybeQuotedKeyspace = this.bridge.maybeQuoteIdentifier(this.keyspace);
            this.maybeQuotedTable = this.bridge.maybeQuoteIdentifier(this.table);
        } else {
            this.maybeQuotedKeyspace = this.keyspace;
            this.maybeQuotedTable = this.table;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LOGGER.debug("Falling back to JDK deserialization");
        this.bridge = CassandraBridgeFactory.get(CassandraVersion.valueOf((String)in.readUTF()));
        this.snapshotName = in.readUTF();
        this.keyspace = CassandraDataLayer.readNullable(in);
        this.table = CassandraDataLayer.readNullable(in);
        this.quoteIdentifiers = in.readBoolean();
        this.sidecarClientConfig = Sidecar.ClientConfig.create((int)in.readInt(), (int)in.readInt(), (long)in.readLong(), (long)in.readLong(), (long)in.readLong(), (long)in.readLong(), (int)in.readInt(), (int)in.readInt(), (String)CassandraDataLayer.readNullable(in), (Map)((Map)in.readObject()), (Map)((Map)in.readObject()));
        this.sslConfig = (SslConfig)in.readObject();
        this.cqlTable = (CqlTable)this.bridge.javaDeserialize(in, CqlTable.class);
        this.tokenPartitioner = (TokenPartitioner)in.readObject();
        this.sidecarInstances = in.readUTF();
        this.sidecarPort = in.readInt();
        this.clusterConfig = this.initializeClusterConfig(this.sidecarInstances, this.sidecarPort);
        this.availabilityHints = (Map)in.readObject();
        this.bigNumberConfigMap = (Map)in.readObject();
        this.enableStats = in.readBoolean();
        this.readIndexOffset = in.readBoolean();
        this.useIncrementalRepair = in.readBoolean();
        this.lastModifiedTimestampField = CassandraDataLayer.readNullable(in);
        int features = in.readShort();
        ArrayList<SchemaFeature> requestedFeatures = new ArrayList<SchemaFeature>(features);
        for (int feature = 0; feature < features; ++feature) {
            String featureName = in.readUTF();
            requestedFeatures.add((SchemaFeature)SchemaFeatureSet.valueOf((String)featureName.toUpperCase()));
        }
        this.requestedFeatures = requestedFeatures;
        if (this.lastModifiedTimestampField != null) {
            CassandraDataLayer.aliasLastModifiedTimestamp(this.requestedFeatures, this.lastModifiedTimestampField);
        }
        this.rfMap = (Map)in.readObject();
        this.timeProvider = new ReaderTimeProvider(in.readInt());
        this.sstableTimeRangeFilter = (SSTableTimeRangeFilter)in.readObject();
        this.maybeQuoteKeyspaceAndTable();
        this.initSidecarClient();
        this.initInstanceMap();
        this.startupValidate();
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        LOGGER.debug("Falling back to JDK serialization");
        out.writeUTF(this.version().name());
        out.writeUTF(this.snapshotName);
        CassandraDataLayer.writeNullable(out, this.keyspace);
        CassandraDataLayer.writeNullable(out, this.table);
        out.writeBoolean(this.quoteIdentifiers);
        out.writeInt(this.sidecarClientConfig.userProvidedPort());
        out.writeInt(this.sidecarClientConfig.maxRetries());
        out.writeLong(this.sidecarClientConfig.millisToSleep());
        out.writeLong(this.sidecarClientConfig.maxMillisToSleep());
        out.writeLong(this.sidecarClientConfig.maxBufferSize());
        out.writeLong(this.sidecarClientConfig.chunkBufferSize());
        out.writeInt(this.sidecarClientConfig.maxPoolSize());
        out.writeInt(this.sidecarClientConfig.timeoutSeconds());
        CassandraDataLayer.writeNullable(out, this.sidecarClientConfig.cassandraRole());
        out.writeObject(this.sidecarClientConfig.maxBufferOverride());
        out.writeObject(this.sidecarClientConfig.chunkBufferOverride());
        out.writeObject(this.sslConfig);
        this.bridge.javaSerialize(out, (Serializable)this.cqlTable);
        out.writeObject(this.tokenPartitioner);
        out.writeUTF(this.sidecarInstances);
        out.writeInt(this.sidecarPort);
        out.writeObject(this.availabilityHints);
        out.writeObject(this.bigNumberConfigMap);
        out.writeBoolean(this.enableStats);
        out.writeBoolean(this.readIndexOffset);
        out.writeBoolean(this.useIncrementalRepair);
        CassandraDataLayer.writeNullable(out, this.lastModifiedTimestampField);
        out.writeShort(this.requestedFeatures.size());
        for (SchemaFeature feature : this.requestedFeatures) {
            out.writeUTF(feature.optionName());
        }
        out.writeObject(this.rfMap);
        out.writeInt(this.timeProvider.referenceEpochInSeconds());
        out.writeObject(this.sstableTimeRangeFilter);
    }

    private static void writeNullable(ObjectOutputStream out, @Nullable String string) throws IOException {
        if (string == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(string);
        }
    }

    @Nullable
    private static String readNullable(ObjectInputStream in) throws IOException {
        if (in.readBoolean()) {
            return in.readUTF();
        }
        return null;
    }

    protected Set<SidecarInstance> initializeClusterConfig(ClientConfig options) {
        return this.initializeClusterConfig(options.sidecarContactPoints, options.sidecarPort());
    }

    private Set<SidecarInstance> initializeClusterConfig(String sidecarInstances, int sidecarPort) {
        return Arrays.stream(sidecarInstances.split(",")).filter(StringUtils::isNotEmpty).map(hostname -> SidecarInstanceFactory.createFromString(hostname, sidecarPort)).collect(Collectors.toSet());
    }

    protected String getEffectiveCassandraVersionForRead(Set<SidecarInstance> clusterConfig, NodeSettings nodeSettings) {
        return nodeSettings.releaseVersion();
    }

    protected void dialHome(@NotNull ClientConfig options) {
        LOGGER.info("Dial home. clientConfig={}", (Object)options);
    }

    protected void clearSnapshot(Set<SidecarInstance> clusterConfig, @NotNull ClientConfig options) {
        if (this.maybeQuotedKeyspace == null || this.maybeQuotedTable == null) {
            LOGGER.warn("Bridge was never initialized. Skipping clearing snapshots. This implies snapshots were never created");
            return;
        }
        LOGGER.info("Clearing snapshot at end of Spark job snapshotName={} keyspace={} table={} dc={}", new Object[]{this.snapshotName, this.maybeQuotedKeyspace, this.maybeQuotedTable, this.datacenter});
        CountDownLatch latch = new CountDownLatch(this.sidecarInstanceMap.size());
        try {
            for (SidecarInstance instance : this.sidecarInstanceMap.values()) {
                this.sidecar.clearSnapshot(instance, this.maybeQuotedKeyspace, this.maybeQuotedTable, this.snapshotName).whenComplete((resp, throwable) -> {
                    try {
                        if (throwable != null) {
                            LOGGER.warn("Failed to clear snapshot on instance hostname={} port={} snapshotName={} keyspace={} table={} datacenter={}", new Object[]{instance.hostname(), instance.port(), this.snapshotName, this.maybeQuotedKeyspace, this.maybeQuotedTable, this.datacenter, throwable});
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            this.await(latch);
            LOGGER.info("Snapshot cleared snapshotName={} keyspace={} table={} datacenter={}", new Object[]{this.snapshotName, this.maybeQuotedKeyspace, this.maybeQuotedTable, this.datacenter});
        }
        catch (Throwable throwable2) {
            LOGGER.warn("Unexpected exception clearing snapshot snapshotName={} keyspace={} table={} dc={}", new Object[]{this.snapshotName, this.maybeQuotedKeyspace, this.maybeQuotedTable, this.datacenter, throwable2});
        }
    }

    protected Sizing getSizing(CompletableFuture<RingResponse> ringFuture, ReplicationFactor replicationFactor, ClientConfig options) {
        return SizingFactory.create(replicationFactor, options, this.consistencyLevel, this.keyspace, this.table, this.datacenter, this.sidecar, this.sidecarPort, ringFuture);
    }

    protected void await(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(exception);
        }
    }

    static void aliasLastModifiedTimestamp(List<SchemaFeature> requestedFeatures, final String alias) {
        SchemaFeature featureAlias = new SchemaFeature(){

            public String optionName() {
                return SchemaFeatureSet.LAST_MODIFIED_TIMESTAMP.optionName();
            }

            public String fieldName() {
                return alias;
            }

            public DataType fieldDataType() {
                return SchemaFeatureSet.LAST_MODIFIED_TIMESTAMP.fieldDataType();
            }

            public <T extends InternalRow> RowBuilder<T> decorate(RowBuilder<T> builder) {
                return new LastModifiedTimestampDecorator(builder, alias);
            }

            public boolean fieldNullable() {
                return SchemaFeatureSet.LAST_MODIFIED_TIMESTAMP.fieldNullable();
            }
        };
        int index = requestedFeatures.indexOf(SchemaFeatureSet.LAST_MODIFIED_TIMESTAMP);
        if (index >= 0) {
            requestedFeatures.set(index, featureAlias);
        }
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<CassandraDataLayer> {
        public void write(Kryo kryo, Output out, CassandraDataLayer dataLayer) {
            LOGGER.info("Serializing CassandraDataLayer with Kryo");
            out.writeString(dataLayer.keyspace);
            out.writeString(dataLayer.table);
            out.writeBoolean(dataLayer.quoteIdentifiers);
            out.writeString(dataLayer.snapshotName);
            out.writeString(dataLayer.datacenter);
            out.writeInt(dataLayer.sidecarClientConfig.userProvidedPort());
            out.writeInt(dataLayer.sidecarClientConfig.maxRetries());
            out.writeLong(dataLayer.sidecarClientConfig.millisToSleep());
            out.writeLong(dataLayer.sidecarClientConfig.maxMillisToSleep());
            out.writeLong(dataLayer.sidecarClientConfig.maxBufferSize());
            out.writeLong(dataLayer.sidecarClientConfig.chunkBufferSize());
            out.writeInt(dataLayer.sidecarClientConfig.maxPoolSize());
            out.writeInt(dataLayer.sidecarClientConfig.timeoutSeconds());
            out.writeString(dataLayer.sidecarClientConfig.cassandraRole());
            kryo.writeObject(out, (Object)dataLayer.sidecarClientConfig.maxBufferOverride());
            kryo.writeObject(out, (Object)dataLayer.sidecarClientConfig.chunkBufferOverride());
            kryo.writeObjectOrNull(out, (Object)dataLayer.sslConfig, SslConfig.class);
            kryo.writeObject(out, (Object)dataLayer.cqlTable);
            kryo.writeObject(out, (Object)dataLayer.tokenPartitioner);
            kryo.writeObject(out, (Object)dataLayer.version());
            kryo.writeObject(out, (Object)dataLayer.consistencyLevel);
            out.writeString(dataLayer.sidecarInstances);
            out.writeInt(dataLayer.sidecarPort);
            kryo.writeObject(out, dataLayer.availabilityHints);
            out.writeBoolean(dataLayer.bigNumberConfigMap.isEmpty());
            if (!dataLayer.bigNumberConfigMap.isEmpty()) {
                kryo.writeObject(out, dataLayer.bigNumberConfigMap);
            }
            out.writeBoolean(dataLayer.enableStats);
            out.writeBoolean(dataLayer.readIndexOffset);
            out.writeBoolean(dataLayer.useIncrementalRepair);
            out.writeString(dataLayer.lastModifiedTimestampField);
            SchemaFeaturesListWrapper listWrapper = new SchemaFeaturesListWrapper();
            listWrapper.requestedFeatureNames = dataLayer.requestedFeatures.stream().map(SchemaFeature::optionName).collect(Collectors.toList());
            kryo.writeObject(out, (Object)listWrapper);
            kryo.writeObject(out, dataLayer.rfMap);
            out.writeInt(dataLayer.timeProvider.referenceEpochInSeconds());
            kryo.writeObject(out, (Object)dataLayer.sstableTimeRangeFilter);
        }

        public CassandraDataLayer read(Kryo kryo, Input in, Class<CassandraDataLayer> type) {
            LOGGER.info("Deserializing CassandraDataLayer with Kryo");
            return new CassandraDataLayer(in.readString(), in.readString(), in.readBoolean(), in.readString(), in.readString(), Sidecar.ClientConfig.create((int)in.readInt(), (int)in.readInt(), (long)in.readLong(), (long)in.readLong(), (long)in.readLong(), (long)in.readLong(), (int)in.readInt(), (int)in.readInt(), (String)in.readString(), (Map)((Map)kryo.readObject(in, HashMap.class)), (Map)((Map)kryo.readObject(in, HashMap.class))), (SslConfig)kryo.readObjectOrNull(in, SslConfig.class), (CqlTable)kryo.readObject(in, CqlTable.class), (TokenPartitioner)kryo.readObject(in, TokenPartitioner.class), (CassandraVersion)kryo.readObject(in, CassandraVersion.class), (ConsistencyLevel)kryo.readObject(in, ConsistencyLevel.class), in.readString(), in.readInt(), (Map)kryo.readObject(in, HashMap.class), in.readBoolean() ? Collections.emptyMap() : (Map)kryo.readObject(in, HashMap.class), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readString(), ((SchemaFeaturesListWrapper)kryo.readObject(in, SchemaFeaturesListWrapper.class)).toList(), (Map)kryo.readObject(in, HashMap.class), (TimeProvider)new ReaderTimeProvider(in.readInt()), (SSTableTimeRangeFilter)kryo.readObject(in, SSTableTimeRangeFilter.class));
        }

        private static class SchemaFeaturesListWrapper {
            public List<String> requestedFeatureNames;

            private SchemaFeaturesListWrapper() {
            }

            public List<SchemaFeature> toList() {
                return this.requestedFeatureNames.stream().map(name -> SchemaFeatureSet.valueOf((String)name.toUpperCase())).collect(Collectors.toList());
            }
        }
    }
}

