/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.values;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.internal.threads.VanillaThreadLock;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.ThreadLock;

public interface LongValue
extends Closeable {
    public long getValue() throws IllegalStateException;

    public void setValue(long var1) throws IllegalStateException;

    default public long getVolatileValue() throws IllegalStateException {
        return this.getValue();
    }

    default public void setVolatileValue(long value) throws IllegalStateException {
        this.setValue(value);
    }

    default public long getVolatileValue(long closedValue) throws IllegalStateException {
        if (this.isClosed()) {
            return closedValue;
        }
        try {
            return this.getVolatileValue();
        }
        catch (Exception e) {
            return closedValue;
        }
    }

    default public void setOrderedValue(long value) throws IllegalStateException {
        this.setVolatileValue(value);
    }

    public long addValue(long var1) throws IllegalStateException;

    default public long addAtomicValue(long delta) throws IllegalStateException {
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(long var1, long var3) throws IllegalStateException;

    default public void setMaxValue(long value) throws IllegalStateException {
        long pos;
        while ((pos = this.getVolatileValue()) < value && !this.compareAndSwapValue(pos, value)) {
            Jvm.nanoPause();
        }
    }

    default public void setMinValue(long value) throws IllegalStateException {
        long pos;
        while ((pos = this.getVolatileValue()) > value && !this.compareAndSwapValue(pos, value)) {
            Jvm.nanoPause();
        }
    }

    @Override
    default public boolean isClosed() {
        return false;
    }

    @Override
    default public void close() {
    }

    default public ThreadLock vanillaThreadLock() {
        return new VanillaThreadLock(this, TimeUnit.MINUTES.toMillis(5L));
    }
}

