/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.diag;

import java.io.InvalidClassException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.cassandra.diag.DiagnosticEvent;
import org.apache.cassandra.diag.DiagnosticEventService;
import org.apache.cassandra.diag.LastEventIdBroadcaster;
import org.apache.cassandra.diag.store.DiagnosticEventMemoryStore;
import org.apache.cassandra.diag.store.DiagnosticEventStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiagnosticEventPersistence {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticEventPersistence.class);
    private static final DiagnosticEventPersistence instance = new DiagnosticEventPersistence();
    private final Map<Class, DiagnosticEventStore<Long>> stores = new ConcurrentHashMap<Class, DiagnosticEventStore<Long>>();
    private final Consumer<DiagnosticEvent> eventConsumer = this::onEvent;

    public static void start() {
        LastEventIdBroadcaster.instance();
    }

    public static DiagnosticEventPersistence instance() {
        return instance;
    }

    public SortedMap<Long, Map<String, Serializable>> getEvents(String eventClazz, Long key, int limit, boolean includeKey) {
        Class<DiagnosticEvent> cls;
        assert (eventClazz != null);
        assert (key != null);
        assert (limit >= 0);
        try {
            cls = this.getEventClass(eventClazz);
        }
        catch (InvalidClassException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        DiagnosticEventStore<Long> store = this.getStore(cls);
        NavigableMap<Long, DiagnosticEvent> events = store.scan(key, includeKey ? limit : limit + 1);
        if (!includeKey && !events.isEmpty()) {
            events = events.tailMap(key, false);
        }
        TreeMap<Long, Map<String, Serializable>> ret = new TreeMap<Long, Map<String, Serializable>>();
        for (Map.Entry entry : events.entrySet()) {
            DiagnosticEvent event = (DiagnosticEvent)entry.getValue();
            HashMap<String, Serializable> val = new HashMap<String, Serializable>(event.toMap());
            val.put("class", (Serializable)((Object)event.getClass().getName()));
            val.put("type", (Serializable)((Object)event.getType().name()));
            val.put("ts", Long.valueOf(event.timestamp));
            val.put("thread", (Serializable)((Object)event.threadName));
            ret.put((Long)entry.getKey(), val);
        }
        logger.debug("Returning {} {} events for key {} (limit {}) (includeKey {})", new Object[]{ret.size(), eventClazz, key, limit, includeKey});
        return ret;
    }

    public void enableEventPersistence(String eventClazz) {
        try {
            logger.debug("Enabling events: {}", (Object)eventClazz);
            DiagnosticEventService.instance().subscribe(this.getEventClass(eventClazz), this.eventConsumer);
        }
        catch (InvalidClassException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void disableEventPersistence(String eventClazz) {
        try {
            logger.debug("Disabling events: {}", (Object)eventClazz);
            DiagnosticEventService.instance().unsubscribe(this.getEventClass(eventClazz), this.eventConsumer);
        }
        catch (InvalidClassException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void onEvent(DiagnosticEvent event) {
        Class<?> cls = event.getClass();
        if (logger.isTraceEnabled()) {
            logger.trace("Persisting received {} event", (Object)cls.getName());
        }
        DiagnosticEventStore<Long> store = this.getStore(cls);
        store.store(event);
        LastEventIdBroadcaster.instance().setLastEventId(event.getClass().getName(), store.getLastEventId());
    }

    private Class<DiagnosticEvent> getEventClass(String eventClazz) throws ClassNotFoundException, InvalidClassException {
        if (!eventClazz.startsWith("org.apache.cassandra.")) {
            throw new RuntimeException("Not a Cassandra event class: " + eventClazz);
        }
        Class<DiagnosticEvent> clazz = Class.forName(eventClazz);
        if (!DiagnosticEvent.class.isAssignableFrom(clazz)) {
            throw new InvalidClassException("Event class must be of type DiagnosticEvent");
        }
        return clazz;
    }

    private DiagnosticEventStore<Long> getStore(Class cls) {
        return this.stores.computeIfAbsent(cls, storeKey -> new DiagnosticEventMemoryStore());
    }
}

