/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataOutputBufferFixed;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.AcceptVersions;
import org.apache.cassandra.net.ConnectionType;
import org.apache.cassandra.net.Crc;
import org.apache.cassandra.net.GlobalBufferPoolAllocator;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.OutboundConnectionSettings;
import org.apache.cassandra.utils.memory.BufferPools;

class HandshakeProtocol {
    static final long TIMEOUT_MILLIS = 3L * DatabaseDescriptor.getRpcTimeout(TimeUnit.MILLISECONDS);

    HandshakeProtocol() {
    }

    private static int getBits(int packed, int start, int count) {
        return packed >>> start & ~(-1 << count);
    }

    static class Accept {
        private static final int MAX_LENGTH = 12;
        final int useMessagingVersion;
        final int maxMessagingVersion;

        Accept(int useMessagingVersion, int maxMessagingVersion) {
            this.useMessagingVersion = useMessagingVersion;
            this.maxMessagingVersion = maxMessagingVersion;
        }

        ByteBuf encode(ByteBufAllocator allocator) {
            ByteBuf buffer = allocator.directBuffer(12);
            buffer.clear();
            buffer.writeInt(this.maxMessagingVersion);
            buffer.writeInt(this.useMessagingVersion);
            buffer.writeInt(Crc.computeCrc32(buffer, 0, 8));
            return buffer;
        }

        static Accept maybeDecode(ByteBuf in) throws Crc.InvalidCrc {
            int readerIndex = in.readerIndex();
            if (in.readableBytes() < 4) {
                return null;
            }
            int maxMessagingVersion = in.readInt();
            int useMessagingVersion = 0;
            if (maxMessagingVersion < 12) {
                return null;
            }
            if (in.readableBytes() < 8) {
                in.readerIndex(readerIndex);
                return null;
            }
            useMessagingVersion = in.readInt();
            int computed = Crc.computeCrc32(in, readerIndex, readerIndex + 8);
            int read = in.readInt();
            if (read != computed) {
                throw new Crc.InvalidCrc(read, computed);
            }
            return new Accept(useMessagingVersion, maxMessagingVersion);
        }

        public boolean equals(Object other) {
            return other instanceof Accept && this.useMessagingVersion == ((Accept)other).useMessagingVersion && this.maxMessagingVersion == ((Accept)other).maxMessagingVersion;
        }

        public String toString() {
            return String.format("Accept(use: %d, max: %d)", this.useMessagingVersion, this.maxMessagingVersion);
        }
    }

    static class Initiate {
        private static final int MIN_LENGTH = 8;
        private static final int MAX_LENGTH = 31;
        final AcceptVersions acceptVersions;
        final ConnectionType type;
        final OutboundConnectionSettings.Framing framing;
        final InetAddressAndPort from;

        Initiate(AcceptVersions acceptVersions, ConnectionType type, OutboundConnectionSettings.Framing framing, InetAddressAndPort from) {
            this.acceptVersions = acceptVersions;
            this.type = type;
            this.framing = framing;
            this.from = from;
        }

        private int encodeFlags() {
            int flags = 0;
            if (this.type.isMessaging()) {
                flags |= this.type.twoBitID();
            }
            if (this.type.isStreaming()) {
                flags |= 8;
            }
            flags |= (this.framing.id & 1) << 2 | (this.framing.id & 2) << 3;
            flags |= this.acceptVersions.min << 8;
            flags |= this.acceptVersions.min << 16;
            return flags |= this.acceptVersions.max << 24;
        }

        ByteBuf encode() {
            ByteBuf byteBuf;
            ByteBuffer buffer = BufferPools.forNetworking().get(31, BufferType.OFF_HEAP);
            DataOutputBufferFixed out = new DataOutputBufferFixed(buffer);
            try {
                out.writeInt(-900387334);
                out.writeInt(this.encodeFlags());
                InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(this.from, (DataOutputPlus)out, this.acceptVersions.min);
                out.writeInt(Crc.computeCrc32(buffer, 0, buffer.position()));
                buffer.flip();
                byteBuf = GlobalBufferPoolAllocator.wrap(buffer);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            out.close();
            return byteBuf;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static Initiate maybeDecode(ByteBuf buf) throws IOException {
            if (buf.readableBytes() < 8) {
                return null;
            }
            ByteBuffer nio = buf.nioBuffer();
            int start = nio.position();
            try (DataInputBuffer in = new DataInputBuffer(nio, false);){
                Message.validateLegacyProtocolMagic(in.readInt());
                int flags = in.readInt();
                if (HandshakeProtocol.getBits(flags, 8, 8) < 12) {
                    Initiate initiate = null;
                    return initiate;
                }
                int minMessagingVersion = HandshakeProtocol.getBits(flags, 16, 8);
                int maxMessagingVersion = HandshakeProtocol.getBits(flags, 24, 8);
                if (maxMessagingVersion < 12) {
                    Initiate initiate = null;
                    return initiate;
                }
                int framingBits = HandshakeProtocol.getBits(flags, 2, 1) | HandshakeProtocol.getBits(flags, 4, 1) << 1;
                OutboundConnectionSettings.Framing framing = OutboundConnectionSettings.Framing.forId(framingBits);
                boolean isStream = HandshakeProtocol.getBits(flags, 3, 1) == 1;
                ConnectionType type = isStream ? ConnectionType.STREAMING : ConnectionType.fromId(HandshakeProtocol.getBits(flags, 0, 2));
                InetAddressAndPort from = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, minMessagingVersion);
                int computed = Crc.computeCrc32(nio, start, nio.position());
                int read = in.readInt();
                if (read != computed) {
                    throw new Crc.InvalidCrc(read, computed);
                }
                buf.skipBytes(nio.position() - start);
                Initiate initiate = new Initiate(new AcceptVersions(minMessagingVersion, maxMessagingVersion), type, framing, from);
                return initiate;
            }
            catch (EOFException e) {
                return null;
            }
        }

        public boolean equals(Object other) {
            if (!(other instanceof Initiate)) {
                return false;
            }
            Initiate that = (Initiate)other;
            return this.type == that.type && this.framing == that.framing && Objects.equals(this.acceptVersions, that.acceptVersions);
        }

        public String toString() {
            return String.format("Initiate(min: %d, max: %d, type: %s, framing: %b, from: %s)", new Object[]{this.acceptVersions.min, this.acceptVersions.max, this.type, this.framing, this.from});
        }
    }
}

