/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.strategies;

import java.lang.reflect.Array;
import org.github.jamm.MemoryMeterStrategy;
import org.github.jamm.utils.MathUtils;

public abstract class MemoryLayoutBasedStrategy
implements MemoryMeterStrategy {
    private static final int ARRAY_BASE_OFFSET = MEMORY_LAYOUT.getArrayHeaderSize();

    @Override
    public final long measure(Object object) {
        Class<?> type = object.getClass();
        return type.isArray() ? this.measureArray(object, type) : this.measureInstance(object, type);
    }

    @Override
    public long measureArray(Object[] array) {
        return this.computeArraySize(array.length, MEMORY_LAYOUT.getReferenceSize());
    }

    @Override
    public long measureArray(byte[] array) {
        return this.computeArraySize(array.length, 1);
    }

    @Override
    public long measureArray(boolean[] array) {
        return this.computeArraySize(array.length, 1);
    }

    @Override
    public long measureArray(short[] array) {
        return this.computeArraySize(array.length, 2);
    }

    @Override
    public long measureArray(char[] array) {
        return this.computeArraySize(array.length, 2);
    }

    @Override
    public long measureArray(int[] array) {
        return this.computeArraySize(array.length, 4);
    }

    @Override
    public long measureArray(float[] array) {
        return this.computeArraySize(array.length, 4);
    }

    @Override
    public long measureArray(long[] array) {
        return this.computeArraySize(array.length, 8);
    }

    @Override
    public long measureArray(double[] array) {
        return this.computeArraySize(array.length, 8);
    }

    protected abstract long measureInstance(Object var1, Class<?> var2);

    @Override
    public final long measureArray(Object instance, Class<?> type) {
        int length = Array.getLength(instance);
        int elementSize = this.measureField(type.getComponentType());
        return this.computeArraySize(length, elementSize);
    }

    @Override
    public boolean supportComputeArraySize() {
        return true;
    }

    protected int arrayBaseOffset() {
        return ARRAY_BASE_OFFSET;
    }

    @Override
    public long computeArraySize(int length, int elementSize) {
        return MathUtils.roundTo((long)this.arrayBaseOffset() + (long)length * (long)elementSize, MEMORY_LAYOUT.getObjectAlignment());
    }

    protected final int measureField(Class<?> type) {
        if (!type.isPrimitive()) {
            return MEMORY_LAYOUT.getReferenceSize();
        }
        if (type == Boolean.TYPE || type == Byte.TYPE) {
            return 1;
        }
        if (type == Character.TYPE || type == Short.TYPE) {
            return 2;
        }
        if (type == Float.TYPE || type == Integer.TYPE) {
            return 4;
        }
        if (type == Double.TYPE || type == Long.TYPE) {
            return 8;
        }
        throw new IllegalStateException();
    }
}

