/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import org.gridkit.jvmtool.SafePointMonitor;
import org.gridkit.lab.jvm.perfdata.JStatData;

public class PerfCounterSafePointMonitor
implements SafePointMonitor {
    JStatData.LongCounter safePointCount;
    JStatData.TickCounter safePointTime;
    JStatData.TickCounter safePointSyncTime;

    public PerfCounterSafePointMonitor(long pid) {
        JStatData jd = JStatData.connect(pid);
        this.safePointCount = (JStatData.LongCounter)jd.getAllCounters().get("sun.rt.safepoints");
        this.safePointTime = (JStatData.TickCounter)jd.getAllCounters().get("sun.rt.safepointTime");
        this.safePointSyncTime = (JStatData.TickCounter)jd.getAllCounters().get("sun.rt.safepointSyncTime");
    }

    public boolean isAvailable() {
        return this.safePointCount != null && this.safePointTime != null && this.safePointSyncTime != null;
    }

    @Override
    public long getSafePointCount() {
        return this.safePointCount == null ? 0L : this.safePointCount.getLong();
    }

    @Override
    public long getSafePointTime() {
        return this.safePointTime == null ? 0L : this.safePointTime.getNanos();
    }

    @Override
    public long getSafePointSyncTime() {
        return this.safePointSyncTime == null ? 0L : this.safePointSyncTime.getNanos();
    }
}

