/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.log4j.Logger;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarFileNotFoundException;
import org.hyperic.sigar.SigarLog;
import org.hyperic.sigar.SudoFileInputStream;

public abstract class FileTail
extends FileWatcher {
    public static final String PROP_USE_SUDO = "sigar.tail.sudo";
    private boolean useSudo = "true".equals(System.getProperty("sigar.tail.sudo"));
    private static final Logger log = SigarLog.getLogger(FileTail.class.getName());
    private static final boolean isDebug = log.isDebugEnabled();

    public abstract void tail(FileInfo var1, Reader var2);

    public FileTail(Sigar sigar) {
        super(sigar);
    }

    public void useSudo(boolean useSudo) {
        this.useSudo = useSudo;
    }

    static void error(String name, Throwable exc) {
        String msg = name + ": " + exc.getMessage();
        log.error(msg, exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(FileInfo info) {
        InputStream in = null;
        Reader reader = null;
        String name = info.getName();
        try {
            in = this.useSudo ? new SudoFileInputStream(name) : new FileInputStream(name);
            long offset = this.getOffset(info);
            if (offset > 0L) {
                in.skip(offset);
            }
            reader = new InputStreamReader(in);
            this.tail(info, reader);
        }
        catch (IOException e) {
            FileTail.error(name, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public FileInfo add(String file) throws SigarException {
        FileInfo info = super.add(file);
        if (isDebug) {
            log.debug("add: " + file + "=" + info);
        }
        return info;
    }

    protected boolean changed(FileInfo info) throws SigarException, SigarFileNotFoundException {
        return info.modified() || info.getPreviousInfo().size != info.size;
    }

    private long getOffset(FileInfo current) {
        FileInfo previous = current.getPreviousInfo();
        if (previous == null) {
            if (isDebug) {
                log.debug(current.getName() + ": first stat");
            }
            return current.size;
        }
        if (current.inode != previous.inode) {
            if (isDebug) {
                log.debug(current.getName() + ": file inode changed");
            }
            return -1L;
        }
        if (current.size < previous.size) {
            if (isDebug) {
                log.debug(current.getName() + ": file truncated");
            }
            return -1L;
        }
        if (isDebug) {
            long diff = current.size - previous.size;
            log.debug(current.getName() + ": " + diff + " new bytes");
        }
        return previous.size;
    }
}

