/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaClass;

public class LazyDynaClassTestCase
extends TestCase {
    protected LazyDynaClass dynaClass;
    protected String testProperty = "myProperty";

    public static void main(String[] args) {
        TestRunner.run((Test)LazyDynaClassTestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(LazyDynaClassTestCase.class);
    }

    public LazyDynaClassTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.dynaClass = new LazyDynaClass();
    }

    public void tearDown() {
        this.dynaClass = null;
    }

    public void testAddProperty1() {
        this.dynaClass.add(this.testProperty);
        DynaProperty dynaProperty = this.dynaClass.getDynaProperty(this.testProperty);
        LazyDynaClassTestCase.assertEquals((String)"name is correct", (String)this.testProperty, (String)dynaProperty.getName());
        LazyDynaClassTestCase.assertEquals((String)"type is correct", Object.class, (Object)dynaProperty.getType());
    }

    public void testAddProperty2() {
        this.dynaClass.add(this.testProperty, String.class);
        DynaProperty dynaProperty = this.dynaClass.getDynaProperty(this.testProperty);
        LazyDynaClassTestCase.assertEquals((String)"name is correct", (String)this.testProperty, (String)dynaProperty.getName());
        LazyDynaClassTestCase.assertEquals((String)"type is correct", String.class, (Object)dynaProperty.getType());
    }

    public void testAddProperty3() {
        try {
            this.dynaClass.add(this.testProperty, String.class, true, true);
            LazyDynaClassTestCase.fail((String)"add(name, type, readable, writable) did not throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAddPropertyNullName1() {
        try {
            this.dynaClass.add((String)null);
            LazyDynaClassTestCase.fail((String)"null property name not prevented");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddPropertyNullName2() {
        try {
            this.dynaClass.add(null, String.class);
            LazyDynaClassTestCase.fail((String)"null property name not prevented");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddPropertyNullName3() {
        try {
            this.dynaClass.add(null, String.class, true, true);
            LazyDynaClassTestCase.fail((String)"add(name, type, readable, writable) did not throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAddPropertyRestricted1() {
        this.dynaClass.setRestricted(true);
        LazyDynaClassTestCase.assertTrue((String)"MutableDynaClass is restricted", (boolean)this.dynaClass.isRestricted());
        try {
            this.dynaClass.add(this.testProperty);
            LazyDynaClassTestCase.fail((String)"add(name) did not throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAddPropertyRestricted2() {
        this.dynaClass.setRestricted(true);
        LazyDynaClassTestCase.assertTrue((String)"MutableDynaClass is restricted", (boolean)this.dynaClass.isRestricted());
        try {
            this.dynaClass.add(this.testProperty, String.class);
            LazyDynaClassTestCase.fail((String)"add(name, type) did not throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAddPropertyRestricted3() {
        this.dynaClass.setRestricted(true);
        LazyDynaClassTestCase.assertTrue((String)"MutableDynaClass is restricted", (boolean)this.dynaClass.isRestricted());
        try {
            this.dynaClass.add(this.testProperty, String.class, true, true);
            LazyDynaClassTestCase.fail((String)"add(name, type, readable, writable) did not throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetPropertyDoesntExist1() {
        this.dynaClass.setReturnNull(false);
        LazyDynaClassTestCase.assertFalse((String)"returnNull is 'false'", (boolean)this.dynaClass.isReturnNull());
        DynaProperty dynaProperty = this.dynaClass.getDynaProperty(this.testProperty);
        LazyDynaClassTestCase.assertEquals((String)"name is correct", (String)this.testProperty, (String)dynaProperty.getName());
        LazyDynaClassTestCase.assertEquals((String)"type is correct", Object.class, (Object)dynaProperty.getType());
        LazyDynaClassTestCase.assertFalse((String)"property doesnt exist", (boolean)this.dynaClass.isDynaProperty(this.testProperty));
    }

    public void testGetPropertyDoesntExist2() {
        this.dynaClass.setReturnNull(true);
        LazyDynaClassTestCase.assertTrue((String)"returnNull is 'true'", (boolean)this.dynaClass.isReturnNull());
        LazyDynaClassTestCase.assertNull((String)"property is null", (Object)this.dynaClass.getDynaProperty(this.testProperty));
    }

    public void testRemoveProperty() {
        this.dynaClass.setReturnNull(true);
        this.dynaClass.add(this.testProperty);
        LazyDynaClassTestCase.assertTrue((String)"Property exists", (boolean)this.dynaClass.isDynaProperty(this.testProperty));
        LazyDynaClassTestCase.assertNotNull((String)"property is Not null", (Object)this.dynaClass.getDynaProperty(this.testProperty));
        this.dynaClass.remove(this.testProperty);
        LazyDynaClassTestCase.assertFalse((String)"Property doesn't exist", (boolean)this.dynaClass.isDynaProperty(this.testProperty));
        LazyDynaClassTestCase.assertNull((String)"property is null", (Object)this.dynaClass.getDynaProperty(this.testProperty));
    }

    public void testRemovePropertyDoesntExist() {
        LazyDynaClassTestCase.assertFalse((String)"property doesn't exist", (boolean)this.dynaClass.isDynaProperty(this.testProperty));
        this.dynaClass.remove(this.testProperty);
        LazyDynaClassTestCase.assertFalse((String)"property still doesn't exist", (boolean)this.dynaClass.isDynaProperty(this.testProperty));
    }

    public void testRemovePropertyNullName() {
        try {
            this.dynaClass.remove(null);
            LazyDynaClassTestCase.fail((String)"remove(null) did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemovePropertyRestricted() {
        this.dynaClass.add(this.testProperty);
        LazyDynaClassTestCase.assertTrue((String)"Property exists", (boolean)this.dynaClass.isDynaProperty(this.testProperty));
        this.dynaClass.setRestricted(true);
        LazyDynaClassTestCase.assertTrue((String)"MutableDynaClass is restricted", (boolean)this.dynaClass.isRestricted());
        try {
            this.dynaClass.remove(this.testProperty);
            LazyDynaClassTestCase.fail((String)"remove property when MutableDynaClassis restricted did not throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

