/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.converters.AbstractConverter;

public abstract class DateTimeConverter<D>
extends AbstractConverter<D> {
    private String[] patterns;
    private String displayPatterns;
    private Locale locale;
    private TimeZone timeZone;
    private boolean useLocaleFormat;

    public DateTimeConverter() {
    }

    public DateTimeConverter(D defaultValue) {
        super(defaultValue);
    }

    @Override
    protected String convertToString(Object value) {
        java.util.Date date = null;
        if (value instanceof java.util.Date) {
            date = (java.util.Date)value;
        } else if (value instanceof Calendar) {
            date = ((Calendar)value).getTime();
        } else if (value instanceof Long) {
            date = new java.util.Date((Long)value);
        } else if (value instanceof LocalDateTime) {
            date = Timestamp.valueOf((LocalDateTime)value);
        } else if (value instanceof LocalDate) {
            date = Date.valueOf((LocalDate)value);
        } else if (value instanceof ZonedDateTime) {
            date = java.util.Date.from(((ZonedDateTime)value).toInstant());
        } else if (value instanceof OffsetDateTime) {
            date = java.util.Date.from(((OffsetDateTime)value).toInstant());
        } else if (value instanceof TemporalAccessor) {
            date = java.util.Date.from(Instant.from((TemporalAccessor)value));
        }
        String result = null;
        if (this.useLocaleFormat && date != null) {
            DateFormat format = null;
            format = this.patterns != null && this.patterns.length > 0 ? this.getFormat(this.patterns[0]) : this.getFormat(this.locale, this.timeZone);
            this.logFormat("Formatting", format);
            result = format.format(date);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("    Converted  to String using format '" + result + "'"));
            }
        } else {
            result = value.toString();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("    Converted  to String using toString() '" + result + "'"));
            }
        }
        return result;
    }

    @Override
    protected <T> T convertToType(Class<T> targetType, Object value) throws Exception {
        Class<?> sourceType = value.getClass();
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            long timeInMillis = timestamp.getTime() / 1000L * 1000L;
            return this.toDate(targetType, timeInMillis += (long)(timestamp.getNanos() / 1000000));
        }
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            return this.toDate(targetType, date.getTime());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return this.toDate(targetType, calendar.getTime().getTime());
        }
        if (value instanceof Long) {
            Long longObj = (Long)value;
            return this.toDate(targetType, longObj);
        }
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            return this.toDate(targetType, date.atStartOfDay(this.getZoneId()).toInstant().toEpochMilli());
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime date = (LocalDateTime)value;
            return this.toDate(targetType, date.atZone(this.getZoneId()).toInstant().toEpochMilli());
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime date = (ZonedDateTime)value;
            return this.toDate(targetType, date.toInstant().toEpochMilli());
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime date = (OffsetDateTime)value;
            return this.toDate(targetType, date.toInstant().toEpochMilli());
        }
        String stringValue = DateTimeConverter.toTrim(value);
        if (stringValue.isEmpty()) {
            return this.handleMissing(targetType);
        }
        if (this.useLocaleFormat) {
            Calendar calendar = null;
            if (this.patterns != null && this.patterns.length > 0) {
                calendar = this.parse(sourceType, targetType, stringValue);
            } else {
                DateFormat format = this.getFormat(this.locale, this.timeZone);
                calendar = this.parse(sourceType, targetType, stringValue, format);
            }
            if (Calendar.class.isAssignableFrom(targetType)) {
                return targetType.cast(calendar);
            }
            return this.toDate(targetType, calendar.getTime().getTime());
        }
        return this.toDate(targetType, stringValue);
    }

    protected DateFormat getFormat(Locale locale, TimeZone timeZone) {
        DateFormat format = null;
        format = locale == null ? DateFormat.getDateInstance(3) : DateFormat.getDateInstance(3, locale);
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        }
        return format;
    }

    private DateFormat getFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        if (this.timeZone != null) {
            format.setTimeZone(this.timeZone);
        }
        return format;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String[] getPatterns() {
        return (String[])this.patterns.clone();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    private ZoneId getZoneId() {
        return this.timeZone == null ? ZoneId.systemDefault() : this.timeZone.toZoneId();
    }

    private void logFormat(String action, DateFormat format) {
        if (this.log().isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder(45);
            buffer.append("    ");
            buffer.append(action);
            buffer.append(" with Format");
            if (format instanceof SimpleDateFormat) {
                buffer.append("[");
                buffer.append(((SimpleDateFormat)format).toPattern());
                buffer.append("]");
            }
            buffer.append(" for ");
            if (this.locale == null) {
                buffer.append("default locale");
            } else {
                buffer.append("locale[");
                buffer.append(this.locale);
                buffer.append("]");
            }
            if (this.timeZone != null) {
                buffer.append(", TimeZone[");
                buffer.append(this.timeZone);
                buffer.append("]");
            }
            this.log().debug((Object)buffer.toString());
        }
    }

    private Calendar parse(Class<?> sourceType, Class<?> targetType, String value) throws Exception {
        Exception firstEx = null;
        for (String pattern : this.patterns) {
            try {
                return this.parse(sourceType, targetType, value, this.getFormat(pattern));
            }
            catch (Exception ex) {
                if (firstEx != null) continue;
                firstEx = ex;
            }
        }
        if (this.patterns.length > 1) {
            throw ConversionException.format("Error converting '%s' to '%s' using  patterns '%s'", this.toString(sourceType), this.toString(targetType), this.displayPatterns);
        }
        if (firstEx != null) {
            throw firstEx;
        }
        return null;
    }

    private Calendar parse(Class<?> sourceType, Class<?> targetType, String value, DateFormat format) {
        this.logFormat("Parsing", format);
        format.setLenient(false);
        ParsePosition pos = new ParsePosition(0);
        java.util.Date parsedDate = format.parse(value, pos);
        int errorIndex = pos.getErrorIndex();
        if (errorIndex >= 0 || pos.getIndex() != value.length() || parsedDate == null) {
            String msg = "Error converting '" + this.toString(sourceType) + "' to '" + this.toString(targetType) + "'";
            if (format instanceof SimpleDateFormat) {
                SimpleDateFormat simpleFormat = (SimpleDateFormat)format;
                msg = msg + String.format(" using pattern '%s', localized pattern '%s', errorIndex %,d, calendar type %s, this %s", simpleFormat.toPattern(), simpleFormat.toLocalizedPattern(), errorIndex, format.getCalendar().getClass().getSimpleName(), this);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("    " + msg));
            }
            throw new ConversionException(msg);
        }
        return format.getCalendar();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setUseLocaleFormat(true);
    }

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public void setPatterns(String[] patterns) {
        String[] stringArray = this.patterns = patterns != null ? (String[])patterns.clone() : null;
        if (this.patterns != null && this.patterns.length > 1) {
            this.displayPatterns = String.join((CharSequence)", ", this.patterns);
        }
        this.setUseLocaleFormat(true);
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setUseLocaleFormat(boolean useLocaleFormat) {
        this.useLocaleFormat = useLocaleFormat;
    }

    private <T> T toDate(Class<T> type, long value) {
        if (type.equals(java.util.Date.class)) {
            return type.cast(new java.util.Date(value));
        }
        if (type.equals(Date.class)) {
            return type.cast(new Date(value));
        }
        if (type.equals(Time.class)) {
            return type.cast(new Time(value));
        }
        if (type.equals(Timestamp.class)) {
            return type.cast(new Timestamp(value));
        }
        if (type.equals(LocalDate.class)) {
            LocalDate localDate = Instant.ofEpochMilli(value).atZone(this.getZoneId()).toLocalDate();
            return type.cast(localDate);
        }
        if (type.equals(LocalDateTime.class)) {
            LocalDateTime localDateTime = Instant.ofEpochMilli(value).atZone(this.getZoneId()).toLocalDateTime();
            return type.cast(localDateTime);
        }
        if (type.equals(ZonedDateTime.class)) {
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(value), this.getZoneId());
            return type.cast(zonedDateTime);
        }
        if (type.equals(OffsetDateTime.class)) {
            OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(value), this.getZoneId());
            return type.cast(offsetDateTime);
        }
        if (type.equals(Calendar.class)) {
            Calendar calendar = null;
            calendar = this.locale == null && this.timeZone == null ? Calendar.getInstance() : (this.locale == null ? Calendar.getInstance(this.timeZone) : (this.timeZone == null ? Calendar.getInstance(this.locale) : Calendar.getInstance(this.timeZone, this.locale)));
            calendar.setTime(new java.util.Date(value));
            calendar.setLenient(false);
            return type.cast(calendar);
        }
        String msg = this.toString(this.getClass()) + " cannot handle conversion to '" + this.toString(type) + "'";
        if (this.log().isWarnEnabled()) {
            this.log().warn((Object)("    " + msg));
        }
        throw new ConversionException(msg);
    }

    private <T> T toDate(Class<T> type, String value) {
        if (type.equals(Date.class)) {
            try {
                return type.cast(Date.valueOf(value));
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("String must be in JDBC format [yyyy-MM-dd] to create a java.sql.Date");
            }
        }
        if (type.equals(Time.class)) {
            try {
                return type.cast(Time.valueOf(value));
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("String must be in JDBC format [HH:mm:ss] to create a java.sql.Time");
            }
        }
        if (type.equals(Timestamp.class)) {
            try {
                return type.cast(Timestamp.valueOf(value));
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("String must be in JDBC format [yyyy-MM-dd HH:mm:ss.fffffffff] to create a java.sql.Timestamp");
            }
        }
        String msg = this.toString(this.getClass()) + " does not support default String to '" + this.toString(type) + "' conversion.";
        if (this.log().isWarnEnabled()) {
            this.log().warn((Object)("    " + msg));
            this.log().warn((Object)"    (Re-configure Converter or use alternative implementation)");
        }
        throw new ConversionException(msg);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.toString(this.getClass()));
        buffer.append("[UseDefault=");
        buffer.append(this.isUseDefault());
        buffer.append(", UseLocaleFormat=");
        buffer.append(this.useLocaleFormat);
        if (this.displayPatterns != null) {
            buffer.append(", Patterns={");
            buffer.append(this.displayPatterns);
            buffer.append('}');
        }
        if (this.locale != null) {
            buffer.append(", Locale=");
            buffer.append(this.locale);
        }
        if (this.timeZone != null) {
            buffer.append(", TimeZone=");
            buffer.append(this.timeZone);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

