/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Compress679Test {
    Compress679Test() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCompress679() {
        Path origin = Paths.get("src/test/resources/org/apache/commons/compress/COMPRESS-679/file.7z", new String[0]);
        Assertions.assertTrue((boolean)Files.exists(origin, new LinkOption[0]));
        Callable<Boolean> runnable = () -> {
            try (SevenZFile sevenZFile = ((SevenZFile.Builder)SevenZFile.builder().setPath(origin)).get();){
                SevenZArchiveEntry sevenZArchiveEntry;
                while ((sevenZArchiveEntry = sevenZFile.getNextEntry()) != null) {
                    if (!"file4.txt".equals(sevenZArchiveEntry.getName())) continue;
                    InputStream inputStream = sevenZFile.getInputStream(sevenZArchiveEntry);
                    break;
                }
            }
            return Boolean.TRUE;
        };
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        try {
            List<Future> futures = IntStream.range(0, 30).mapToObj(i -> threadPool.submit(runnable)).collect(Collectors.toList());
            futures.forEach(f -> Assertions.assertDoesNotThrow(() -> (Boolean)f.get()));
        }
        finally {
            threadPool.shutdownNow();
        }
    }
}

