/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.compress.archivers.zip.NioZipEncoding;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NioZipEncodingTest {
    private static final String UMLAUTS = "\u00e4\u00f6\u00fc";
    private static final String RAINBOW_EMOJI = "\ud83c\udf08";

    NioZipEncodingTest() {
    }

    @Test
    void testPartialSurrogatePair() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.US_ASCII);
        ByteBuffer bb = e.encode("\ud83c");
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertEquals((int)0, (int)result.length);
    }

    @Test
    void testRainbowEmojiToSurrogatePairUTF16() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.UTF_16BE);
        ByteBuffer bb = e.encode(RAINBOW_EMOJI);
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertArrayEquals((byte[])RAINBOW_EMOJI.getBytes(StandardCharsets.UTF_16BE), (byte[])result);
    }

    @Test
    void testUmlautToISO88591() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.ISO_8859_1);
        ByteBuffer bb = e.encode(UMLAUTS);
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertArrayEquals((byte[])UMLAUTS.getBytes(StandardCharsets.ISO_8859_1), (byte[])result);
    }

    @Test
    void testUmlautToUTF16BE() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.UTF_16BE);
        ByteBuffer bb = e.encode(UMLAUTS);
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertArrayEquals((byte[])UMLAUTS.getBytes(StandardCharsets.UTF_16BE), (byte[])result);
    }

    @Test
    void testUmlautToUTF8() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.UTF_8);
        ByteBuffer bb = e.encode(UMLAUTS);
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertArrayEquals((byte[])UMLAUTS.getBytes(StandardCharsets.UTF_8), (byte[])result);
    }

    @Test
    void testUnmappableRainbowEmoji() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.US_ASCII);
        ByteBuffer bb = e.encode(RAINBOW_EMOJI);
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertEquals((Object)"%UD83C%UDF08", (Object)new String(result, StandardCharsets.US_ASCII));
    }

    @Test
    void testUnmappableUmlauts() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.US_ASCII);
        ByteBuffer bb = e.encode(UMLAUTS);
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertEquals((Object)"%U00E4%U00F6%U00FC", (Object)new String(result, StandardCharsets.US_ASCII));
    }
}

