/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.stream.Stream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public final class BlockLZ4CompressorRoundtripTest
extends AbstractTest {
    public static Stream<Arguments> factory() {
        return Stream.of(Arguments.of((Object[])new Object[]{"default", BlockLZ4CompressorOutputStream.createParameterBuilder().build()}), Arguments.of((Object[])new Object[]{"tuned for speed", BlockLZ4CompressorOutputStream.createParameterBuilder().tunedForSpeed().build()}), Arguments.of((Object[])new Object[]{"tuned for compression ratio", BlockLZ4CompressorOutputStream.createParameterBuilder().tunedForCompressionRatio().build()}));
    }

    @ParameterizedTest
    @MethodSource(value={"factory"})
    public void biggerFileRoundtrip(String config, Parameters params) throws IOException {
        this.roundTripTest("COMPRESS-256.7z", config, params);
    }

    @ParameterizedTest
    @MethodSource(value={"factory"})
    public void blaTarRoundtrip(String config, Parameters params) throws IOException {
        this.roundTripTest("bla.tar", config, params);
    }

    @ParameterizedTest
    @MethodSource(value={"factory"})
    public void gzippedLoremIpsumRoundtrip(String config, Parameters params) throws IOException {
        this.roundTripTest("lorem-ipsum.txt.gz", config, params);
    }

    private void roundTripTest(String testFile, String config, Parameters params) throws IOException {
        File input = BlockLZ4CompressorRoundtripTest.getFile(testFile);
        File outputSz = this.newTempFile(input.getName() + ".block.lz4");
        try (OutputStream os = Files.newOutputStream(outputSz.toPath(), new OpenOption[0]);
             BlockLZ4CompressorOutputStream los = new BlockLZ4CompressorOutputStream(os, params);){
            los.write(input);
        }
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             BlockLZ4CompressorInputStream sis = new BlockLZ4CompressorInputStream(Files.newInputStream(outputSz.toPath(), new OpenOption[0]));){
            byte[] expected = IOUtils.toByteArray((InputStream)is);
            byte[] actual = IOUtils.toByteArray((InputStream)sis);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }
}

