/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.harmony.pack200.Archive;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.pack200.PackingOptions;
import org.apache.commons.compress.harmony.pack200.PackingUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PackingOptionsTest
extends AbstractTempDirTest {
    PackingOptionsTest() {
    }

    private void compareFiles(JarFile jarFile, JarFile jarFile2) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Assertions.assertNotNull((Object)entry);
            String name = entry.getName();
            JarEntry entry2 = jarFile2.getJarEntry(name);
            Assertions.assertNotNull((Object)entry2, (String)("Missing Entry: " + name));
            if (name.equals("META-INF/MANIFEST.MF")) continue;
            InputStream ours = jarFile.getInputStream(entry);
            InputStream expected = jarFile2.getInputStream(entry2);
            try (BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
                 BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));){
                String line1 = reader1.readLine();
                String line2 = reader2.readLine();
                int i = 1;
                while (line1 != null || line2 != null) {
                    Assertions.assertEquals((Object)line2, (Object)line1, (String)("Unpacked files differ for " + name + " at line " + i));
                    line1 = reader1.readLine();
                    line2 = reader2.readLine();
                    ++i;
                }
            }
        }
    }

    private void compareJarEntries(JarFile jarFile, JarFile jarFile2) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Assertions.assertNotNull((Object)entry);
            String name = entry.getName();
            JarEntry entry2 = jarFile2.getJarEntry(name);
            Assertions.assertNotNull((Object)entry2, (String)("Missing Entry: " + name));
        }
    }

    @Test
    void testDeflateHint() {
        PackingOptions options = new PackingOptions();
        Assertions.assertEquals((Object)"keep", (Object)options.getDeflateHint());
        options.setDeflateHint("true");
        Assertions.assertEquals((Object)"true", (Object)options.getDeflateHint());
        options.setDeflateHint("false");
        Assertions.assertEquals((Object)"false", (Object)options.getDeflateHint());
        Assertions.assertThrows(IllegalArgumentException.class, () -> options.setDeflateHint("hello"), (String)"Should throw IllegalArgumentException for incorrect deflate hint");
    }

    @Test
    void testErrorAttributes() throws Exception {
        File file = this.createTempFile("unknown", ".pack");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI()));
             FileOutputStream out = new FileOutputStream(file);){
            PackingOptions options = new PackingOptions();
            options.addClassAttributeAction("Pack200", "error");
            Archive ar = new Archive(in, (OutputStream)out, options);
            Error error = (Error)Assertions.assertThrows(Error.class, () -> {
                ar.pack();
                in.close();
                out.close();
            });
            Assertions.assertEquals((Object)"Attribute Pack200 was found", (Object)error.getMessage());
        }
    }

    @Test
    void testKeepFileOrder() throws Exception {
        Enumeration<JarEntry> entries2;
        Enumeration<JarEntry> entries;
        JarFile jarFile2;
        PackingOptions options = new PackingOptions();
        Assertions.assertTrue((boolean)options.isKeepFileOrder());
        options.setKeepFileOrder(false);
        Assertions.assertFalse((boolean)options.isKeepFileOrder());
        File file = this.createTempFile("sql", ".pack");
        try (JarFile jarFile = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
             FileOutputStream outputStream = new FileOutputStream(file);){
            options = new PackingOptions();
            options.setGzip(false);
            new Archive(jarFile, (OutputStream)outputStream, options).pack();
        }
        File file2 = this.createTempFile("sql", ".jar");
        this.unpackJar(file, file2);
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        try (JarFile jarFile = new JarFile(file2);){
            jarFile2 = new JarFile(compareFile);
            try {
                entries = jarFile.entries();
                entries2 = jarFile2.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    Assertions.assertNotNull((Object)entry);
                    JarEntry entry2 = entries2.nextElement();
                    String name = entry.getName();
                    String name2 = entry2.getName();
                    Assertions.assertEquals((Object)name, (Object)name2);
                }
            }
            finally {
                jarFile2.close();
            }
        }
        file = this.createTempFile("sql", ".pack");
        jarFile = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            options = new PackingOptions();
            options.setKeepFileOrder(false);
            options.setGzip(false);
            new Archive(jarFile, (OutputStream)outputStream, options).pack();
        }
        finally {
            jarFile.close();
        }
        file2 = this.createTempFile("sql", ".jar");
        this.unpackJar(file, file2);
        compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        jarFile = new JarFile(file2);
        try {
            jarFile2 = new JarFile(compareFile);
            try {
                this.compareJarEntries(jarFile, jarFile2);
                entries = jarFile.entries();
                entries2 = jarFile2.entries();
                boolean inOrder = true;
                while (entries.hasMoreElements()) {
                    String name2;
                    JarEntry entry = entries.nextElement();
                    Assertions.assertNotNull((Object)entry);
                    JarEntry entry2 = entries2.nextElement();
                    String name = entry.getName();
                    if (name.equals(name2 = entry2.getName())) continue;
                    inOrder = false;
                    break;
                }
                Assertions.assertFalse((boolean)inOrder, (String)"Files are not expected to be in order");
            }
            finally {
                jarFile2.close();
            }
        }
        finally {
            jarFile.close();
        }
    }

    @Test
    void testLoggingOptions() throws Exception {
        FileOutputStream out;
        PackingOptions options = new PackingOptions();
        Assertions.assertFalse((boolean)options.isVerbose());
        Assertions.assertNull((Object)options.getLogFile());
        options.setVerbose(true);
        Assertions.assertTrue((boolean)options.isVerbose());
        options.setQuiet(true);
        Assertions.assertFalse((boolean)options.isVerbose());
        File logFile = this.createTempFile("logfile", ".txt");
        options.setLogFile(logFile.getPath());
        Assertions.assertEquals((Object)logFile.getPath(), (Object)options.getLogFile());
        File file = this.createTempFile("helloworld", ".pack.gz");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));){
            out = new FileOutputStream(file);
            try {
                new Archive(in, (OutputStream)out, options).pack();
            }
            finally {
                out.close();
            }
        }
        try (FileReader reader = new FileReader(logFile);){
            Assertions.assertFalse((boolean)reader.ready());
        }
        options.setVerbose(true);
        file = this.createTempFile("helloworld", ".pack.gz");
        in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
        try {
            out = new FileOutputStream(file);
            try {
                new Archive(in, (OutputStream)out, options).pack();
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
        reader = new FileReader(logFile);
        try {
            Assertions.assertTrue((boolean)reader.ready());
        }
        finally {
            reader.close();
        }
        PackingUtils.config(null);
    }

    @Test
    void testModificationTime() throws Exception {
        Enumeration<JarEntry> entries2;
        Enumeration<JarEntry> entries;
        JarFile jarFile2;
        PackingOptions options = new PackingOptions();
        Assertions.assertEquals((Object)"keep", (Object)options.getModificationTime());
        options.setModificationTime("latest");
        Assertions.assertEquals((Object)"latest", (Object)options.getModificationTime());
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            PackingOptions illegalOption = new PackingOptions();
            illegalOption.setModificationTime("true");
        }, (String)"Should throw IllegalArgumentException for incorrect mod time");
        File file = this.createTempFile("sql", ".pack");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
             FileOutputStream out = new FileOutputStream(file);){
            options = new PackingOptions();
            options.setGzip(false);
            new Archive(in, (OutputStream)out, options).pack();
        }
        File file2 = this.createTempFile("sql", ".jar");
        this.unpackJar(file, file2);
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        try (JarFile jarFile = new JarFile(file2);){
            jarFile2 = new JarFile(compareFile);
            try {
                entries = jarFile.entries();
                entries2 = jarFile2.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    Assertions.assertNotNull((Object)entry);
                    JarEntry entry2 = entries2.nextElement();
                    String name = entry.getName();
                    String name2 = entry2.getName();
                    Assertions.assertEquals((Object)name, (Object)name2);
                    Assertions.assertEquals((long)entry.getTime(), (long)entry2.getTime());
                }
            }
            finally {
                jarFile2.close();
            }
        }
        file = this.createTempFile("sql", ".pack");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
             FileOutputStream out = new FileOutputStream(file);){
            options = new PackingOptions();
            options.setGzip(false);
            options.setModificationTime("latest");
            new Archive(in, (OutputStream)out, options).pack();
        }
        file2 = this.createTempFile("sql", ".jar");
        this.unpackJar(file, file2);
        compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        jarFile = new JarFile(file2);
        try {
            jarFile2 = new JarFile(compareFile);
            try {
                entries = jarFile.entries();
                entries2 = jarFile2.entries();
                long modtime = -1L;
                boolean sameAsOriginal = true;
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    Assertions.assertNotNull((Object)entry);
                    JarEntry entry2 = entries2.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith("META-INF")) {
                        if (modtime == -1L) {
                            modtime = entry.getTime();
                        } else {
                            Assertions.assertEquals((long)modtime, (long)entry.getTime());
                        }
                    }
                    if (entry2.getTime() == entry.getTime()) continue;
                    sameAsOriginal = false;
                }
                Assertions.assertFalse((boolean)sameAsOriginal, (String)"Some modtimes should have changed");
            }
            finally {
                jarFile2.close();
            }
        }
        finally {
            jarFile.close();
        }
    }

    @Test
    void testNewAttributes() throws Exception {
        File file = this.createTempFile("unknown", ".pack");
        try (FileOutputStream out = new FileOutputStream(file);
             JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI()));){
            PackingOptions options = new PackingOptions();
            options.addClassAttributeAction("Pack200", "I");
            new Archive(in, (OutputStream)out, options).pack();
        }
        File file2 = this.createTempFile("unknown", ".jar");
        this.unpackJar(file, file2);
        File compareFile = new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI());
        try (JarFile jarFile = new JarFile(file2);
             JarFile jarFile2 = new JarFile(compareFile);){
            Assertions.assertEquals((int)jarFile2.size(), (int)jarFile.size());
            this.compareJarEntries(jarFile, jarFile2);
        }
    }

    @Test
    void testNewAttributes2() throws Exception {
        File file = this.createTempFile("unknown", ".pack");
        try (FileOutputStream out = new FileOutputStream(file);
             JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/p200WithUnknownAttributes.jar").toURI()));){
            PackingOptions options = new PackingOptions();
            options.addFieldAttributeAction("Pack200", "I");
            options.addMethodAttributeAction("Pack200", "I");
            options.addCodeAttributeAction("Pack200", "I");
            Archive ar = new Archive(in, (OutputStream)out, options);
            ar.pack();
        }
        File file2 = this.createTempFile("unknown", ".jar");
        this.unpackJar(file, file2);
        File compareFile = new File(Archive.class.getResource("/pack200/p200WithUnknownAttributes.jar").toURI());
        try (JarFile jarFile = new JarFile(file2);
             JarFile jarFile2 = new JarFile(compareFile);){
            Assertions.assertEquals((int)jarFile2.size(), (int)jarFile.size());
            this.compareJarEntries(jarFile, jarFile2);
        }
    }

    @Test
    void testPackEffort0() throws Pack200Exception, IOException, URISyntaxException {
        File f1 = new File(Archive.class.getResource("/pack200/jndi.jar").toURI());
        File file = this.createTempFile("jndiE0", ".pack");
        try (JarFile in = new JarFile(f1);
             FileOutputStream out = new FileOutputStream(file);){
            PackingOptions options = new PackingOptions();
            options.setGzip(false);
            options.setEffort(0);
            new Archive(in, (OutputStream)out, options).pack();
        }
        try (JarFile jf1 = new JarFile(f1);
             JarFile jf2 = new JarFile(file);){
            this.compareFiles(jf1, jf2);
        }
    }

    @Test
    void testPassAttributes() throws Exception {
        File file = this.createTempFile("unknown", ".pack");
        try (FileOutputStream out = new FileOutputStream(file);
             JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI()));){
            PackingOptions options = new PackingOptions();
            options.addClassAttributeAction("Pack200", "pass");
            new Archive(in, (OutputStream)out, options).pack();
        }
        File file2 = this.createTempFile("unknown", ".jar");
        this.unpackJar(file, file2);
        File compareFile = new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI());
        try (JarFile jarFile = new JarFile(file2);
             JarFile jarFile2 = new JarFile(compareFile);){
            Assertions.assertEquals((int)jarFile2.size(), (int)jarFile.size());
            this.compareJarEntries(jarFile, jarFile2);
        }
    }

    @Test
    void testPassFiles() throws IOException, URISyntaxException, Pack200Exception {
        File file0 = this.createTempFile("sql", ".pack");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
             FileOutputStream out = new FileOutputStream(file0);){
            PackingOptions options = new PackingOptions();
            options.setGzip(false);
            new Archive(in, (OutputStream)out, options).pack();
        }
        File file = this.createTempFile("sql", ".pack");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
             FileOutputStream out = new FileOutputStream(file);){
            PackingOptions options = new PackingOptions();
            options.setGzip(false);
            options.addPassFile("bin/test/org/apache/harmony/sql/tests/java/sql/DatabaseMetaDataTest.class");
            Assertions.assertTrue((boolean)options.isPassFile("bin/test/org/apache/harmony/sql/tests/java/sql/DatabaseMetaDataTest.class"));
            new Archive(in, (OutputStream)out, options).pack();
        }
        File file2 = this.createTempFile("sql", ".pack");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
             FileOutputStream out = new FileOutputStream(file2);){
            PackingOptions options = new PackingOptions();
            options.setGzip(false);
            options.addPassFile("bin/test/org/apache/harmony/sql/tests/java/sql");
            Assertions.assertTrue((boolean)options.isPassFile("bin/test/org/apache/harmony/sql/tests/java/sql/DatabaseMetaDataTest.class"));
            Assertions.assertFalse((boolean)options.isPassFile("bin/test/org/apache/harmony/sql/tests/java/sqldata/SqlData.class"));
            new Archive(in, (OutputStream)out, options).pack();
        }
        Assertions.assertTrue((file.length() > file0.length() ? 1 : 0) != 0, (String)"If files are passed then the pack file should be larger");
        Assertions.assertTrue((file2.length() > file.length() ? 1 : 0) != 0, (String)"If more files are passed then the pack file should be larger");
        File file3 = this.createTempFile("sql", ".jar");
        this.unpackJar(file, file3);
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        try (JarFile jarFile = new JarFile(file3);
             JarFile jarFile2 = new JarFile(compareFile);){
            this.compareJarEntries(jarFile, jarFile2);
        }
        File file4 = this.createTempFile("sql", ".jar");
        this.unpackJar(file2, file4);
        try (JarFile jarFile = new JarFile(file4);
             JarFile jarFile2 = new JarFile(compareFile);){
            this.compareJarEntries(jarFile, jarFile2);
        }
    }

    @Test
    void testSegmentLimits() throws IOException, Pack200Exception, URISyntaxException {
        PackingOptions options;
        FileOutputStream out;
        File file = this.createTempFile("helloworld", ".pack.gz");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));){
            out = new FileOutputStream(file);
            try {
                options = new PackingOptions();
                options.setSegmentLimit(0L);
                Archive archive = new Archive(in, (OutputStream)out, options);
                archive.pack();
            }
            finally {
                out.close();
            }
        }
        file = this.createTempFile("helloworld", ".pack.gz");
        in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
        try {
            out = new FileOutputStream(file);
            try {
                options = new PackingOptions();
                options.setSegmentLimit(-1L);
                new Archive(in, (OutputStream)out, options).pack();
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
        file = this.createTempFile("helloworld", ".pack.gz");
        in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
        try {
            out = new FileOutputStream(file);
            try {
                options = new PackingOptions();
                options.setSegmentLimit(5000L);
                new Archive(in, (OutputStream)out, options).pack();
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    @Test
    void testStripDebug() throws IOException, Pack200Exception, URISyntaxException {
        File file = this.createTempFile("sql", ".pack");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
             FileOutputStream out = new FileOutputStream(file);){
            PackingOptions options = new PackingOptions();
            options.setGzip(false);
            options.setStripDebug(true);
            Archive archive = new Archive(in, (OutputStream)out, options);
            archive.pack();
        }
        File file2 = this.createTempFile("sqloutNoDebug", ".jar");
        this.unpackJar(file, file2);
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpackedNoDebug.jar").toURI());
        try (JarFile jarFile = new JarFile(file2);
             JarFile jarFile2 = new JarFile(compareFile);){
            Assertions.assertTrue((file2.length() < 250000L ? 1 : 0) != 0);
            this.compareFiles(jarFile, jarFile2);
        }
    }

    private void unpack(InputStream inputStream, JarOutputStream outputStream) throws Pack200Exception, IOException {
        new org.apache.commons.compress.harmony.unpack200.Archive(inputStream, outputStream).unpack();
    }

    private void unpackJar(File sourceFile, File destFile) throws Pack200Exception, IOException, FileNotFoundException {
        try (FileInputStream in2 = new FileInputStream(sourceFile);
             JarOutputStream out2 = new JarOutputStream(new FileOutputStream(destFile));){
            this.unpack(in2, out2);
        }
    }
}

