/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.java.sql;

import java.sql.Time;
import java.util.TimeZone;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimeTest
extends TestCase {
    static long TIME_TEST1 = 38720000L;
    static long TIME_TEST2 = 80279000L;
    static long TIME_TEST3 = -38720000L;
    static String STRING_TEST1 = "10:45:20";
    static String STRING_TEST2 = "22:17:59";
    static String STRING_TEST3 = "13:14:40";
    static String STRING_INVALID1 = "ABCDEFGHI";
    static String STRING_INVALID2 = "233104";
    static String STRING_INVALID3 = "21-43-48";
    static String STRING_OUTRANGE = "35:99:66";
    static long[] TIME_ARRAY = new long[]{TIME_TEST1, TIME_TEST2, TIME_TEST3};
    static String[] STRING_GMT_ARRAY = new String[]{STRING_TEST1, STRING_TEST2, STRING_TEST3};
    static String[] STRING_LA_ARRAY = new String[]{"02:45:20", "14:17:59", "05:14:40"};
    static String[] STRING_JP_ARRAY = new String[]{"19:45:20", "07:17:59", "22:14:40"};
    static String[] INVALID_STRINGS = new String[]{STRING_INVALID1, STRING_INVALID2, STRING_INVALID3};
    static String TZ_LONDON = "GMT";
    static String TZ_PACIFIC = "America/Los_Angeles";
    static String TZ_JAPAN = "Asia/Tokyo";
    static String[] TIMEZONES = new String[]{TZ_LONDON, TZ_PACIFIC, TZ_JAPAN};
    static String[][] STRING_ARRAYS = new String[][]{STRING_GMT_ARRAY, STRING_LA_ARRAY, STRING_JP_ARRAY};

    public void testTimeintintint() {
        Time time = new Time(10, 45, 20);
        TimeTest.assertNotNull((Object)time);
    }

    public void testTime() {
        Time time = new Time(TIME_TEST1);
        TimeTest.assertNotNull((Object)time);
    }

    public void testToString() {
        int n = 0;
        while (n < TIME_ARRAY.length) {
            this.testToString(TIMEZONES[n], TIME_ARRAY, STRING_ARRAYS[n]);
            ++n;
        }
    }

    private void testToString(String string, long[] lArray, String[] stringArray) {
        TimeZone.setDefault(TimeZone.getTimeZone(string));
        int n = 0;
        while (n < lArray.length) {
            Time time = new Time(lArray[n]);
            String string2 = time.toString();
            TimeTest.assertEquals((String)stringArray[n], (String)string2);
            ++n;
        }
    }

    public void testValueOfString() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        Time[] timeArray = new Time[]{new Time(38720000L), new Time(80279000L), new Time(47680000L)};
        String[] stringArray = new String[]{"10:45:20", "22:17:59", "13:14:40"};
        String[] stringArray2 = new String[4];
        stringArray2[1] = "ABCDEFGHI";
        stringArray2[2] = "233104";
        stringArray2[3] = "21-43-48";
        String[] stringArray3 = stringArray2;
        int n = 0;
        while (n < stringArray.length) {
            Time time = Time.valueOf(stringArray[n]);
            TimeTest.assertEquals((Object)timeArray[n], (Object)time);
            ++n;
        }
        String[] stringArray4 = stringArray3;
        int n2 = 0;
        int n3 = stringArray4.length;
        while (n2 < n3) {
            String string = stringArray4[n2];
            try {
                Time.valueOf(string);
                TimeTest.fail((String)"Should throw IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void testSetTime() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        Time time = new Time(TIME_TEST1);
        TimeTest.assertEquals((String)STRING_TEST1, (String)time.toString());
        time.setTime(TIME_TEST2);
        TimeTest.assertEquals((String)STRING_TEST2, (String)time.toString());
    }

    public void testSetDate() {
        Time time = new Time(TIME_TEST1);
        try {
            time.setDate(10);
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetMonth() {
        Time time = new Time(TIME_TEST1);
        try {
            time.setMonth(2);
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetYear() {
        Time time = new Time(TIME_TEST1);
        try {
            time.setYear(99);
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetDate() {
        Time time = new Time(TIME_TEST1);
        try {
            time.getDate();
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetDay() {
        Time time = new Time(TIME_TEST1);
        try {
            time.getDay();
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetMonth() {
        Time time = new Time(TIME_TEST1);
        try {
            time.getMonth();
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetYear() {
        Time time = new Time(TIME_TEST1);
        try {
            time.getYear();
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_valueOf_IllegalArgumentException() {
        try {
            Time.valueOf("15:43:12:34");
            TimeTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Time.valueOf(":10:07:01");
            TimeTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Time.valueOf("::01");
            TimeTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Time.valueOf("11::");
            TimeTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Time.valueOf(":01:");
            TimeTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Time.valueOf(":10:w2:01");
            TimeTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Time.valueOf("07:w2:");
            TimeTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Time.valueOf("17:w2:w2");
            TimeTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Time.valueOf("16::01");
            TimeTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

