/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.pack200.tests.bytecode;

import junit.framework.TestCase;
import org.apache.harmony.pack200.bytecode.CPDouble;
import org.apache.harmony.pack200.bytecode.CPFloat;
import org.apache.harmony.pack200.bytecode.CPInteger;
import org.apache.harmony.pack200.bytecode.CPLong;
import org.apache.harmony.pack200.bytecode.CPMember;
import org.apache.harmony.pack200.bytecode.CPString;
import org.apache.harmony.pack200.bytecode.CPUTF8;
import org.apache.harmony.pack200.bytecode.SourceFileAttribute;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClassFileEntryTest
extends TestCase {
    public void testUTF8() {
        CPUTF8 u1 = new CPUTF8(new String("thing"));
        CPUTF8 u2 = new CPUTF8(new String("thing"));
        CPUTF8 u3 = new CPUTF8(new String("otherthing"));
        this.checkEquality((Object)u1, (Object)u2, "thing", (Object)u3);
    }

    private void checkEquality(Object equal1, Object equal2, String toString, Object unequal) {
        ClassFileEntryTest.assertEquals((Object)equal1, (Object)equal2);
        ClassFileEntryTest.assertEquals((int)equal1.hashCode(), (int)equal2.hashCode());
        ClassFileEntryTest.assertTrue((equal1.toString().indexOf(toString) >= 0 ? 1 : 0) != 0);
        ClassFileEntryTest.assertFalse((boolean)equal1.equals(unequal));
        ClassFileEntryTest.assertFalse((boolean)equal2.equals(unequal));
        ClassFileEntryTest.assertFalse((boolean)unequal.equals(equal1));
        ClassFileEntryTest.assertFalse((boolean)unequal.equals(equal2));
    }

    public void testSourceAttribute() {
        SourceFileAttribute sfa1 = new SourceFileAttribute(new String("Thing.java"));
        SourceFileAttribute sfa2 = new SourceFileAttribute(new String("Thing.java"));
        SourceFileAttribute sfa3 = new SourceFileAttribute(new String("OtherThing.java"));
        this.checkEquality((Object)sfa1, (Object)sfa2, "Thing.java", (Object)sfa3);
    }

    public void testCPInteger() {
        CPInteger cp1 = new CPInteger(new Integer(3));
        CPInteger cp2 = new CPInteger(new Integer(3));
        CPInteger cp3 = new CPInteger(new Integer(5));
        this.checkEquality((Object)cp1, (Object)cp2, "3", (Object)cp3);
    }

    public void testCPLong() {
        CPLong cp1 = new CPLong(new Long(3L));
        CPLong cp2 = new CPLong(new Long(3L));
        CPLong cp3 = new CPLong(new Long(5L));
        this.checkEquality((Object)cp1, (Object)cp2, "3", (Object)cp3);
    }

    public void testCPDouble() {
        CPDouble cp1 = new CPDouble(new Double(3.0));
        CPDouble cp2 = new CPDouble(new Double(3.0));
        CPDouble cp3 = new CPDouble(new Double(5.0));
        this.checkEquality((Object)cp1, (Object)cp2, "3", (Object)cp3);
    }

    public void testCPFloat() {
        CPFloat cp1 = new CPFloat(new Float(3.0f));
        CPFloat cp2 = new CPFloat(new Float(3.0f));
        CPFloat cp3 = new CPFloat(new Float(5.0f));
        this.checkEquality((Object)cp1, (Object)cp2, "3", (Object)cp3);
    }

    public void testCPString() {
        CPString cp1 = new CPString(new String("3"));
        CPString cp2 = new CPString(new String("3"));
        CPString cp3 = new CPString(new String("5"));
        this.checkEquality((Object)cp1, (Object)cp2, "3", (Object)cp3);
    }

    public void testCPField() {
        CPMember cp1 = new CPMember("Name:I", 0L, null);
        CPMember cp2 = new CPMember("Name:I", 0L, null);
        CPMember cp3 = new CPMember("Name:Z", 0L, null);
        CPMember cp4 = new CPMember("GName:I", 0L, null);
        this.checkEquality((Object)cp1, (Object)cp2, "Name", (Object)cp3);
        this.checkEquality((Object)cp1, (Object)cp2, "I", (Object)cp4);
    }
}

