/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.dbcp2.DelegatingCallableStatement;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.TesterCallableStatement;
import org.apache.commons.dbcp2.TesterConnection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDelegatingCallableStatement {
    private TesterConnection conn;
    private DelegatingCallableStatement delegate;
    private CallableStatement obj;

    @BeforeEach
    public void setUp() throws Exception {
        this.conn = new TesterConnection("test", "test");
        this.obj = (CallableStatement)Mockito.mock(CallableStatement.class);
        DelegatingConnection delegatingConnection = new DelegatingConnection((Connection)this.conn);
        this.delegate = new DelegatingCallableStatement(delegatingConnection, this.obj);
    }

    @Test
    void testExecuteQueryReturnsNotNull() throws Exception {
        TesterCallableStatement delegateStmt = new TesterCallableStatement(this.conn, "select * from foo");
        this.obj = new DelegatingCallableStatement(new DelegatingConnection((Connection)this.conn), (CallableStatement)delegateStmt);
        Assertions.assertNotNull((Object)this.obj.executeQuery());
    }

    @Test
    void testExecuteQueryReturnsNull() throws Exception {
        TesterCallableStatement delegateStmt = new TesterCallableStatement(this.conn, "null");
        this.obj = new DelegatingCallableStatement(new DelegatingConnection((Connection)this.conn), (CallableStatement)delegateStmt);
        Assertions.assertNull((Object)this.obj.executeQuery());
    }

    @Test
    void testGetArrayInteger() throws Exception {
        try {
            this.delegate.getArray(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getArray(1);
    }

    @Test
    void testGetArrayString() throws Exception {
        try {
            this.delegate.getArray("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getArray("foo");
    }

    @Test
    void testGetBigDecimalInteger() throws Exception {
        try {
            this.delegate.getBigDecimal(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBigDecimal(1);
    }

    @Test
    void testGetBigDecimalIntegerInteger() throws Exception {
        try {
            this.delegate.getBigDecimal(1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBigDecimal(1, 1);
    }

    @Test
    void testGetBigDecimalString() throws Exception {
        try {
            this.delegate.getBigDecimal("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBigDecimal("foo");
    }

    @Test
    void testGetBlobInteger() throws Exception {
        try {
            this.delegate.getBlob(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBlob(1);
    }

    @Test
    void testGetBlobString() throws Exception {
        try {
            this.delegate.getBlob("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBlob("foo");
    }

    @Test
    void testGetBooleanInteger() throws Exception {
        try {
            this.delegate.getBoolean(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBoolean(1);
    }

    @Test
    void testGetBooleanString() throws Exception {
        try {
            this.delegate.getBoolean("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBoolean("foo");
    }

    @Test
    void testGetByteInteger() throws Exception {
        try {
            this.delegate.getByte(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getByte(1);
    }

    @Test
    void testGetBytesInteger() throws Exception {
        try {
            this.delegate.getBytes(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBytes(1);
    }

    @Test
    void testGetBytesString() throws Exception {
        try {
            this.delegate.getBytes("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBytes("foo");
    }

    @Test
    void testGetByteString() throws Exception {
        try {
            this.delegate.getByte("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getByte("foo");
    }

    @Test
    void testGetCharacterStreamInteger() throws Exception {
        try {
            this.delegate.getCharacterStream(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getCharacterStream(1);
    }

    @Test
    void testGetCharacterStreamString() throws Exception {
        try {
            this.delegate.getCharacterStream("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getCharacterStream("foo");
    }

    @Test
    void testGetClobInteger() throws Exception {
        try {
            this.delegate.getClob(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getClob(1);
    }

    @Test
    void testGetClobString() throws Exception {
        try {
            this.delegate.getClob("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getClob("foo");
    }

    @Test
    void testGetDateInteger() throws Exception {
        try {
            this.delegate.getDate(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDate(1);
    }

    @Test
    void testGetDateIntegerCalendar() throws Exception {
        try {
            this.delegate.getDate(1, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDate(1, (Calendar)null);
    }

    @Test
    void testGetDateString() throws Exception {
        try {
            this.delegate.getDate("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDate("foo");
    }

    @Test
    void testGetDateStringCalendar() throws Exception {
        try {
            this.delegate.getDate("foo", (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDate("foo", (Calendar)null);
    }

    @Test
    void testGetDelegate() throws Exception {
        TesterCallableStatement delegateStmt = new TesterCallableStatement(this.conn, "select * from foo");
        this.obj = new DelegatingCallableStatement(new DelegatingConnection((Connection)this.conn), (CallableStatement)delegateStmt);
        Assertions.assertEquals((Object)delegateStmt, (Object)((DelegatingCallableStatement)this.obj).getDelegate());
    }

    @Test
    void testGetDoubleInteger() throws Exception {
        try {
            this.delegate.getDouble(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDouble(1);
    }

    @Test
    void testGetDoubleString() throws Exception {
        try {
            this.delegate.getDouble("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDouble("foo");
    }

    @Test
    void testGetFloatInteger() throws Exception {
        try {
            this.delegate.getFloat(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getFloat(1);
    }

    @Test
    void testGetFloatString() throws Exception {
        try {
            this.delegate.getFloat("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getFloat("foo");
    }

    @Test
    void testGetIntInteger() throws Exception {
        try {
            this.delegate.getInt(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getInt(1);
    }

    @Test
    void testGetIntString() throws Exception {
        try {
            this.delegate.getInt("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getInt("foo");
    }

    @Test
    void testGetLongInteger() throws Exception {
        try {
            this.delegate.getLong(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getLong(1);
    }

    @Test
    void testGetLongString() throws Exception {
        try {
            this.delegate.getLong("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getLong("foo");
    }

    @Test
    void testGetNCharacterStreamInteger() throws Exception {
        try {
            this.delegate.getNCharacterStream(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNCharacterStream(1);
    }

    @Test
    void testGetNCharacterStreamString() throws Exception {
        try {
            this.delegate.getNCharacterStream("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNCharacterStream("foo");
    }

    @Test
    void testGetNClobInteger() throws Exception {
        try {
            this.delegate.getNClob(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNClob(1);
    }

    @Test
    void testGetNClobString() throws Exception {
        try {
            this.delegate.getNClob("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNClob("foo");
    }

    @Test
    void testGetNStringInteger() throws Exception {
        try {
            this.delegate.getNString(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNString(1);
    }

    @Test
    void testGetNStringString() throws Exception {
        try {
            this.delegate.getNString("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNString("foo");
    }

    @Test
    void testGetObjectInteger() throws Exception {
        try {
            this.delegate.getObject(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getObject(1);
    }

    @Test
    void testGetObjectIntegerClass() throws Exception {
        try {
            this.delegate.getObject(1, Object.class);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getObject(1, Object.class);
    }

    @Test
    void testGetObjectIntegerMap() throws Exception {
        try {
            this.delegate.getObject(1, (Map)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getObject(1, (Map)null);
    }

    @Test
    void testGetObjectString() throws Exception {
        try {
            this.delegate.getObject("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getObject("foo");
    }

    @Test
    void testGetObjectStringClass() throws Exception {
        try {
            this.delegate.getObject("foo", Object.class);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getObject("foo", Object.class);
    }

    @Test
    void testGetObjectStringMap() throws Exception {
        try {
            this.delegate.getObject("foo", (Map)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getObject("foo", (Map)null);
    }

    @Test
    void testGetRefInteger() throws Exception {
        try {
            this.delegate.getRef(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getRef(1);
    }

    @Test
    void testGetRefString() throws Exception {
        try {
            this.delegate.getRef("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getRef("foo");
    }

    @Test
    void testGetRowIdInteger() throws Exception {
        try {
            this.delegate.getRowId(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getRowId(1);
    }

    @Test
    void testGetRowIdString() throws Exception {
        try {
            this.delegate.getRowId("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getRowId("foo");
    }

    @Test
    void testGetShortInteger() throws Exception {
        try {
            this.delegate.getShort(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getShort(1);
    }

    @Test
    void testGetShortString() throws Exception {
        try {
            this.delegate.getShort("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getShort("foo");
    }

    @Test
    void testGetSQLXMLInteger() throws Exception {
        try {
            this.delegate.getSQLXML(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSQLXML(1);
    }

    @Test
    void testGetSQLXMLString() throws Exception {
        try {
            this.delegate.getSQLXML("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSQLXML("foo");
    }

    @Test
    void testGetStringInteger() throws Exception {
        try {
            this.delegate.getString(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getString(1);
    }

    @Test
    void testGetStringString() throws Exception {
        try {
            this.delegate.getString("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getString("foo");
    }

    @Test
    void testGetTimeInteger() throws Exception {
        try {
            this.delegate.getTime(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTime(1);
    }

    @Test
    void testGetTimeIntegerCalendar() throws Exception {
        try {
            this.delegate.getTime(1, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTime(1, (Calendar)null);
    }

    @Test
    void testGetTimestampInteger() throws Exception {
        try {
            this.delegate.getTimestamp(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTimestamp(1);
    }

    @Test
    void testGetTimestampIntegerCalendar() throws Exception {
        try {
            this.delegate.getTimestamp(1, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTimestamp(1, (Calendar)null);
    }

    @Test
    void testGetTimestampString() throws Exception {
        try {
            this.delegate.getTimestamp("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTimestamp("foo");
    }

    @Test
    void testGetTimestampStringCalendar() throws Exception {
        try {
            this.delegate.getTimestamp("foo", (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTimestamp("foo", (Calendar)null);
    }

    @Test
    void testGetTimeString() throws Exception {
        try {
            this.delegate.getTime("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTime("foo");
    }

    @Test
    void testGetTimeStringCalendar() throws Exception {
        try {
            this.delegate.getTime("foo", (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTime("foo", (Calendar)null);
    }

    @Test
    void testGetURLInteger() throws Exception {
        try {
            this.delegate.getURL(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getURL(1);
    }

    @Test
    void testGetURLString() throws Exception {
        try {
            this.delegate.getURL("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getURL("foo");
    }

    @Test
    void testRegisterOutParameterIntegerInteger() throws Exception {
        try {
            this.delegate.registerOutParameter(1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, 1);
    }

    @Test
    void testRegisterOutParameterIntegerIntegerInteger() throws Exception {
        try {
            this.delegate.registerOutParameter(1, 1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, 1, 1);
    }

    @Test
    void testRegisterOutParameterIntegerIntegerString() throws Exception {
        try {
            this.delegate.registerOutParameter(1, 1, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, 1, "foo");
    }

    @Test
    void testRegisterOutParameterIntegerSQLType() throws Exception {
        try {
            this.delegate.registerOutParameter(1, (SQLType)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, (SQLType)null);
    }

    @Test
    void testRegisterOutParameterIntegerSQLTypeInteger() throws Exception {
        try {
            this.delegate.registerOutParameter(1, (SQLType)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, (SQLType)null, 1);
    }

    @Test
    void testRegisterOutParameterIntegerSQLTypeString() throws Exception {
        try {
            this.delegate.registerOutParameter(1, (SQLType)null, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, (SQLType)null, "foo");
    }

    @Test
    void testRegisterOutParameterStringInteger() throws Exception {
        try {
            this.delegate.registerOutParameter("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter("foo", 1);
    }

    @Test
    void testRegisterOutParameterStringIntegerInteger() throws Exception {
        try {
            this.delegate.registerOutParameter("foo", 1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter("foo", 1, 1);
    }

    @Test
    void testRegisterOutParameterStringIntegerString() throws Exception {
        try {
            this.delegate.registerOutParameter("foo", 1, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter("foo", 1, "foo");
    }

    @Test
    void testRegisterOutParameterStringSQLType() throws Exception {
        try {
            this.delegate.registerOutParameter("foo", (SQLType)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter("foo", (SQLType)null);
    }

    @Test
    void testRegisterOutParameterStringSQLTypeInteger() throws Exception {
        try {
            this.delegate.registerOutParameter("foo", (SQLType)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter("foo", (SQLType)null, 1);
    }

    @Test
    void testRegisterOutParameterStringSQLTypeString() throws Exception {
        try {
            this.delegate.registerOutParameter("foo", (SQLType)null, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter("foo", (SQLType)null, "foo");
    }

    @Test
    void testSetAsciiStreamStringInputStream() throws Exception {
        try {
            this.delegate.setAsciiStream("foo", (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setAsciiStream("foo", (InputStream)null);
    }

    @Test
    void testSetAsciiStreamStringInputStreamInteger() throws Exception {
        try {
            this.delegate.setAsciiStream("foo", (InputStream)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setAsciiStream("foo", (InputStream)null, 1);
    }

    @Test
    void testSetAsciiStreamStringInputStreamLong() throws Exception {
        try {
            this.delegate.setAsciiStream("foo", (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setAsciiStream("foo", (InputStream)null, 1L);
    }

    @Test
    void testSetBigDecimalStringBigDecimal() throws Exception {
        try {
            this.delegate.setBigDecimal("foo", BigDecimal.valueOf(1.0));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBigDecimal("foo", BigDecimal.valueOf(1.0));
    }

    @Test
    void testSetBinaryStreamStringInputStream() throws Exception {
        try {
            this.delegate.setBinaryStream("foo", (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBinaryStream("foo", (InputStream)null);
    }

    @Test
    void testSetBinaryStreamStringInputStreamInteger() throws Exception {
        try {
            this.delegate.setBinaryStream("foo", (InputStream)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBinaryStream("foo", (InputStream)null, 1);
    }

    @Test
    void testSetBinaryStreamStringInputStreamLong() throws Exception {
        try {
            this.delegate.setBinaryStream("foo", (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBinaryStream("foo", (InputStream)null, 1L);
    }

    @Test
    void testSetBlobStringBlob() throws Exception {
        try {
            this.delegate.setBlob("foo", (Blob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBlob("foo", (Blob)null);
    }

    @Test
    void testSetBlobStringInputStream() throws Exception {
        try {
            this.delegate.setBlob("foo", (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBlob("foo", (InputStream)null);
    }

    @Test
    void testSetBlobStringInputStreamLong() throws Exception {
        try {
            this.delegate.setBlob("foo", (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBlob("foo", (InputStream)null, 1L);
    }

    @Test
    void testSetBooleanStringBoolean() throws Exception {
        try {
            this.delegate.setBoolean("foo", Boolean.TRUE.booleanValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBoolean("foo", (boolean)Boolean.TRUE);
    }

    @Test
    void testSetBytesStringByteArray() throws Exception {
        try {
            this.delegate.setBytes("foo", new byte[]{1});
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBytes("foo", new byte[]{1});
    }

    @Test
    void testSetByteStringByte() throws Exception {
        try {
            this.delegate.setByte("foo", (byte)1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setByte("foo", (byte)1);
    }

    @Test
    void testSetCharacterStreamStringReader() throws Exception {
        try {
            this.delegate.setCharacterStream("foo", (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setCharacterStream("foo", (Reader)null);
    }

    @Test
    void testSetCharacterStreamStringReaderInteger() throws Exception {
        try {
            this.delegate.setCharacterStream("foo", (Reader)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setCharacterStream("foo", (Reader)null, 1);
    }

    @Test
    void testSetCharacterStreamStringReaderLong() throws Exception {
        try {
            this.delegate.setCharacterStream("foo", (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setCharacterStream("foo", (Reader)null, 1L);
    }

    @Test
    void testSetClobStringClob() throws Exception {
        try {
            this.delegate.setClob("foo", (Clob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setClob("foo", (Clob)null);
    }

    @Test
    void testSetClobStringReader() throws Exception {
        try {
            this.delegate.setClob("foo", (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setClob("foo", (Reader)null);
    }

    @Test
    void testSetClobStringReaderLong() throws Exception {
        try {
            this.delegate.setClob("foo", (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setClob("foo", (Reader)null, 1L);
    }

    @Test
    void testSetDateStringSqlDate() throws Exception {
        try {
            this.delegate.setDate("foo", new Date(1529827548745L));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setDate("foo", new Date(1529827548745L));
    }

    @Test
    void testSetDateStringSqlDateCalendar() throws Exception {
        try {
            this.delegate.setDate("foo", new Date(1529827548745L), (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setDate("foo", new Date(1529827548745L), (Calendar)null);
    }

    @Test
    void testSetDoubleStringDouble() throws Exception {
        try {
            this.delegate.setDouble("foo", 1.0);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setDouble("foo", 1.0);
    }

    @Test
    void testSetFloatStringFloat() throws Exception {
        try {
            this.delegate.setFloat("foo", 1.0f);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setFloat("foo", 1.0f);
    }

    @Test
    void testSetIntStringInteger() throws Exception {
        try {
            this.delegate.setInt("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setInt("foo", 1);
    }

    @Test
    void testSetLongStringLong() throws Exception {
        try {
            this.delegate.setLong("foo", 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setLong("foo", 1L);
    }

    @Test
    void testSetNCharacterStreamStringReader() throws Exception {
        try {
            this.delegate.setNCharacterStream("foo", (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNCharacterStream("foo", (Reader)null);
    }

    @Test
    void testSetNCharacterStreamStringReaderLong() throws Exception {
        try {
            this.delegate.setNCharacterStream("foo", (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNCharacterStream("foo", (Reader)null, 1L);
    }

    @Test
    void testSetNClobStringNClob() throws Exception {
        try {
            this.delegate.setNClob("foo", (NClob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNClob("foo", (NClob)null);
    }

    @Test
    void testSetNClobStringReader() throws Exception {
        try {
            this.delegate.setNClob("foo", (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNClob("foo", (Reader)null);
    }

    @Test
    void testSetNClobStringReaderLong() throws Exception {
        try {
            this.delegate.setNClob("foo", (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNClob("foo", (Reader)null, 1L);
    }

    @Test
    void testSetNStringStringString() throws Exception {
        try {
            this.delegate.setNString("foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNString("foo", "foo");
    }

    @Test
    void testSetNullStringInteger() throws Exception {
        try {
            this.delegate.setNull("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNull("foo", 1);
    }

    @Test
    void testSetNullStringIntegerString() throws Exception {
        try {
            this.delegate.setNull("foo", 1, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNull("foo", 1, "foo");
    }

    @Test
    void testSetObjectStringObject() throws Exception {
        try {
            this.delegate.setObject("foo", (Object)System.err);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject("foo", (Object)System.err);
    }

    @Test
    void testSetObjectStringObjectInteger() throws Exception {
        try {
            this.delegate.setObject("foo", (Object)System.err, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject("foo", (Object)System.err, 1);
    }

    @Test
    void testSetObjectStringObjectIntegerInteger() throws Exception {
        try {
            this.delegate.setObject("foo", (Object)System.err, 1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject("foo", (Object)System.err, 1, 1);
    }

    @Test
    void testSetObjectStringObjectSQLType() throws Exception {
        try {
            this.delegate.setObject("foo", (Object)System.err, (SQLType)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject("foo", (Object)System.err, (SQLType)null);
    }

    @Test
    void testSetObjectStringObjectSQLTypeInteger() throws Exception {
        try {
            this.delegate.setObject("foo", (Object)System.err, (SQLType)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject("foo", (Object)System.err, (SQLType)null, 1);
    }

    @Test
    void testSetRowIdStringRowId() throws Exception {
        try {
            this.delegate.setRowId("foo", (RowId)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setRowId("foo", (RowId)null);
    }

    @Test
    void testSetShortStringShort() throws Exception {
        try {
            this.delegate.setShort("foo", (short)1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setShort("foo", (short)1);
    }

    @Test
    void testSetSQLXMLStringSQLXML() throws Exception {
        try {
            this.delegate.setSQLXML("foo", (SQLXML)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setSQLXML("foo", (SQLXML)null);
    }

    @Test
    void testSetStringStringString() throws Exception {
        try {
            this.delegate.setString("foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setString("foo", "foo");
    }

    @Test
    void testSetTimestampStringTimestamp() throws Exception {
        try {
            this.delegate.setTimestamp("foo", (Timestamp)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setTimestamp("foo", (Timestamp)null);
    }

    @Test
    void testSetTimestampStringTimestampCalendar() throws Exception {
        try {
            this.delegate.setTimestamp("foo", (Timestamp)null, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setTimestamp("foo", (Timestamp)null, (Calendar)null);
    }

    @Test
    void testSetTimeStringTime() throws Exception {
        try {
            this.delegate.setTime("foo", (Time)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setTime("foo", (Time)null);
    }

    @Test
    void testSetTimeStringTimeCalendar() throws Exception {
        try {
            this.delegate.setTime("foo", (Time)null, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setTime("foo", (Time)null, (Calendar)null);
    }

    @Test
    void testSetURLStringUrl() throws Exception {
        try {
            this.delegate.setURL("foo", (URL)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setURL("foo", (URL)null);
    }

    @Test
    void testWasNull() throws Exception {
        try {
            this.delegate.wasNull();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).wasNull();
    }
}

