/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.functions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.JXPathInvalidAccessException;
import org.apache.commons.jxpath.util.TypeUtils;

public class ConstructorFunction
implements Function {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final Constructor constructor;

    public ConstructorFunction(Constructor constructor) {
        this.constructor = constructor;
    }

    @Override
    public Object invoke(ExpressionContext context, Object[] parameters) {
        try {
            if (parameters == null) {
                parameters = EMPTY_ARRAY;
            }
            int pi = 0;
            Class<?>[] types = this.constructor.getParameterTypes();
            if (types.length > 0 && ExpressionContext.class.isAssignableFrom(types[0])) {
                pi = 1;
            }
            Object[] args = new Object[parameters.length + pi];
            if (pi == 1) {
                args[0] = context;
            }
            for (int i = 0; i < parameters.length; ++i) {
                args[i + pi] = TypeUtils.convert(parameters[i], types[i + pi]);
            }
            return this.constructor.newInstance(args);
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            throw new JXPathInvalidAccessException("Cannot invoke constructor " + this.constructor, ex);
        }
    }
}

